/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client;

import com.google.common.collect.Lists;
import com.legacy.blue_skies.CommonProxy;
import com.legacy.blue_skies.blocks.BlocksSkies;
import com.legacy.blue_skies.blocks.util.ISkyColoredBlock;
import com.legacy.blue_skies.client.ClientEventHandler;
import com.legacy.blue_skies.client.gui.GuiSkyPortals;
import com.legacy.blue_skies.client.renders.RenderRegistry;
import com.legacy.blue_skies.client.renders.color.SkiesColors;
import com.legacy.blue_skies.client.sounds.SkiesMusicHandler;
import com.legacy.blue_skies.variables.VariableConstants;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStem;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;

public class ClientProxy
extends CommonProxy {
    private static List<Block> coloredBlocks = Lists.newArrayList();

    @Override
    public void preInitialization() {
        VariableConstants.registerEvent(new RenderRegistry());
        RenderRegistry.initEntities();
        RenderRegistry.initTileEntities();
    }

    @Override
    public void initialization() {
        SkiesColors.init();
        MinecraftForge.EVENT_BUS.register((Object)new GuiSkyPortals(Minecraft.func_71410_x()));
        ClientProxy.registerEvent(new SkiesMusicHandler());
        ClientProxy.registerEvent(new ClientEventHandler());
    }

    @Override
    public EntityPlayer getPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public void registerBlockColors() {
        BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
        blockColors.func_186722_a(new IBlockColor(){

            public int func_186720_a(IBlockState state, @Nullable IBlockAccess worldIn, @Nullable BlockPos pos, int tintIndex) {
                return worldIn != null && pos != null ? BiomeColorHelper.func_180286_a((IBlockAccess)worldIn, (BlockPos)pos) : ColorizerGrass.func_77480_a((double)0.5, (double)1.0);
            }
        }, new Block[]{BlocksSkies.turquoise_tallgrass, BlocksSkies.lunar_tallgrass});
        blockColors.func_186722_a(new IBlockColor(){

            public int func_186720_a(IBlockState state, @Nullable IBlockAccess worldIn, @Nullable BlockPos pos, int tintIndex) {
                int i = (Integer)state.func_177229_b((IProperty)BlockStem.field_176484_a);
                int j = i * 32;
                int k = 255 - i * 8;
                int l = i * 4;
                return j << 16 | k << 8 | l;
            }
        }, new Block[]{BlocksSkies.melon_stem, BlocksSkies.pumpkin_stem});
        for (Block block : coloredBlocks) {
            ISkyColoredBlock sblock = (ISkyColoredBlock)block;
            if (sblock.getBlockColor() == null) continue;
            Minecraft.func_71410_x().func_184125_al().func_186722_a(sblock.getBlockColor(), new Block[]{block});
        }
    }

    @Override
    public void registerSidedBlock(Block block) {
        if (block instanceof ISkyColoredBlock) {
            ISkyColoredBlock sblock = (ISkyColoredBlock)block;
            IProperty[] nonRenderingProperties = sblock.getNonRenderingProperties();
            if (nonRenderingProperties != null) {
                StateMap custom_mapper = new StateMap.Builder().func_178442_a(nonRenderingProperties).func_178441_a();
                ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)custom_mapper);
            }
            if (sblock.getBlockColor() != null || sblock.getItemColor() != null) {
                coloredBlocks.add(block);
            }
        }
    }
}

