/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client;

import com.legacy.blue_skies.capability.SkiesPlayer;
import com.legacy.blue_skies.client.gui.GuiArcInventory;
import com.legacy.blue_skies.client.gui.GuiDeveloperMenu;
import com.legacy.blue_skies.client.gui.GuiDonationMenu;
import com.legacy.blue_skies.client.gui.tabs.SkyTab;
import com.legacy.blue_skies.client.gui.tabs.TabArcs;
import com.legacy.blue_skies.client.gui.tabs.TabInventory;
import com.legacy.blue_skies.client.particle.ParticleDusk;
import com.legacy.blue_skies.items.arcs.ItemSkyArcs;
import com.legacy.blue_skies.items.util.EnumArcType;
import com.legacy.blue_skies.network.PacketSkyManager;
import com.legacy.blue_skies.network.packets.PacketOpenContainer;
import com.legacy.blue_skies.world.everbright.BrightWeatherRenderer;
import com.legacy.blue_skies.world.everdawn.DawnWeatherRenderer;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ClientEventHandler {
    private SkyTab inventoryButton;
    private SkyTab arcButton;
    private SkyTab donatorButton;
    private SkyTab devButton;

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world == null || !world.field_72995_K) {
            return;
        }
        IRenderHandler renderer = world.field_73011_w.getWeatherRenderer();
        if (renderer instanceof BrightWeatherRenderer) {
            ((BrightWeatherRenderer)renderer).onUpdate();
        } else if (renderer instanceof DawnWeatherRenderer) {
            ((DawnWeatherRenderer)renderer).onUpdate();
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && player.func_70093_af() && !SkiesPlayer.get((EntityPlayer)player).wearingRunicArc() && SkiesPlayer.get((EntityPlayer)player).wearingArc(EnumArcType.Dusk) && Math.random() > 0.85) {
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((Particle)new ParticleDusk(player.field_70170_p, player.field_70165_t, player.field_70163_u + new Random().nextDouble(), player.field_70161_v));
        }
    }

    @SubscribeEvent
    public void addInventoryTabs(GuiScreenEvent.InitGuiEvent.Post event) {
        GuiScreen screen = event.getGui();
        if (screen instanceof GuiInventory || screen instanceof GuiArcInventory || screen instanceof GuiDonationMenu) {
            int x = Minecraft.func_71410_x().field_71439_g.func_192035_E().func_192812_b() && !(screen instanceof GuiInventory) ? 77 : 0;
            this.inventoryButton = new TabInventory(250, (event.getGui().field_146294_l + 176) / 2 - x, (event.getGui().field_146295_m - 156) / 2, 28, 23);
            event.getButtonList().add(this.inventoryButton);
            this.arcButton = new TabArcs(251, (event.getGui().field_146294_l + 176) / 2 - x, (event.getGui().field_146295_m - 106) / 2, 28, 23);
            event.getButtonList().add(this.arcButton);
        }
    }

    @SubscribeEvent
    public void onUpdateGui(GuiScreenEvent event) {
        GuiScreen screen = event.getGui();
        if (screen instanceof GuiInventory || screen instanceof GuiArcInventory || screen instanceof GuiDonationMenu || screen instanceof GuiDeveloperMenu) {
            if (this.inventoryButton != null) {
                boolean bl = this.inventoryButton.field_146124_l = !(screen instanceof GuiInventory);
            }
            if (this.arcButton != null) {
                boolean bl = this.arcButton.field_146124_l = !(screen instanceof GuiArcInventory);
            }
            if (this.donatorButton != null) {
                this.donatorButton.field_146124_l = !(screen instanceof GuiDonationMenu);
            }
        }
    }

    @SubscribeEvent
    public void onTabClicked(GuiScreenEvent.ActionPerformedEvent.Pre event) {
        if (event.getButton() == this.inventoryButton) {
            PacketSkyManager.sendToServer(new PacketOpenContainer(-1));
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiInventory((EntityPlayer)Minecraft.func_71410_x().field_71439_g));
        } else if (event.getButton() == this.arcButton) {
            PacketSkyManager.sendToServer(new PacketOpenContainer(1));
        } else if (event.getButton() == this.devButton) {
            PacketSkyManager.sendToServer(new PacketOpenContainer(2));
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiDeveloperMenu());
        } else if (event.getButton() == this.donatorButton) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void afterTabClicked(GuiScreenEvent.ActionPerformedEvent.Post event) {
        GuiButton button = event.getButton();
        if (button != this.arcButton && button != this.donatorButton && button != this.devButton) {
            this.updateTabs(event);
        }
    }

    @SubscribeEvent
    public void onTabShifted(GuiScreenEvent.PotionShiftEvent event) {
        if (event.getGui() instanceof GuiInventory) {
            return;
        }
    }

    public void updateTabs(GuiScreenEvent.ActionPerformedEvent.Post event) {
        GuiScreen screen = event.getGui();
        if (screen instanceof GuiInventory || screen instanceof GuiArcInventory || screen instanceof GuiDonationMenu || screen instanceof GuiDeveloperMenu) {
            int x = (event.getGui().field_146294_l + 176) / 2;
            if (this.inventoryButton != null) {
                this.inventoryButton.setPosition(x, (event.getGui().field_146295_m - 156) / 2);
            }
            if (this.arcButton != null) {
                this.arcButton.setPosition(x, (event.getGui().field_146295_m - 106) / 2);
            }
            if (this.donatorButton != null) {
                this.donatorButton.setPosition(x, (event.getGui().field_146295_m - 51) / 2);
            }
        }
    }

    @SubscribeEvent
    public void onHoverItem(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.func_77973_b() instanceof ItemSkyArcs) {
            event.getToolTip().add(EnumArcType.get(stack.func_77960_j()).getBasicDesc());
            EntityPlayer parent = event.getEntityPlayer();
            if (parent != null && SkiesPlayer.get(parent).wearingArc(EnumArcType.Runic)) {
                event.getToolTip().remove(EnumArcType.get(stack.func_77960_j()).getBasicDesc());
                event.getToolTip().add(EnumArcType.get(stack.func_77960_j()).getRunicDesc());
            }
        }
    }
}

