/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.capability;

import com.legacy.blue_skies.SkiesConfig;
import com.legacy.blue_skies.entities.hostile.EntityArmoredFrostSpirit;
import com.legacy.blue_skies.entities.hostile.boss.EntityAlchemist;
import com.legacy.blue_skies.entities.hostile.boss.EntitySummoner;
import com.legacy.blue_skies.entities.util.ai.EntityAIBreedAnimal;
import com.legacy.blue_skies.entities.util.ai.EntityAIHarvestBerryBush;
import com.legacy.blue_skies.entities.util.ai.EntityAIHarvestSkiesFarmland;
import com.legacy.blue_skies.entities.util.ai.EntityAIShovelSnow;
import com.legacy.blue_skies.entities.villager.EntityVillagerWarrior;
import com.legacy.blue_skies.entities.villager.SkyVillagerProfessionRegistry;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHarvestFarmland;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.monster.EntityEvoker;
import net.minecraft.entity.monster.EntityHusk;
import net.minecraft.entity.monster.EntityIllusionIllager;
import net.minecraft.entity.monster.EntitySpellcasterIllager;
import net.minecraft.entity.monster.EntityVindicator;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.item.EnumDyeColor;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class SkiesEntityEvents {
    @SubscribeEvent
    public void onEntitySpawn(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityLiving) {
            this.spawnEvents((EntityLiving)event.getEntity(), (Event)event);
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity() instanceof EntityLiving) {
            this.entityUpdateEvents((EntityLiving)event.getEntity(), (Event)event);
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingDeathEvent event) {
        if (event.getEntity() instanceof EntityLiving) {
            this.entityDeathEvents((EntityLiving)event.getEntity(), (Event)event);
        }
    }

    private void spawnEvents(EntityLiving entity, Event event) {
        EntityWolf wolf;
        EntitySpellcasterIllager boss;
        EntityVillagerWarrior warrior;
        if (entity instanceof EntityVillager) {
            EntityVillager villager = (EntityVillager)entity;
            villager.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)villager, EntitySummoner.class, 8.0f, 0.6, 0.6));
            villager.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)villager, EntityAlchemist.class, 8.0f, 0.6, 0.6));
            villager.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)villager, EntityArmoredFrostSpirit.class, 8.0f, 0.6, 0.6));
            if (villager.func_70946_n() == 0 && !villager.func_70631_g_() || villager.func_70946_n() == 9 && !villager.func_70631_g_()) {
                villager.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIHarvestSkiesFarmland(villager, 0.6));
                villager.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIHarvestBerryBush(villager, 0.6));
            }
            if (villager.func_70946_n() == 9 && !villager.func_70631_g_()) {
                villager.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIHarvestFarmland(villager, 0.6));
                villager.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIBreedAnimal(villager));
            }
            if (villager.getProfessionForge() == SkyVillagerProfessionRegistry.shoveler && !villager.func_70631_g_()) {
                villager.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIShovelSnow(villager, 0.6));
            }
        }
        if (entity instanceof EntityZombie || entity instanceof EntityZombieVillager || entity instanceof EntityHusk || entity instanceof EntityIllusionIllager || entity instanceof EntityVindicator || entity instanceof EntityEvoker) {
            EntityCreature creature = (EntityCreature)entity;
            creature.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget(creature, EntityVillagerWarrior.class, false));
        }
        if (entity instanceof EntityVillagerWarrior && (warrior = (EntityVillagerWarrior)entity).getVillagerType() == 8 && !warrior.isArmored()) {
            warrior.randomGear();
        }
        if (entity instanceof EntitySummoner) {
            boss = (EntitySummoner)entity;
            if (!boss.field_70170_p.field_72995_K && !boss.func_110175_bO()) {
                boss.setHasHome(true);
                boss.setHome(boss.field_70165_t, boss.field_70163_u, boss.field_70161_v);
            }
        }
        if (entity instanceof EntityAlchemist) {
            boss = (EntityAlchemist)entity;
            if (!boss.field_70170_p.field_72995_K && !boss.func_110175_bO()) {
                boss.setHasHome(true);
                boss.setHome(boss.field_70165_t, boss.field_70163_u, boss.field_70161_v);
            }
        }
        if (entity instanceof EntityWolf && !(wolf = (EntityWolf)entity).func_70909_n() && wolf.field_71093_bK == SkiesConfig.dimension.everbright_dimension_id) {
            wolf.func_175547_a(EnumDyeColor.BLUE);
        }
    }

    private void entityUpdateEvents(EntityLiving entity, Event event) {
    }

    private void entityDeathEvents(EntityLiving entity, Event event) {
    }
}

