/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks.natural;

import com.legacy.blue_skies.blocks.BlocksSkies;
import com.legacy.blue_skies.world.everbright.biome.decoration.trees.WorldGenBluebrightTree;
import com.legacy.blue_skies.world.everbright.biome.decoration.trees.WorldGenStarlitTree;
import com.legacy.blue_skies.world.everdawn.biome.decoration.trees.WorldGenDuskTree;
import com.legacy.blue_skies.world.everdawn.biome.decoration.trees.WorldGenLunarTree;
import com.legacy.blue_skies.world.everdawn.biome.decoration.trees.WorldGenNectarineTree;
import com.legacy.blue_skies.world.gen.WorldGenCherryTree;
import com.legacy.blue_skies.world.structures.TreePlacer;
import com.legacy.blue_skies.world.structures.trees.FrostbrightTreeGenerator;
import com.legacy.blue_skies.world.structures.trees.LargeDuskTreeGenerator;
import com.legacy.blue_skies.world.structures.trees.MapleTreeGenerator;
import com.legacy.blue_skies.world.structures.trees.SunsetMapleTreeGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenBigTree;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraftforge.event.terraingen.TerrainGen;

public class BlockSkySapling
extends BlockBush
implements IGrowable {
    public static final PropertyInteger STAGE = PropertyInteger.func_177719_a((String)"stage", (int)0, (int)1);
    protected static final AxisAlignedBB SAPLING_AABB = new AxisAlignedBB(0.09999999403953552, 0.0, 0.09999999403953552, (double)0.9f, (double)0.8f, (double)0.9f);

    public BlockSkySapling() {
        super(Material.field_151585_k);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(0)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return SAPLING_AABB;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            super.func_180650_b(worldIn, pos, state, rand);
            if (worldIn.func_175671_l(pos.func_177984_a()) >= 9 && rand.nextInt(7) == 0) {
                this.func_176474_b(worldIn, rand, pos, state);
            }
        }
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        if ((Integer)state.func_177229_b((IProperty)STAGE) == 0) {
            worldIn.func_180501_a(pos, state.func_177231_a((IProperty)STAGE), 4);
        } else {
            this.generateTree(worldIn, pos, state, rand);
        }
    }

    public void generateTree(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!TerrainGen.saplingGrowTree((World)worldIn, (Random)rand, (BlockPos)pos)) {
            return;
        }
        Object worldgenerator = rand.nextInt(10) == 0 ? new WorldGenBigTree(true) : new WorldGenTrees(true);
        int i = 0;
        int j = 0;
        boolean bigTree = false;
        IBlockState sapling = Blocks.field_150345_g.func_176223_P();
        if (state.func_177230_c() == BlocksSkies.dusk_sapling) {
            state = BlocksSkies.dusk_log.func_176223_P();
            sapling = BlocksSkies.dusk_sapling.func_176223_P();
            for (i = 0; i >= -1; --i) {
                for (j = 0; j >= -1; --j) {
                    if (!this.isTwoByTwoOfType(worldIn, pos, i, j)) continue;
                    worldgenerator = new LargeDuskTreeGenerator(true, false);
                    bigTree = true;
                    break;
                }
                if (bigTree) break;
            }
            if (!bigTree) {
                i = 0;
                j = 0;
                worldgenerator = new WorldGenDuskTree(true, false, 5 + rand.nextInt(1));
            }
        }
        if (state.func_177230_c() == BlocksSkies.lunar_sapling) {
            state = BlocksSkies.lunar_log.func_176223_P();
            sapling = BlocksSkies.lunar_sapling.func_176223_P();
            worldgenerator = new WorldGenLunarTree(true, false, 5 + rand.nextInt(3));
        }
        if (state.func_177230_c() == BlocksSkies.maple_sapling) {
            state = BlocksSkies.maple_log.func_176223_P();
            sapling = BlocksSkies.maple_sapling.func_176223_P();
            TreePlacer treePlacer = worldgenerator = rand.nextBoolean() ? new SunsetMapleTreeGenerator(true, false) : new MapleTreeGenerator(true, false);
        }
        if (state.func_177230_c() == BlocksSkies.starlit_sapling) {
            state = BlocksSkies.starlit_log.func_176223_P();
            sapling = BlocksSkies.starlit_sapling.func_176223_P();
            worldgenerator = new WorldGenStarlitTree(true);
        }
        if (state.func_177230_c() == BlocksSkies.bluebright_sapling) {
            state = BlocksSkies.bluebright_log.func_176223_P();
            sapling = BlocksSkies.bluebright_sapling.func_176223_P();
            worldgenerator = new WorldGenBluebrightTree(true, false, 5 + rand.nextInt(3));
        }
        if (state.func_177230_c() == BlocksSkies.frostbright_sapling) {
            state = BlocksSkies.frostbright_log.func_176223_P();
            sapling = BlocksSkies.frostbright_sapling.func_176223_P();
            for (i = 0; i >= -1; --i) {
                for (j = 0; j >= -1; --j) {
                    if (!this.isTwoByTwoOfType(worldIn, pos, i, j)) continue;
                    worldgenerator = new FrostbrightTreeGenerator(true, false);
                    bigTree = true;
                    break;
                }
                if (bigTree) break;
            }
        }
        if (state.func_177230_c() == BlocksSkies.cherry_sapling) {
            state = BlocksSkies.cherry_log.func_176223_P();
            sapling = BlocksSkies.cherry_sapling.func_176223_P();
            worldgenerator = new WorldGenCherryTree(true, false, 8 + rand.nextInt(2));
        }
        if (state.func_177230_c() == BlocksSkies.nectarine_sapling) {
            state = BlocksSkies.dusk_log.func_176223_P();
            sapling = BlocksSkies.nectarine_sapling.func_176223_P();
            worldgenerator = new WorldGenNectarineTree(true, false);
        }
        if (worldgenerator.func_180709_b(worldIn, rand, pos.func_177982_a(i, 0, j))) {
            if (bigTree) {
                worldIn.func_180501_a(pos.func_177982_a(i, 0, j), state, 2);
                worldIn.func_180501_a(pos.func_177982_a(i + 1, 0, j), state, 2);
                worldIn.func_180501_a(pos.func_177982_a(i, 0, j + 1), state, 2);
                worldIn.func_180501_a(pos.func_177982_a(i + 1, 0, j + 1), state, 2);
            } else {
                worldIn.func_180501_a(pos, state, 2);
            }
        } else if (bigTree) {
            worldIn.func_180501_a(pos.func_177982_a(i, 0, j), sapling, 4);
            worldIn.func_180501_a(pos.func_177982_a(i + 1, 0, j), sapling, 4);
            worldIn.func_180501_a(pos.func_177982_a(i, 0, j + 1), sapling, 4);
            worldIn.func_180501_a(pos.func_177982_a(i + 1, 0, j + 1), sapling, 4);
        } else {
            worldIn.func_180501_a(pos, sapling, 4);
        }
    }

    private boolean isTwoByTwoOfType(World worldIn, BlockPos pos, int i, int j) {
        IBlockState sapling = worldIn.func_180495_p(pos);
        return this.saplingTypeAt(worldIn, pos.func_177982_a(i, 0, j)) == sapling.func_177230_c() && this.saplingTypeAt(worldIn, pos.func_177982_a(i + 1, 0, j)) == sapling.func_177230_c() && this.saplingTypeAt(worldIn, pos.func_177982_a(i, 0, j + 1)) == sapling.func_177230_c() && this.saplingTypeAt(worldIn, pos.func_177982_a(i + 1, 0, j + 1)) == sapling.func_177230_c();
    }

    public Block saplingTypeAt(World worldIn, BlockPos pos) {
        IBlockState sapling = worldIn.func_180495_p(pos);
        return sapling.func_177230_c();
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return (double)worldIn.field_73012_v.nextFloat() < 0.45;
    }

    protected boolean func_185514_i(IBlockState state) {
        if (state.func_177230_c() == Blocks.field_150391_bh) {
            return false;
        }
        return state.func_185904_a() == Material.field_151578_c || state.func_185904_a() == Material.field_151577_b;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf((meta & 8) >> 3));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        return i |= (Integer)state.func_177229_b((IProperty)STAGE) << 3;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{STAGE});
    }
}

