/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks.natural;

import com.legacy.blue_skies.blocks.BlocksSkies;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSkyRoot
extends Block {
    public static final PropertyEnum<EnumFacing> CONNECTION = PropertyEnum.func_177709_a((String)"connection", EnumFacing.class);
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)1);

    public BlockSkyRoot() {
        super(Material.field_151575_d);
        this.func_149675_a(true);
        this.func_149711_c(1.5f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)).func_177226_a(CONNECTION, (Comparable)EnumFacing.UP));
        this.func_149715_a(0.3f);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a(CONNECTION, (Comparable)EnumFacing.UP);
    }

    public BlockFaceShape func_193383_a(IBlockAccess access, IBlockState state, BlockPos pos, EnumFacing facing) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.CUTOUT;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b(CONNECTION)) {
            case EAST: {
                return new AxisAlignedBB(0.5, 0.0625, 0.5, 1.0, 0.875, 0.5);
            }
            case NORTH: {
                return new AxisAlignedBB(0.5, 0.0, 0.0, 0.5, 0.875, 0.5);
            }
            case SOUTH: {
                return new AxisAlignedBB(0.5, 0.0, 0.5, 0.5, 0.875, 1.0);
            }
            case WEST: {
                return new AxisAlignedBB(0.0, 0.0, 0.5, 0.5, 0.875, 0.5);
            }
        }
        return new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75);
    }

    public EnumPushReaction getMobilityFlag(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing[] enumfacing = EnumFacing.field_82609_l;
        return this.func_176223_P().func_177226_a(CONNECTION, (Comparable)enumfacing[meta / 2]).func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta % 2));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        for (EnumFacing enumfacing : EnumFacing.field_82609_l) {
            for (int a = 0; a < 2; ++a) {
                if (state.func_177229_b(CONNECTION) == enumfacing && (Integer)state.func_177229_b((IProperty)AGE) == a) {
                    return i;
                }
                ++i;
            }
        }
        return i;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE, CONNECTION});
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!this.canSurviveAt(worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
        }
        if ((Integer)state.func_177229_b((IProperty)AGE) == 0 && worldIn.func_175623_d(pos.func_177977_b())) {
            if (rand.nextInt(3) > 0) {
                this.growth(worldIn, pos, state, rand);
            } else {
                int age = 0;
                if (worldIn.func_180495_p(pos.func_177981_b(1)).func_177230_c() == this && worldIn.func_180495_p(pos.func_177981_b(2)).func_177230_c() == this) {
                    age = rand.nextBoolean() ? 1 : 0;
                }
                worldIn.func_175656_a(pos.func_177977_b(), this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(age)).func_177226_a(CONNECTION, (Comparable)EnumFacing.UP));
                worldIn.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(1)).func_177226_a(CONNECTION, (Comparable)EnumFacing.UP));
            }
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canSurviveAt(worldIn, pos)) {
            worldIn.func_175684_a(pos, (Block)this, 1);
        }
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        Block block2 = worldIn.func_180495_p(pos.func_177984_a()).func_177230_c();
        return super.func_176196_c(worldIn, pos) && this.canPlantOn(block2);
    }

    public boolean canSurviveAt(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        for (EnumFacing enumfacing : EnumFacing.field_82609_l) {
            if (state.func_177230_c() != this || !this.connectedBlockExists(worldIn, pos, enumfacing)) continue;
            return true;
        }
        return false;
    }

    private void growth(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        EnumFacing[] enumfacing = EnumFacing.field_82609_l;
        int i = rand.nextInt(4) + 2;
        BlockPos direction = pos.func_177972_a(enumfacing[i]);
        if (worldIn.func_175623_d(direction)) {
            IBlockState newState = state.func_177226_a(CONNECTION, (Comparable)enumfacing[i].func_176734_d()).func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(1));
            worldIn.func_175656_a(direction, newState);
        }
    }

    private boolean canPlantOn(Block block) {
        return block == Blocks.field_150348_b || block == BlocksSkies.turquoise_stone || block == BlocksSkies.lunar_stone;
    }

    private boolean connectedBlockExists(World worldIn, BlockPos pos, EnumFacing enumfacing) {
        IBlockState state = worldIn.func_180495_p(pos);
        if (this.canPlantOn(worldIn.func_180495_p(pos.func_177984_a()).func_177230_c()) && state.func_177229_b(CONNECTION) == EnumFacing.UP) {
            return true;
        }
        return state.func_177229_b(CONNECTION) == enumfacing && worldIn.func_180495_p(pos.func_177972_a(enumfacing)).func_177230_c() == this;
    }

    public static void generate(int x, int z, World worldIn, IBlockState state, Random rand) {
        for (int y = 0; y < 5; ++y) {
            BlockPos pos = new BlockPos(x + rand.nextInt(8) + 16, rand.nextInt(20) + 5, z + rand.nextInt(8) + 16);
            if (!worldIn.func_175623_d(pos) || worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() != BlocksSkies.lunar_stone) continue;
            worldIn.func_175656_a(pos, state);
        }
    }
}

