/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks.construction;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSkyPane
extends Block {
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    protected static final AxisAlignedBB[] AABB_BY_INDEX = new AxisAlignedBB[]{new AxisAlignedBB(0.4375, 0.0, 0.4375, 0.5625, 1.0, 0.5625), new AxisAlignedBB(0.4375, 0.0, 0.4375, 0.5625, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.4375, 0.5625, 1.0, 0.5625), new AxisAlignedBB(0.0, 0.0, 0.4375, 0.5625, 1.0, 1.0), new AxisAlignedBB(0.4375, 0.0, 0.0, 0.5625, 1.0, 0.5625), new AxisAlignedBB(0.4375, 0.0, 0.0, 0.5625, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.5625, 1.0, 0.5625), new AxisAlignedBB(0.0, 0.0, 0.0, 0.5625, 1.0, 1.0), new AxisAlignedBB(0.4375, 0.0, 0.4375, 1.0, 1.0, 0.5625), new AxisAlignedBB(0.4375, 0.0, 0.4375, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.4375, 1.0, 1.0, 0.5625), new AxisAlignedBB(0.0, 0.0, 0.4375, 1.0, 1.0, 1.0), new AxisAlignedBB(0.4375, 0.0, 0.0, 1.0, 1.0, 0.5625), new AxisAlignedBB(0.4375, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.5625), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)};

    public BlockSkyPane() {
        super(Material.field_151592_s);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)));
        this.func_149711_c(0.3f);
        this.func_149752_b(0.0f);
        this.func_149672_a(SoundType.field_185853_f);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean bool) {
        if (!bool) {
            state = this.func_176221_a(state, (IBlockAccess)worldIn, pos);
        }
        BlockSkyPane.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_BY_INDEX[0]);
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            BlockSkyPane.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_BY_INDEX[BlockSkyPane.getBoundingBoxIndex(EnumFacing.NORTH)]);
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            BlockSkyPane.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_BY_INDEX[BlockSkyPane.getBoundingBoxIndex(EnumFacing.SOUTH)]);
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            BlockSkyPane.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_BY_INDEX[BlockSkyPane.getBoundingBoxIndex(EnumFacing.EAST)]);
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            BlockSkyPane.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_BY_INDEX[BlockSkyPane.getBoundingBoxIndex(EnumFacing.WEST)]);
        }
    }

    private static int getBoundingBoxIndex(EnumFacing facing) {
        return 1 << facing.func_176736_b();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = this.func_176221_a(state, source, pos);
        return AABB_BY_INDEX[BlockSkyPane.getBoundingBoxIndex(state)];
    }

    private static int getBoundingBoxIndex(IBlockState state) {
        int i = 0;
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            i |= BlockSkyPane.getBoundingBoxIndex(EnumFacing.NORTH);
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            i |= BlockSkyPane.getBoundingBoxIndex(EnumFacing.EAST);
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            i |= BlockSkyPane.getBoundingBoxIndex(EnumFacing.SOUTH);
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            i |= BlockSkyPane.getBoundingBoxIndex(EnumFacing.WEST);
        }
        return i;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.attachesTo(worldIn, worldIn.func_180495_p(pos.func_177978_c()), pos.func_177978_c(), EnumFacing.SOUTH))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.attachesTo(worldIn, worldIn.func_180495_p(pos.func_177968_d()), pos.func_177968_d(), EnumFacing.NORTH))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.attachesTo(worldIn, worldIn.func_180495_p(pos.func_177976_e()), pos.func_177976_e(), EnumFacing.EAST))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.attachesTo(worldIn, worldIn.func_180495_p(pos.func_177974_f()), pos.func_177974_f(), EnumFacing.WEST)));
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return blockAccess.func_180495_p(pos.func_177972_a(side)).func_177230_c() == this ? false : super.func_176225_a(blockState, blockAccess, pos, side);
    }

    public final boolean attachesTo(IBlockAccess access, IBlockState state, BlockPos pos, EnumFacing facing) {
        Block block = state.func_177230_c();
        BlockFaceShape blockfaceshape = state.func_193401_d(access, pos, facing);
        return !BlockSkyPane.isExcepBlockForAttachWithPiston(block) && blockfaceshape == BlockFaceShape.SOLID || blockfaceshape == BlockFaceShape.MIDDLE_POLE_THIN;
    }

    protected static boolean isExcepBlockForAttachWithPiston(Block block) {
        return block instanceof BlockShulkerBox || block instanceof BlockLeaves || block == Blocks.field_150461_bJ || block == Blocks.field_150383_bp || block == Blocks.field_150426_aN || block == Blocks.field_150432_aD || block == Blocks.field_180398_cJ || block == Blocks.field_150331_J || block == Blocks.field_150320_F || block == Blocks.field_150332_K || block == Blocks.field_150440_ba || block == Blocks.field_150423_aK || block == Blocks.field_150428_aP || block == Blocks.field_180401_cv;
    }

    protected boolean func_149700_E() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                return state.func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)SOUTH)).func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)NORTH)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return state.func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)EAST)).func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)SOUTH)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)NORTH));
            }
            case CLOCKWISE_90: {
                return state.func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)NORTH)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)EAST)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)SOUTH));
            }
        }
        return state;
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                return state.func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)SOUTH)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)NORTH));
            }
            case FRONT_BACK: {
                return state.func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)EAST));
            }
        }
        return super.func_185471_a(state, mirrorIn);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, EAST, WEST, SOUTH});
    }

    public boolean canBeConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        Block connector = world.func_180495_p(pos.func_177972_a(facing)).func_177230_c();
        return connector instanceof BlockSkyPane;
    }

    public boolean canPaneConnectTo(IBlockAccess world, BlockPos pos, EnumFacing dir) {
        BlockPos other = pos.func_177972_a(dir);
        IBlockState state = world.func_180495_p(other);
        return state.func_177230_c().canBeConnectedTo(world, other, dir.func_176734_d()) || this.attachesTo(world, state, other, dir.func_176734_d());
    }

    public BlockFaceShape func_193383_a(IBlockAccess access, IBlockState state, BlockPos pos, EnumFacing facing) {
        return facing != EnumFacing.UP && facing != EnumFacing.DOWN ? BlockFaceShape.MIDDLE_POLE_THIN : BlockFaceShape.CENTER_SMALL;
    }
}

