/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.text;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.text.Span;
import vazkii.patchouli.client.book.text.SpanState;
import vazkii.patchouli.client.book.text.TextLayouter;
import vazkii.patchouli.client.book.text.Word;
import vazkii.patchouli.common.book.Book;

public class BookTextParser {
    private static final Map<String, CommandProcessor> COMMANDS = new HashMap<String, CommandProcessor>();
    private static final Map<String, FunctionProcessor> FUNCTIONS = new HashMap<String, FunctionProcessor>();
    private final GuiBook gui;
    private final Book book;
    private final int x;
    private final int y;
    private final int width;
    private final int lineHeight;
    private final int baseColor;
    private final FontRenderer font;
    private final int spaceWidth;

    private static void register(CommandProcessor handler, String ... names) {
        for (String name : names) {
            COMMANDS.put(name, handler);
        }
    }

    private static void register(FunctionProcessor function, String ... names) {
        for (String name : names) {
            FUNCTIONS.put(name, function);
        }
    }

    public BookTextParser(GuiBook gui, Book book, int x, int y, int width, int lineHeight, int baseColor) {
        this.gui = gui;
        this.book = book;
        this.x = x;
        this.y = y;
        this.width = width;
        this.lineHeight = lineHeight;
        this.baseColor = baseColor;
        this.font = gui.field_146297_k.field_71466_p;
        this.spaceWidth = this.font.func_78256_a(" ");
    }

    public List<Word> parse(String text) {
        String actualText;
        boolean wasUnicode = this.font.func_82883_a();
        if (!this.book.useBlockyFont) {
            this.font.func_78264_a(true);
        }
        if ((actualText = text) == null) {
            actualText = "[ERROR]";
        }
        for (String key : this.book.macros.keySet()) {
            actualText = actualText.replace(key, this.book.macros.get(key));
        }
        List<Span> spans = this.processCommands(actualText);
        List<Word> words = this.layout(spans);
        this.font.func_78264_a(wasUnicode);
        return words;
    }

    private List<Word> layout(List<Span> spans) {
        TextLayouter layouter = new TextLayouter(this.gui, this.x, this.y, this.lineHeight, this.width);
        layouter.layout(spans);
        return layouter.getWords();
    }

    private List<Span> processCommands(String text) {
        SpanState state = new SpanState(this.gui, this.book, this.baseColor, this.font);
        ArrayList<Span> spans = new ArrayList<Span>();
        int from = 0;
        char[] chars = text.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != '$' || i + 1 >= chars.length || chars[i + 1] != '(') continue;
            if (i > from) {
                spans.add(new Span(state, text.substring(from, i)));
            }
            from = i;
            while (i < chars.length && chars[i] != ')') {
                ++i;
            }
            if (i == chars.length) {
                spans.add(Span.error(state, "[ERROR: UNFINISHED COMMAND]"));
                break;
            }
            try {
                String processed = this.processCommand(state, text.substring(from + 2, i));
                if (!processed.isEmpty()) {
                    spans.add(new Span(state, processed));
                    if (state.cluster == null) {
                        state.tooltip = "";
                    }
                }
            }
            catch (Exception ex) {
                spans.add(Span.error(state, "[ERROR]"));
            }
            from = i + 1;
        }
        spans.add(new Span(state, text.substring(from)));
        return spans;
    }

    private String processCommand(SpanState state, String cmd) {
        state.endingExternal = false;
        String result = "";
        if (cmd.length() == 1 && cmd.matches("^[0123456789abcdef]$")) {
            state.color = this.font.func_175064_b(cmd.charAt(0));
            return "";
        }
        if (cmd.startsWith("#") && (cmd.length() == 4 || cmd.length() == 7)) {
            String parse = cmd.substring(1);
            if (parse.length() == 3) {
                parse = "" + parse.charAt(0) + parse.charAt(0) + parse.charAt(1) + parse.charAt(1) + parse.charAt(2) + parse.charAt(2);
            }
            try {
                state.color = Integer.parseInt(parse, 16);
            }
            catch (NumberFormatException e) {
                state.color = this.baseColor;
            }
            return "";
        }
        if (cmd.matches("li\\d?")) {
            char c = cmd.length() > 2 ? (char)cmd.charAt(2) : (char)'1';
            int dist = Character.isDigit(c) ? Character.digit(c, 10) : 1;
            int pad = dist * 4;
            char bullet = dist % 2 == 0 ? (char)'\u25e6' : '\u2022';
            state.lineBreaks = 1;
            state.spacingLeft = pad;
            state.spacingRight = this.spaceWidth;
            return TextFormatting.BLACK.toString() + bullet;
        }
        if (cmd.indexOf(58) > 0) {
            int index = cmd.indexOf(58);
            String function = cmd.substring(0, index);
            String parameter = cmd.substring(index + 1);
            result = FUNCTIONS.containsKey(function) ? FUNCTIONS.get(function).process(parameter, state) : "[MISSING FUNCTION: " + function + "]";
        } else if (COMMANDS.containsKey(cmd)) {
            result = COMMANDS.get(cmd).process(state);
        }
        if (state.endingExternal) {
            result = result + TextFormatting.GRAY + "\u21aa";
        }
        return result;
    }

    private static KeyBinding getKeybindKey(SpanState state, String keybind) {
        KeyBinding[] keys;
        String alt = "key." + keybind;
        for (KeyBinding k : keys = state.gui.field_146297_k.field_71474_y.field_74324_K) {
            String name = k.func_151464_g();
            if (!name.equals(keybind) && !name.equals(alt)) continue;
            return k;
        }
        return null;
    }

    static {
        BookTextParser.register((SpanState state) -> {
            state.lineBreaks = 1;
            return "";
        }, "br");
        BookTextParser.register((SpanState state) -> {
            state.lineBreaks = 2;
            return "";
        }, "br2", "2br", "p");
        BookTextParser.register((SpanState state) -> {
            state.endingExternal = state.isExternalLink;
            state.color = state.prevColor;
            state.cluster = null;
            state.tooltip = "";
            state.onClick = null;
            state.isExternalLink = false;
            return "";
        }, "/l");
        BookTextParser.register((SpanState state) -> {
            state.cluster = null;
            state.tooltip = "";
            return "";
        }, "/t");
        BookTextParser.register((SpanState state) -> state.gui.field_146297_k.field_71439_g.getDisplayNameString(), "playername");
        BookTextParser.register((SpanState state) -> state.codes("\u00a7k"), "k", "obf");
        BookTextParser.register((SpanState state) -> state.codes("\u00a7l"), "l", "bold");
        BookTextParser.register((SpanState state) -> state.codes("\u00a7m"), "m", "strike");
        BookTextParser.register((SpanState state) -> state.codes("\u00a7o"), "o", "italic", "italics");
        BookTextParser.register((SpanState state) -> {
            state.reset();
            return "";
        }, "", "reset", "clear");
        BookTextParser.register((SpanState state) -> state.color(state.font.func_175064_b('0')), "nocolor");
        BookTextParser.register((String parameter, SpanState state) -> {
            KeyBinding result = BookTextParser.getKeybindKey(state, parameter);
            if (result == null) {
                state.tooltip = I18n.func_135052_a((String)"patchouli.gui.lexicon.keybind_missing", (Object[])new Object[]{parameter});
                return "N/A";
            }
            state.tooltip = I18n.func_135052_a((String)"patchouli.gui.lexicon.keybind", (Object[])new Object[]{I18n.func_135052_a((String)result.func_151464_g(), (Object[])new Object[0])});
            return result.getDisplayName();
        }, "k");
        BookTextParser.register((String parameter, SpanState state) -> {
            state.cluster = new LinkedList<Span>();
            state.prevColor = state.color;
            state.color = state.book.linkColor;
            boolean isExternal = parameter.matches("^https?\\:.*");
            if (isExternal) {
                String url = parameter;
                state.tooltip = I18n.func_135052_a((String)"patchouli.gui.lexicon.external_link", (Object[])new Object[0]);
                state.isExternalLink = true;
                state.onClick = () -> GuiBook.openWebLink(url);
            } else {
                ResourceLocation href;
                BookEntry entry;
                int hash = parameter.indexOf(35);
                String anchor = null;
                if (hash >= 0) {
                    anchor = parameter.substring(hash + 1);
                    parameter = parameter.substring(0, hash);
                }
                if ((entry = state.book.contents.entries.get(href = new ResourceLocation(state.book.getModNamespace(), parameter))) != null) {
                    state.tooltip = entry.isLocked() ? TextFormatting.GRAY + I18n.func_135052_a((String)"patchouli.gui.lexicon.locked", (Object[])new Object[0]) : entry.getName();
                    GuiBook gui = state.gui;
                    Book book = state.book;
                    int page = 0;
                    if (anchor != null) {
                        int anchorPage = entry.getPageFromAnchor(anchor);
                        if (anchorPage >= 0) {
                            page = anchorPage / 2;
                        } else {
                            state.tooltip = state.tooltip + " (INVALID ANCHOR:" + anchor + ")";
                        }
                    }
                    int finalPage = page;
                    state.onClick = () -> {
                        GuiBookEntry entryGui = new GuiBookEntry(book, entry, finalPage);
                        gui.displayLexiconGui(entryGui, true);
                        GuiBook.playBookFlipSound(book);
                    };
                } else {
                    state.tooltip = "BAD LINK: " + parameter;
                }
            }
            return "";
        }, "l");
        BookTextParser.register((String parameter, SpanState state) -> {
            state.tooltip = parameter;
            state.cluster = new LinkedList<Span>();
            return "";
        }, "tooltip", "t");
    }

    public static interface FunctionProcessor {
        public String process(String var1, SpanState var2);
    }

    public static interface CommandProcessor {
        public String process(SpanState var1);
    }
}

