/*
 * Decompiled with CFR 0.152.
 */
package com.elseytd.theaurorian.World.Feature;

import com.elseytd.theaurorian.TABlocks;
import com.elseytd.theaurorian.TAUtil;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.structure.template.BlockRotationProcessor;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;

public class TAWorldGenerator_Trees_WeepingWillow
extends WorldGenAbstractTree {
    private static final ResourceLocation WILLOW_SMALL_1 = new ResourceLocation("theaurorian", "weepingwillow/willow_s1");
    private static final ResourceLocation WILLOW_SMALL_2 = new ResourceLocation("theaurorian", "weepingwillow/willow_s2");
    private static final ResourceLocation WILLOW_SMALL_3 = new ResourceLocation("theaurorian", "weepingwillow/willow_s3");
    private static final ResourceLocation WILLOW_LARGE_1 = new ResourceLocation("theaurorian", "weepingwillow/willow_l1");
    private static final ResourceLocation WILLOW_LARGE_2 = new ResourceLocation("theaurorian", "weepingwillow/willow_l2");

    public TAWorldGenerator_Trees_WeepingWillow(boolean notify) {
        super(notify);
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        if (TAUtil.randomChanceOf(0.3)) {
            return false;
        }
        boolean isSmall = TAUtil.randomChanceOf(0.75);
        for (int i = 0; i <= 4; ++i) {
            if (worldIn.func_175623_d(position.func_177981_b(i))) continue;
            return false;
        }
        IBlockState state = worldIn.func_180495_p(position.func_177977_b());
        if (state.func_177230_c() != TABlocks.Registry.AURORIANGRASSLIGHT.getBlock()) {
            return false;
        }
        state.func_177230_c().onPlantGrow(state, worldIn, position.func_177977_b(), position);
        PlacementSettings settings = new PlacementSettings().func_186220_a(this.getRandomRotation(rand)).func_186225_a(Blocks.field_150350_a);
        if (isSmall) {
            ResourceLocation template = this.getRandomResource(rand, new ResourceLocation[]{WILLOW_SMALL_1, WILLOW_SMALL_2, WILLOW_SMALL_3});
            Template willow = worldIn.func_72860_G().func_186340_h().func_186237_a(worldIn.func_73046_m(), template);
            BlockPos p = this.getPositionForPlacement(position, settings.func_186215_c(), 3);
            willow.func_189960_a(worldIn, p, (ITemplateProcessor)new BlockFillProcessor(p, settings, Blocks.field_150350_a), settings, 2);
        } else {
            ResourceLocation template = this.getRandomResource(rand, new ResourceLocation[]{WILLOW_LARGE_1, WILLOW_LARGE_2});
            Template willow = worldIn.func_72860_G().func_186340_h().func_186237_a(worldIn.func_73046_m(), template);
            BlockPos p = this.getPositionForPlacement(position, settings.func_186215_c(), 4);
            willow.func_189960_a(worldIn, p, (ITemplateProcessor)new BlockFillProcessor(p, settings, Blocks.field_150350_a), settings, 2);
        }
        return true;
    }

    private ResourceLocation getRandomResource(Random rand, ResourceLocation[] possible) {
        return possible[rand.nextInt(possible.length)];
    }

    private Rotation getRandomRotation(Random rand) {
        switch (rand.nextInt(4)) {
            default: {
                return Rotation.NONE;
            }
            case 1: {
                return Rotation.CLOCKWISE_90;
            }
            case 2: {
                return Rotation.CLOCKWISE_180;
            }
            case 3: 
        }
        return Rotation.COUNTERCLOCKWISE_90;
    }

    private BlockPos getPositionForPlacement(BlockPos position, Rotation r, int offset) {
        BlockPos p;
        switch (r) {
            default: {
                p = position.func_177982_a(-offset, 0, -offset);
                break;
            }
            case CLOCKWISE_90: {
                p = position.func_177982_a(offset, 0, -offset);
                break;
            }
            case CLOCKWISE_180: {
                p = position.func_177982_a(offset, 0, offset);
                break;
            }
            case COUNTERCLOCKWISE_90: {
                p = position.func_177982_a(-offset, 0, offset);
            }
        }
        return p;
    }

    class BlockFillProcessor
    extends BlockRotationProcessor {
        private Block fillBlock;

        public BlockFillProcessor(BlockPos pos, PlacementSettings settings, Block fill) {
            super(pos, settings);
            this.fillBlock = fill;
        }

        public Template.BlockInfo func_189943_a(World worldIn, BlockPos pos, Template.BlockInfo blockInfoIn) {
            if (worldIn.func_180495_p(pos).func_177230_c() != this.fillBlock) {
                return null;
            }
            return super.func_189943_a(worldIn, pos, blockInfoIn);
        }
    }
}

