/*
 * Decompiled with CFR 0.152.
 */
package com.elseytd.theaurorian;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;

public class TAUtil {
    public static boolean randomChanceOf(double percent) {
        Random r = new Random();
        double gen = r.nextDouble();
        return gen <= percent;
    }

    public static void renderAABBBounds(World worldIn, AxisAlignedBB aabb) {
        if (worldIn.field_72995_K) {
            for (double ix = aabb.field_72340_a; ix <= aabb.field_72336_d; ix += 1.0) {
                for (double iy = aabb.field_72338_b; iy <= aabb.field_72337_e; iy += 1.0) {
                    for (double iz = aabb.field_72339_c; iz <= aabb.field_72334_f; iz += 1.0) {
                        EnumParticleTypes particle = EnumParticleTypes.CLOUD;
                        if (ix == aabb.field_72340_a || ix == aabb.field_72336_d) {
                            worldIn.func_175688_a(particle, ix, iy, iz, 0.0, 0.0, 0.0, new int[0]);
                        }
                        if (iy == aabb.field_72338_b || iy == aabb.field_72337_e) {
                            worldIn.func_175688_a(particle, ix, iy, iz, 0.0, 0.0, 0.0, new int[0]);
                        }
                        if (iz != aabb.field_72339_c && iz != aabb.field_72334_f) continue;
                        worldIn.func_175688_a(particle, ix, iy, iz, 0.0, 0.0, 0.0, new int[0]);
                    }
                }
            }
        }
    }

    public static void simulateLootTable(World world, ResourceLocation lootTable, int rolls) {
        if (!world.field_72995_K) {
            TreeMap<Item, Integer> allItems = new TreeMap<Item, Integer>(new Comparator<Item>(){

                @Override
                public int compare(Item i1, Item i2) {
                    return new ItemStack(i1).func_82833_r().compareTo(new ItemStack(i2).func_82833_r());
                }
            });
            LootTable table = world.func_184146_ak().func_186521_a(lootTable);
            LootContext ctx = new LootContext.Builder((WorldServer)world).func_186471_a();
            for (int c = 1; c <= rolls; ++c) {
                List stacks = table.func_186462_a(world.field_73012_v, ctx);
                for (ItemStack item : stacks) {
                    if (allItems.containsKey(item.func_77973_b())) {
                        allItems.put(item.func_77973_b(), (Integer)allItems.get(item.func_77973_b()) + item.func_190916_E());
                        continue;
                    }
                    allItems.put(item.func_77973_b(), item.func_190916_E());
                }
            }
            System.out.println("==Loot Simulation:== (Rolls: " + rolls + ")");
            for (Map.Entry item : allItems.entrySet()) {
                System.out.println(String.format("%-30s%d", new ItemStack((Item)item.getKey()).func_82833_r(), item.getValue()));
            }
            System.out.println("===============================");
        }
    }
}

