/*
 * Decompiled with CFR 0.152.
 */
package jackyy.dimensionaledibles.block;

import jackyy.dimensionaledibles.block.BlockCakeBase;
import jackyy.dimensionaledibles.block.tile.TileDimensionCake;
import jackyy.dimensionaledibles.registry.ModConfig;
import jackyy.dimensionaledibles.util.TeleporterHandler;
import javax.annotation.Nonnull;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class BlockOverworldCake
extends BlockCakeBase
implements ITileEntityProvider {
    public BlockOverworldCake() {
        this.setRegistryName("dimensionaledibles:overworld_cake");
        this.func_149663_c("dimensionaledibles.overworld_cake");
    }

    @Override
    protected BlockPos calculateCoordinates(EntityPlayerMP player) {
        if (ModConfig.tweaks.overworldCake.useWorldSpawn) {
            return this.getWordSpawnPos(player);
        }
        return TeleporterHandler.getDimPos(player, this.cakeDimension(), player.func_180425_c());
    }

    private BlockPos getWordSpawnPos(EntityPlayerMP player) {
        WorldServer overworld = player.field_71133_b.func_184103_al().func_72365_p().func_71218_a(this.cakeDimension());
        return overworld.func_175672_r(overworld.func_175694_M());
    }

    public TileEntity func_149915_a(@Nonnull World worldIn, int meta) {
        return new TileDimensionCake(this.cakeDimension(), "Overworld");
    }

    @Override
    protected ModConfig.CakeConfig config() {
        return ModConfig.tweaks.overworldCake;
    }

    @Override
    protected int cakeDimension() {
        return 0;
    }

    @Override
    public boolean registerItem() {
        return ModConfig.general.overworldCake;
    }

    @Override
    @Nonnull
    protected ItemStack defaultFuel() {
        return new ItemStack(Blocks.field_150345_g, 1, 0);
    }
}

