/*
 * Decompiled with CFR 0.152.
 */
package jackyy.dimensionaledibles.block;

import jackyy.dimensionaledibles.DimensionalEdibles;
import jackyy.dimensionaledibles.item.ItemBlockCustomCake;
import jackyy.dimensionaledibles.registry.ModConfig;
import jackyy.dimensionaledibles.util.ITOPInfoProvider;
import jackyy.dimensionaledibles.util.IWailaInfoProvider;
import jackyy.dimensionaledibles.util.TeleporterHandler;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockCakeBase
extends Block
implements ITOPInfoProvider,
IWailaInfoProvider {
    public static final int MAX_BITES = 6;
    public static final PropertyInteger BITES = PropertyInteger.func_177719_a((String)"bites", (int)0, (int)6);
    public static final AxisAlignedBB[] CAKE_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.5, 0.9375), new AxisAlignedBB(0.1875, 0.0, 0.0625, 0.9375, 0.5, 0.9375), new AxisAlignedBB(0.3125, 0.0, 0.0625, 0.9375, 0.5, 0.9375), new AxisAlignedBB(0.4375, 0.0, 0.0625, 0.9375, 0.5, 0.9375), new AxisAlignedBB(0.5625, 0.0, 0.0625, 0.9375, 0.5, 0.9375), new AxisAlignedBB(0.6875, 0.0, 0.0625, 0.9375, 0.5, 0.9375), new AxisAlignedBB(0.8125, 0.0, 0.0625, 0.9375, 0.5, 0.9375)};

    public BlockCakeBase() {
        super(Material.field_151568_F);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BITES, (Comparable)Integer.valueOf(0)));
        this.func_149675_a(true);
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_149647_a(DimensionalEdibles.TAB);
    }

    protected abstract ModConfig.CakeConfig config();

    protected abstract int cakeDimension();

    protected abstract boolean registerItem();

    @Nonnull
    protected abstract ItemStack defaultFuel();

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return CAKE_AABB[(Integer)state.func_177229_b((IProperty)BITES)];
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return state.func_185890_d((IBlockAccess)worldIn, pos);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        int meta = this.func_176201_c(worldIn.func_180495_p(pos)) - 1;
        int fuelUntilFull = this.func_176201_c(state);
        ItemStack stack = playerIn.func_184586_b(hand);
        if (!stack.func_190926_b() && ItemStack.func_179545_c((ItemStack)stack, (ItemStack)this.getFuelItemStack(this.cakeDimension())) && fuelUntilFull != 0) {
            if (meta >= 0) {
                worldIn.func_180501_a(pos, state.func_177226_a((IProperty)BITES, (Comparable)Integer.valueOf(meta)), 2);
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                return true;
            }
        } else if (worldIn.field_73011_w.getDimension() != this.cakeDimension()) {
            if (!worldIn.field_72995_K) {
                if (playerIn.field_71075_bZ.field_75098_d || !this.config().consumesFuel()) {
                    this.teleportPlayer(worldIn, playerIn);
                } else {
                    this.consumeCake(worldIn, pos, playerIn);
                }
            }
            return true;
        }
        return false;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && this.canBlockStay(worldIn, pos);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canBlockStay(worldIn, pos)) {
            worldIn.func_175698_g(pos);
        }
    }

    private boolean canBlockStay(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_185904_a().func_76220_a();
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BITES, (Comparable)Integer.valueOf(meta));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)BITES);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BITES});
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return (7 - (Integer)blockState.func_177229_b((IProperty)BITES)) * 2;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        String fuel;
        ItemStack fuelStack = this.getFuelItemStack(this.cakeDimension());
        String string = fuel = fuelStack.func_190926_b() ? I18n.func_135052_a((String)"tooltip.dimensionaledibles.custom_cake.bad_config", (Object[])new Object[0]) : I18n.func_135052_a((String)(fuelStack.func_77977_a() + ".name"), (Object[])new Object[0]);
        if (world.func_180495_p(data.getPos()).func_177230_c() instanceof BlockCakeBase) {
            probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(new ItemStack(Items.field_151105_aU)).text(TextFormatting.GREEN + "Bites: ").progress(6 - (Integer)blockState.func_177229_b((IProperty)BITES), 6);
            probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).item(fuelStack.func_190926_b() ? new ItemStack(Blocks.field_180401_cv) : fuelStack).text(TextFormatting.GREEN + "Refill: " + fuel);
        }
    }

    @Override
    public List<String> getWailaBody(ItemStack itemStack, List<String> currentTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        String fuel;
        ItemStack fuelStack = this.getFuelItemStack(this.cakeDimension());
        String string = fuel = fuelStack.func_190926_b() ? I18n.func_135052_a((String)"tooltip.dimensionaledibles.custom_cake.bad_config", (Object[])new Object[0]) : I18n.func_135052_a((String)(fuelStack.func_77977_a() + ".name"), (Object[])new Object[0]);
        if (accessor.getBlockState().func_177230_c() instanceof BlockCakeBase) {
            currentTip.add(TextFormatting.GRAY + "Bites: " + (6 - (Integer)accessor.getBlockState().func_177229_b((IProperty)BITES)) + " / " + 6);
            currentTip.add(TextFormatting.GRAY + "Refill: " + fuel);
        }
        return currentTip;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)BITES, (Comparable)Integer.valueOf(this.config().preFueled() ? 0 : 6));
    }

    protected void teleportPlayer(World world, EntityPlayer player) {
        EntityPlayerMP playerMP = (EntityPlayerMP)player;
        BlockPos coords = this.config().useCustomCoordinates(this.cakeDimension()) ? this.config().customCoords(this.cakeDimension()).toBlockPos() : this.calculateCoordinates(playerMP);
        TeleporterHandler.updateDimPos((EntityPlayer)playerMP, world.field_73011_w.getDimension(), playerMP.func_180425_c());
        TeleporterHandler.teleport(playerMP, this.cakeDimension(), coords, playerMP.field_71133_b.func_184103_al());
    }

    protected BlockPos calculateCoordinates(EntityPlayerMP player) {
        return TeleporterHandler.getDimPos(player, this.cakeDimension(), player.func_180425_c());
    }

    protected void consumeCake(World world, BlockPos pos, EntityPlayer player) {
        int l;
        if (player.func_71043_e(true) && (l = ((Integer)world.func_180495_p(pos).func_177229_b((IProperty)BITES)).intValue()) < 6) {
            player.func_71024_bL().func_75122_a(2, 0.1f);
            world.func_180501_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)BITES, (Comparable)Integer.valueOf(l + 1)), 3);
            this.teleportPlayer(world, player);
        }
    }

    private ItemStack getFuelItemStack(int dim) {
        String fuel = this.config().fuel(dim);
        if (fuel == null || fuel.equals("")) {
            DimensionalEdibles.logger.error("Could not parse fuel for cake (dimension \"{}\"). Falling back to default fuel.", (Object)dim);
            return this.defaultFuel();
        }
        Item configItem = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(fuel));
        return configItem == null ? this.defaultFuel() : new ItemStack(configItem);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.registerItem()) {
            list.add((Object)new ItemStack((Block)this));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        ItemStack fuelStack = this.getFuelItemStack(ItemBlockCustomCake.getDimID(stack));
        if (fuelStack == ItemStack.field_190927_a) {
            tooltip.add(I18n.func_135052_a((String)"tooltip.dimensionaledibles.custom_cake.bad_config", (Object[])new Object[0]));
        } else {
            tooltip.add(I18n.func_135052_a((String)"tooltip.dimensionaledibles.cake", (Object[])new Object[]{I18n.func_135052_a((String)(fuelStack.func_77977_a() + ".name"), (Object[])new Object[0])}));
        }
    }
}

