/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.miningdimension.corelib.fluid;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class FluidUtils {
    public static boolean isFluidHandler(LevelAccessor world, BlockPos pos, Direction direction) {
        return FluidUtils.getFluidHandler(world, pos, direction) != null;
    }

    public static boolean isFluidHandlerOffset(LevelAccessor world, BlockPos pos, Direction direction) {
        return FluidUtils.getFluidHandlerOffset(world, pos, direction) != null;
    }

    @Nullable
    public static IFluidHandler getFluidHandler(LevelAccessor world, BlockPos pos, Direction direction) {
        BlockEntity te = world.m_7702_(pos);
        if (te == null) {
            return null;
        }
        return (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, direction).orElse(null);
    }

    @Nullable
    public static IFluidHandler getFluidHandlerOffset(LevelAccessor world, BlockPos pos, Direction direction) {
        return FluidUtils.getFluidHandler(world, pos.m_142300_(direction), direction.m_122424_());
    }

    public static FluidStack tryFluidTransfer(IFluidHandler fluidDestination, IFluidHandler fluidSource, int maxAmount, boolean doTransfer, @Nullable Fluid filter) {
        int fillableAmount;
        FluidStack drainable = filter == null ? fluidSource.drain(maxAmount, IFluidHandler.FluidAction.SIMULATE) : fluidSource.drain(new FluidStack(filter, maxAmount), IFluidHandler.FluidAction.SIMULATE);
        if (drainable.getAmount() > 0 && (fillableAmount = fluidDestination.fill(drainable, IFluidHandler.FluidAction.SIMULATE)) > 0) {
            if (doTransfer) {
                FluidStack drained = filter == null ? fluidSource.drain(fillableAmount, IFluidHandler.FluidAction.EXECUTE) : fluidSource.drain(new FluidStack(filter, fillableAmount), IFluidHandler.FluidAction.EXECUTE);
                drained.setAmount(fluidDestination.fill(drained, IFluidHandler.FluidAction.EXECUTE));
                return drained;
            }
            drainable.setAmount(fillableAmount);
            return drainable;
        }
        return FluidStack.EMPTY;
    }

    public static FluidStack tryFluidTransfer(IFluidHandler fluidDestination, IFluidHandler fluidSource, int maxAmount, boolean doTransfer) {
        return FluidUtil.tryFluidTransfer((IFluidHandler)fluidDestination, (IFluidHandler)fluidSource, (int)maxAmount, (boolean)doTransfer);
    }

    public static boolean tryFluidInteraction(Player player, InteractionHand hand, Level world, BlockPos pos) {
        ItemStack stack = player.m_21120_(hand);
        FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)stack).orElse(FluidStack.EMPTY);
        if (!fluidStack.isEmpty() && FluidUtils.handleEmpty((LevelAccessor)world, pos, player, hand)) {
            return true;
        }
        IFluidHandler handler = (IFluidHandler)FluidUtil.getFluidHandler((ItemStack)stack).orElse(null);
        return handler != null && FluidUtils.handleFill((LevelAccessor)world, pos, player, hand);
    }

    public static boolean handleEmpty(LevelAccessor world, BlockPos pos, Player player, InteractionHand hand) {
        BlockEntity te = world.m_7702_(pos);
        if (!(te instanceof IFluidHandler)) {
            return false;
        }
        IFluidHandler handler = (IFluidHandler)te;
        InvWrapper inv = new InvWrapper((Container)player.m_150109_());
        ItemStack stack = player.m_21120_(hand);
        FluidActionResult res = FluidUtil.tryEmptyContainerAndStow((ItemStack)stack, (IFluidHandler)handler, (IItemHandler)inv, (int)Integer.MAX_VALUE, (Player)player, (boolean)true);
        if (res.isSuccess()) {
            player.m_21008_(hand, res.result);
            return true;
        }
        return false;
    }

    public static boolean handleFill(LevelAccessor world, BlockPos pos, Player player, InteractionHand hand) {
        BlockEntity te = world.m_7702_(pos);
        if (!(te instanceof IFluidHandler)) {
            return false;
        }
        IFluidHandler blockHandler = (IFluidHandler)te;
        InvWrapper inv = new InvWrapper((Container)player.m_150109_());
        ItemStack stack = player.m_21120_(hand);
        FluidActionResult result = FluidUtil.tryFillContainerAndStow((ItemStack)stack, (IFluidHandler)blockHandler, (IItemHandler)inv, (int)Integer.MAX_VALUE, (Player)player, (boolean)true);
        if (result.isSuccess()) {
            player.m_21008_(hand, result.result);
            return true;
        }
        return false;
    }
}

