/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.mushroomtower;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import twilightforest.TwilightForestMod;
import twilightforest.util.RotationUtil;
import twilightforest.world.components.structures.TFStructureComponentOld;
import twilightforest.world.components.structures.lichtower.TowerWingComponent;
import twilightforest.world.components.structures.mushroomtower.MushroomTowerBridgeComponent;
import twilightforest.world.components.structures.mushroomtower.MushroomTowerMainBridgeComponent;
import twilightforest.world.components.structures.mushroomtower.MushroomTowerPieces;
import twilightforest.world.components.structures.mushroomtower.TowerRoofMushroomComponent;
import twilightforest.world.registration.TFFeature;

public class MushroomTowerWingComponent
extends TowerWingComponent {
    private static final int RANGE = 200;
    protected static final int FLOOR_HEIGHT = 4;
    protected static final int MAIN_SIZE = 15;
    boolean hasBase = false;
    public boolean isAscender = false;

    public MushroomTowerWingComponent(StructurePieceSerializationContext ctx, CompoundTag nbt) {
        this(MushroomTowerPieces.TFMTWin, nbt);
    }

    public MushroomTowerWingComponent(StructurePieceType piece, CompoundTag nbt) {
        super(piece, nbt);
        this.hasBase = nbt.m_128471_("hasBase");
        this.isAscender = nbt.m_128471_("isAscender");
    }

    protected MushroomTowerWingComponent(StructurePieceType piece, TFFeature feature, int i, int x, int y, int z, int pSize, int pHeight, Direction direction) {
        super(piece, feature, i, x, y, z, pSize, pHeight, direction);
    }

    @Override
    protected void m_183620_(StructurePieceSerializationContext ctx, CompoundTag tagCompound) {
        super.m_183620_(ctx, tagCompound);
        tagCompound.m_128379_("hasBase", this.hasBase);
        tagCompound.m_128379_("isAscender", this.isAscender);
    }

    @Override
    public void m_142537_(StructurePiece parent, StructurePieceAccessor list, Random rand) {
        if (parent != null && parent instanceof TFStructureComponentOld) {
            this.deco = ((TFStructureComponentOld)parent).deco;
        }
        this.addOpening(0, 1, this.size / 2, Rotation.CLOCKWISE_180);
        boolean bl = this.hasBase = this.size > 3;
        if (this.isAscender) {
            int[] dest = this.getValidOpening(rand, Rotation.CLOCKWISE_180);
            dest[1] = this.height - 3;
            int childHeight = (rand.nextInt(3) + rand.nextInt(3) + 2) * 4 + 1;
            boolean madeIt = this.makeMainBridge(list, rand, this.m_73548_() + 1, dest[0], dest[1], dest[2], childHeight, Rotation.CLOCKWISE_180);
            if (!madeIt) {
                TwilightForestMod.LOGGER.info("Did not make bridge back to new main");
            } else {
                TwilightForestMod.LOGGER.debug("Made bridge back to new main");
            }
        }
        if (this.m_73548_() < 5 && this.size > 6) {
            for (Rotation i : RotationUtil.ROTATIONS) {
                if (this.size < 15 && i == Rotation.CLOCKWISE_180) continue;
                int[] dest = this.getValidOpening(rand, i);
                int childHeight = (rand.nextInt(2) + rand.nextInt(2) + 2) * 4 + 1;
                this.makeBridge(list, rand, this.m_73548_() + 1, dest[0], dest[1], dest[2], this.size - 4, childHeight, i);
            }
        }
        if (this.isHighest(this.f_73383_, this.size, list) || !this.hasBase) {
            this.makeARoof(parent, list, rand);
        }
    }

    private boolean isOutOfRange(StructurePiece parent, int nx, int nz, int range) {
        BoundingBox sbb = parent.m_73547_();
        int centerX = sbb.m_162395_() + (sbb.m_162399_() - sbb.m_162395_() + 1) / 2;
        int centerZ = sbb.m_162398_() + (sbb.m_162401_() - sbb.m_162398_() + 1) / 2;
        return Math.abs(nx - centerX) > range || Math.abs(nz - centerZ) > range;
    }

    @Override
    public boolean makeTowerWing(StructurePieceAccessor list, Random rand, int index, int x, int y, int z, int wingSize, int wingHeight, Rotation rotation) {
        MushroomTowerWingComponent wing;
        StructurePiece intersect;
        Direction direction = this.getStructureRelativeRotation(rotation);
        int[] dx = this.offsetTowerCoords(x, y, z, wingSize, direction);
        if (this.isOutOfRange(this, dx[0], dx[2], 200)) {
            return false;
        }
        if (wingSize > 3) {
            dx = this.adjustCoordinates(dx[0], dx[1], dx[2], wingSize, direction, list);
        }
        if ((intersect = list.m_141921_((wing = new MushroomTowerWingComponent(MushroomTowerPieces.TFMTWin, this.getFeatureType(), index, dx[0], dx[1], dx[2], wingSize, wingHeight, direction)).m_73547_())) == null || intersect == this || intersect instanceof TowerRoofMushroomComponent) {
            if (this instanceof MushroomTowerBridgeComponent && this.isAscender) {
                wing.isAscender = true;
            }
            list.m_142679_((StructurePiece)wing);
            wing.m_142537_(this, list, rand);
            this.addOpening(x, y, z, rotation);
            return true;
        }
        return false;
    }

    protected int[] adjustCoordinates(int x, int y, int z, int wingSize, Direction direction, StructurePieceAccessor list) {
        if (list instanceof StructurePiecesBuilder) {
            StructurePiecesBuilder start = (StructurePiecesBuilder)list;
            for (StructurePiece obj : start.f_192778_) {
                int[] nArray;
                if (!(obj instanceof TowerWingComponent) || obj instanceof MushroomTowerBridgeComponent) continue;
                TowerWingComponent otherWing = (TowerWingComponent)obj;
                if (wingSize != otherWing.size || !otherWing.m_73547_().m_71019_(x - 3, z - 3, x + 3, z + 3)) continue;
                switch (direction) {
                    case SOUTH: {
                        int[] nArray2 = new int[3];
                        nArray2[0] = otherWing.m_73547_().m_162395_();
                        nArray2[1] = y;
                        nArray = nArray2;
                        nArray2[2] = otherWing.m_73547_().m_162398_();
                        break;
                    }
                    case WEST: {
                        int[] nArray3 = new int[3];
                        nArray3[0] = otherWing.m_73547_().m_162399_();
                        nArray3[1] = y;
                        nArray = nArray3;
                        nArray3[2] = otherWing.m_73547_().m_162398_();
                        break;
                    }
                    case NORTH: {
                        int[] nArray4 = new int[3];
                        nArray4[0] = otherWing.m_73547_().m_162399_();
                        nArray4[1] = y;
                        nArray = nArray4;
                        nArray4[2] = otherWing.m_73547_().m_162401_();
                        break;
                    }
                    case EAST: {
                        int[] nArray5 = new int[3];
                        nArray5[0] = otherWing.m_73547_().m_162395_();
                        nArray5[1] = y;
                        nArray = nArray5;
                        nArray5[2] = otherWing.m_73547_().m_162401_();
                        break;
                    }
                    default: {
                        int[] nArray6 = new int[3];
                        nArray6[0] = x;
                        nArray6[1] = y;
                        nArray = nArray6;
                        nArray6[2] = z;
                    }
                }
                return nArray;
            }
        }
        return new int[]{x, y, z};
    }

    private boolean isHighest(BoundingBox boundingBox, int size, StructurePieceAccessor list) {
        BoundingBox boxAbove = new BoundingBox(boundingBox.m_162395_(), boundingBox.m_162396_(), boundingBox.m_162398_(), boundingBox.m_162399_(), 256, boundingBox.m_162401_());
        if (list instanceof StructurePiecesBuilder) {
            StructurePiecesBuilder start = (StructurePiecesBuilder)list;
            for (StructurePiece obj : start.f_192778_) {
                if (this == obj || !(obj instanceof TowerWingComponent) || obj instanceof MushroomTowerBridgeComponent) continue;
                TowerWingComponent otherWing = (TowerWingComponent)obj;
                if (size != otherWing.size || !otherWing.m_73547_().m_71049_(boxAbove)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void makeARoof(StructurePiece parent, StructurePieceAccessor list, Random rand) {
        TowerRoofMushroomComponent roof = new TowerRoofMushroomComponent(this.getFeatureType(), this.m_73548_() + 1, this, 1.6f, this.m_142171_().m_123341_(), this.m_142171_().m_123342_(), this.m_142171_().m_123343_());
        if (!(list.m_141921_(roof.m_73547_()) instanceof TowerRoofMushroomComponent) && !(list.m_141921_((roof = new TowerRoofMushroomComponent(this.getFeatureType(), this.m_73548_() + 1, this, 1.0f, this.m_142171_().m_123341_(), this.m_142171_().m_123342_(), this.m_142171_().m_123343_())).m_73547_()) instanceof TowerRoofMushroomComponent)) {
            roof = new TowerRoofMushroomComponent(this.getFeatureType(), this.m_73548_() + 1, this, 0.6f, this.m_142171_().m_123341_(), this.m_142171_().m_123342_(), this.m_142171_().m_123343_());
        }
        list.m_142679_((StructurePiece)roof);
        roof.m_142537_(this, list, rand);
    }

    @Override
    protected boolean makeBridge(StructurePieceAccessor list, Random rand, int index, int x, int y, int z, int wingSize, int wingHeight, Rotation rotation) {
        return this.makeBridge(list, rand, index, x, y, z, wingSize, wingHeight, rotation, false);
    }

    protected boolean makeBridge(StructurePieceAccessor list, Random rand, int index, int x, int y, int z, int wingSize, int wingHeight, Rotation rotation, boolean ascender) {
        Direction direction = this.getStructureRelativeRotation(rotation);
        int[] dx = this.offsetTowerCoords(x, y, z, 3, direction);
        if (wingSize == 3) {
            wingHeight = 4;
        }
        MushroomTowerBridgeComponent bridge = new MushroomTowerBridgeComponent(MushroomTowerPieces.TFMTBri, this.getFeatureType(), index, dx[0], dx[1], dx[2], wingSize, wingHeight, direction);
        bridge.isAscender = ascender;
        StructurePiece intersect = list.m_141921_(bridge.m_73547_());
        if (intersect != null && intersect != this) {
            return false;
        }
        intersect = list.m_141921_(bridge.getWingBB());
        if (intersect == null || intersect == this) {
            list.m_142679_((StructurePiece)bridge);
            bridge.m_142537_(this, list, rand);
            this.addOpening(x, y, z, rotation);
            return true;
        }
        return false;
    }

    private boolean makeMainBridge(StructurePieceAccessor list, Random rand, int index, int x, int y, int z, int wingHeight, Rotation rotation) {
        Direction direction = this.getStructureRelativeRotation(rotation);
        int[] dx = this.offsetTowerCoords(x, y, z, 3, direction);
        MushroomTowerMainBridgeComponent bridge = new MushroomTowerMainBridgeComponent(this.getFeatureType(), index, dx[0], dx[1], dx[2], wingHeight, direction);
        list.m_142679_((StructurePiece)bridge);
        bridge.m_142537_(this, list, rand);
        this.addOpening(x, y, z, rotation);
        return true;
    }

    @Override
    public int[] getValidOpening(Random rand, Rotation direction) {
        int wLength = Math.min(this.size / 3, 3);
        int offset = (this.size - wLength) / 2;
        if (direction == Rotation.NONE || direction == Rotation.CLOCKWISE_180) {
            int rx = direction == Rotation.NONE ? this.size - 1 : 0;
            int rz = offset + rand.nextInt(wLength);
            int ry = this.getYByStairs(rz, rand, direction);
            return new int[]{rx, ry, rz};
        }
        if (direction == Rotation.CLOCKWISE_90 || direction == Rotation.COUNTERCLOCKWISE_90) {
            int rx = offset + rand.nextInt(wLength);
            int rz = direction == Rotation.CLOCKWISE_90 ? this.size - 1 : 0;
            int ry = this.getYByStairs(rx, rand, direction);
            return new int[]{rx, ry, rz};
        }
        return new int[]{0, 0, 0};
    }

    @Override
    protected int getYByStairs(int rx, Random rand, Rotation direction) {
        int floors = this.height / 4;
        return 5 + rand.nextInt(floors - 1) * 4;
    }

    @Override
    public void m_183269_(WorldGenLevel world, StructureFeatureManager manager, ChunkGenerator generator, Random rand, BoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        this.makeTrunk(world, sbb);
        this.makeFloorsForTower(world, sbb);
        this.makeOpenings(world, sbb);
    }

    private void makeTrunk(WorldGenLevel world, BoundingBox sbb) {
        int diameter = this.size / 2;
        int hollow = (int)((double)diameter * 0.8);
        for (int dx = -diameter; dx <= diameter; ++dx) {
            for (int dz = -diameter; dz <= diameter; ++dz) {
                int az;
                int ax = Math.abs(dx);
                int dist = (int)((double)Math.max(ax, az = Math.abs(dz)) + (double)Math.min(ax, az) * 0.4);
                if (dist > diameter) continue;
                this.m_73434_(world, this.deco.floorState, dx + diameter, 0, dz + diameter, sbb);
                this.m_73434_(world, this.deco.floorState, dx + diameter, this.height, dz + diameter, sbb);
                if (dist > hollow) {
                    for (dy = 0; dy <= this.height; ++dy) {
                        this.m_73434_(world, this.deco.blockState, dx + diameter, dy, dz + diameter, sbb);
                    }
                } else {
                    for (dy = 1; dy <= this.height - 1; ++dy) {
                        this.m_73434_(world, AIR, dx + diameter, dy, dz + diameter, sbb);
                    }
                }
                if (!this.hasBase) continue;
                this.m_73528_(world, this.deco.blockState, dx + diameter, -1, dz + diameter, sbb);
            }
        }
    }

    private void makeFloorsForTower(WorldGenLevel world, BoundingBox sbb) {
        int floors = this.height / 4;
        for (int i = 0; i < floors; ++i) {
            this.placeFloor(world, i * 4, sbb);
        }
    }

    private void placeFloor(WorldGenLevel world, int dy, BoundingBox sbb) {
        int diameter = this.size / 2;
        int hollow = (int)((double)diameter * 0.8);
        for (int dx = -diameter; dx <= diameter; ++dx) {
            for (int dz = -diameter; dz <= diameter; ++dz) {
                int az;
                int ax = Math.abs(dx);
                int dist = (int)((double)Math.max(ax, az = Math.abs(dz)) + (double)Math.min(ax, az) * 0.4);
                if (dist > hollow) continue;
                this.m_73434_(world, this.isAscender ? Blocks.f_50743_.m_49966_() : this.deco.floorState, dx + diameter, dy, dz + diameter, sbb);
            }
        }
    }

    @Override
    protected void makeDoorOpening(WorldGenLevel world, int dx, int dy, int dz, BoundingBox sbb) {
        super.makeDoorOpening(world, dx, dy, dz, sbb);
        if (this.m_73398_((BlockGetter)world, dx, dy + 2, dz, sbb).m_60734_() != Blocks.f_50016_) {
            this.m_73434_(world, this.deco.accentState, dx, dy + 2, dz, sbb);
        }
    }

    @Override
    protected void decorateFloor(WorldGenLevel world, Random rand, int floor, int bottom, int top, Rotation ladderUpDir, Rotation ladderDownDir, BoundingBox sbb) {
    }
}

