/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.trees.treeplacers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import twilightforest.util.FeaturePlacers;
import twilightforest.world.registration.TwilightFeatures;

public class LeafSpheroidFoliagePlacer
extends FoliagePlacer {
    public static final Codec<LeafSpheroidFoliagePlacer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)16.0f).fieldOf("horizontal_radius").forGetter(o -> Float.valueOf(o.horizontalRadius)), (App)Codec.floatRange((float)0.0f, (float)16.0f).fieldOf("vertical_radius").forGetter(o -> Float.valueOf(o.verticalRadius)), (App)IntProvider.m_146545_((int)0, (int)8).fieldOf("offset").forGetter(obj -> obj.f_68521_), (App)Codec.intRange((int)0, (int)16).fieldOf("random_add_horizontal").orElse((Object)0).forGetter(o -> o.randomHorizontal), (App)Codec.intRange((int)0, (int)16).fieldOf("random_add_vertical").orElse((Object)0).forGetter(o -> o.randomVertical), (App)Codec.floatRange((float)-0.5f, (float)0.5f).fieldOf("vertical_filler_bias").orElse((Object)Float.valueOf(0.0f)).forGetter(o -> Float.valueOf(o.verticalBias)), (App)Codec.intRange((int)0, (int)256).fieldOf("shag_factor").orElse((Object)0).forGetter(o -> o.shag_factor)).apply((Applicative)instance, LeafSpheroidFoliagePlacer::new));
    private final float horizontalRadius;
    private final float verticalRadius;
    private final float verticalBias;
    private final int randomHorizontal;
    private final int randomVertical;
    private final int shag_factor;

    public LeafSpheroidFoliagePlacer(float horizontalRadius, float verticalRadius, IntProvider yOffset, int randomHorizontal, int randomVertical, float verticalBias, int shag_factor) {
        super((IntProvider)ConstantInt.m_146483_((int)((int)horizontalRadius)), yOffset);
        this.horizontalRadius = horizontalRadius;
        this.verticalRadius = verticalRadius;
        this.randomHorizontal = randomHorizontal;
        this.randomVertical = randomVertical;
        this.verticalBias = verticalBias;
        this.shag_factor = shag_factor;
    }

    protected FoliagePlacerType<LeafSpheroidFoliagePlacer> m_5897_() {
        return (FoliagePlacerType)TwilightFeatures.FOLIAGE_SPHEROID.get();
    }

    protected void m_142539_(LevelSimulatedReader worldReader, BiConsumer<BlockPos, BlockState> worldPlacer, Random random, TreeConfiguration baseTreeFeatureConfig, int trunkHeight, FoliagePlacer.FoliageAttachment foliage, int foliageHeight, int radius, int offset) {
        BlockPos center = foliage.m_161451_().m_6630_(offset);
        FeaturePlacers.placeSpheroid(worldReader, worldPlacer, FeaturePlacers.VALID_TREE_POS, random, center, (float)foliage.m_68589_() + this.horizontalRadius + (float)random.nextInt(this.randomHorizontal + 1), (float)foliage.m_68589_() + this.verticalRadius + (float)random.nextInt(this.randomVertical + 1), this.verticalBias, baseTreeFeatureConfig.f_161213_);
        if (this.shag_factor > 0) {
            for (int i = 0; i < this.shag_factor; ++i) {
                float randomYaw = random.nextFloat() * ((float)Math.PI * 2);
                float randomPitch = random.nextFloat() * 2.0f - 1.0f;
                float yUnit = Mth.m_14116_((float)(1.0f - randomPitch * randomPitch));
                float xCircleOffset = yUnit * Mth.m_14089_((float)randomYaw) * (this.horizontalRadius - 1.0f);
                float zCircleOffset = yUnit * Mth.m_14031_((float)randomYaw) * (this.horizontalRadius - 1.0f);
                BlockPos placement = center.m_142022_((double)(xCircleOffset + (float)((int)xCircleOffset >> 31)), (double)(randomPitch * (this.verticalRadius + 0.25f) + this.verticalBias), (double)(zCircleOffset + (float)((int)zCircleOffset >> 31)));
                LeafSpheroidFoliagePlacer.placeLeafCluster(worldReader, worldPlacer, random, placement.m_7949_(), baseTreeFeatureConfig.f_161213_);
            }
        }
    }

    private static void placeLeafCluster(LevelSimulatedReader worldReader, BiConsumer<BlockPos, BlockState> worldPlacer, Random random, BlockPos pos, BlockStateProvider state) {
        FeaturePlacers.placeProvidedBlock(worldReader, worldPlacer, FeaturePlacers.VALID_TREE_POS, pos, state, random);
        FeaturePlacers.placeProvidedBlock(worldReader, worldPlacer, FeaturePlacers.VALID_TREE_POS, pos.m_142126_(), state, random);
        FeaturePlacers.placeProvidedBlock(worldReader, worldPlacer, FeaturePlacers.VALID_TREE_POS, pos.m_142128_(), state, random);
        FeaturePlacers.placeProvidedBlock(worldReader, worldPlacer, FeaturePlacers.VALID_TREE_POS, pos.m_142082_(1, 0, 1), state, random);
    }

    public int m_5969_(Random random, int i, TreeConfiguration baseTreeFeatureConfig) {
        return 0;
    }

    protected boolean m_7394_(Random random, int i, int i1, int i2, int i3, boolean b) {
        return false;
    }
}

