/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;
import twilightforest.block.entity.MoonwormBlockEntity;
import twilightforest.client.BugModelAnimationHelper;

public class MoonwormModel
extends Model {
    private final ModelPart shape1;
    private final ModelPart shape2;
    private final ModelPart shape3;
    private final ModelPart head;

    public MoonwormModel(ModelPart root) {
        super(RenderType::m_110458_);
        this.head = root.m_171324_("head");
        this.shape1 = root.m_171324_("shape1");
        this.shape2 = root.m_171324_("shape2");
        this.shape3 = root.m_171324_("shape3");
    }

    public static LayerDefinition create() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("shape1", CubeListBuilder.m_171558_().m_171514_(0, 4).m_171481_(-1.0f, -1.0f, -1.0f, 4.0f, 2.0f, 2.0f), PartPose.m_171419_((float)-1.0f, (float)7.0f, (float)3.0f));
        partdefinition.m_171599_("shape2", CubeListBuilder.m_171558_().m_171514_(0, 8).m_171481_(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 4.0f), PartPose.m_171419_((float)3.0f, (float)7.0f, (float)0.0f));
        partdefinition.m_171599_("shape3", CubeListBuilder.m_171558_().m_171514_(0, 14).m_171481_(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.m_171419_((float)2.0f, (float)7.0f, (float)-2.0f));
        partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.m_171419_((float)-3.0f, (float)7.0f, (float)2.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setRotationAngles(@Nullable MoonwormBlockEntity moonworm, float partialTime) {
        this.head.f_104201_ = 7.0f;
        this.shape1.f_104201_ = 7.0f;
        this.shape2.f_104201_ = 7.0f;
        this.shape3.f_104201_ = 7.0f;
        if (moonworm != null && moonworm.yawDelay == 0) {
            float time = (float)(moonworm.desiredYaw - moonworm.currentYaw) - partialTime;
            this.head.f_104201_ += Math.min(0.0f, Mth.m_14031_((float)(time / 2.0f)));
            this.shape1.f_104201_ += Math.min(0.0f, Mth.m_14031_((float)(time / 2.0f + 1.0f)));
            this.shape2.f_104201_ += Math.min(0.0f, Mth.m_14031_((float)(time / 2.0f + 2.0f)));
            this.shape3.f_104201_ += Math.min(0.0f, Mth.m_14031_((float)(time / 2.0f + 3.0f)));
        } else if (moonworm == null && BugModelAnimationHelper.yawWriggleDelay == 0) {
            float time = (float)(BugModelAnimationHelper.desiredRotation - BugModelAnimationHelper.currentRotation) - partialTime;
            this.head.f_104201_ += Math.min(0.0f, Mth.m_14031_((float)(time / 2.0f)));
            this.shape1.f_104201_ += Math.min(0.0f, Mth.m_14031_((float)(time / 2.0f + 1.0f)));
            this.shape2.f_104201_ += Math.min(0.0f, Mth.m_14031_((float)(time / 2.0f + 2.0f)));
            this.shape3.f_104201_ += Math.min(0.0f, Mth.m_14031_((float)(time / 2.0f + 3.0f)));
        }
    }

    public void m_7695_(PoseStack ms, VertexConsumer buffer, int light, int overlay, float r, float g, float b, float a) {
        this.shape1.m_104306_(ms, buffer, light, overlay, r, g, b, a);
        this.shape2.m_104306_(ms, buffer, light, overlay, r, g, b, a);
        this.shape3.m_104306_(ms, buffer, light, overlay, r, g, b, a);
        this.head.m_104306_(ms, buffer, light, overlay, r, g, b, a);
    }
}

