/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import twilightforest.TFSounds;
import twilightforest.block.TFPlantBlock;
import twilightforest.item.TFItems;
import twilightforest.util.TFStats;

public class TorchberryPlantBlock
extends TFPlantBlock
implements BonemealableBlock {
    public static final BooleanProperty HAS_BERRIES = BooleanProperty.m_61465_((String)"has_torchberries");
    private static final VoxelShape TORCHBERRY_SHAPE = TorchberryPlantBlock.m_49796_((double)1.0, (double)2.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public TorchberryPlantBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)HAS_BERRIES, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return TFPlantBlock.canPlaceRootAt(world, pos);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter access, BlockPos pos, CollisionContext context) {
        return TORCHBERRY_SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (((Boolean)state.m_61143_((Property)HAS_BERRIES)).booleanValue()) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)HAS_BERRIES, (Comparable)Boolean.valueOf(false)));
            level.m_5594_(null, pos, TFSounds.PICKED_TORCHBERRIES, SoundSource.BLOCKS, 1.0f, 1.0f);
            ItemEntity torchberries = new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), new ItemStack((ItemLike)TFItems.TORCHBERRIES.get()));
            level.m_7967_((Entity)torchberries);
            if (player instanceof ServerPlayer) {
                player.m_36220_((ResourceLocation)TFStats.TORCHBERRIES_HARVESTED.get());
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return super.m_6227_(state, level, pos, player, hand, result);
    }

    @Override
    public boolean m_7370_(BlockGetter level, BlockPos pos, BlockState state, boolean isClient) {
        return (Boolean)state.m_61143_((Property)HAS_BERRIES) == false;
    }

    @Override
    public boolean m_5491_(Level level, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    @Override
    public void m_7719_(ServerLevel level, Random rand, BlockPos pos, BlockState state) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)HAS_BERRIES, (Comparable)Boolean.valueOf(true)), 2);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HAS_BERRIES});
    }
}

