/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import twilightforest.block.ConnectableRotatedPillarBlock;
import twilightforest.block.TFBlocks;
import twilightforest.util.TFDamageSources;

public class ThornsBlock
extends ConnectableRotatedPillarBlock
implements SimpleWaterloggedBlock {
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final float THORN_DAMAGE = 4.0f;

    ThornsBlock(BlockBehaviour.Properties props) {
        super(props, 10.0);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public boolean canConnectTo(BlockState state, boolean solidSide) {
        return state.m_60734_() instanceof ThornsBlock || state.m_60734_() == TFBlocks.THORN_ROSE.get() || state.m_60734_() == TFBlocks.THORN_LEAVES.get() || state.m_60767_() == Material.f_76300_ || state.m_60767_() == Material.f_76314_;
    }

    @Nullable
    public BlockPathTypes getAiPathNodeType(BlockState state, BlockGetter world, BlockPos pos, @Nullable Mob entity) {
        return BlockPathTypes.DAMAGE_CACTUS;
    }

    @Deprecated
    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entity) {
        entity.m_6469_(TFDamageSources.THORNS, 4.0f);
    }

    public void m_141947_(Level world, BlockPos pos, BlockState state, Entity entity) {
        if (state.m_60734_() instanceof ThornsBlock && state.m_61143_((Property)f_55923_) == Direction.Axis.Y) {
            this.m_7892_(state, world, pos, entity);
        }
        super.m_141947_(world, pos, state, entity);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (!player.m_150110_().f_35937_) {
            if (!world.f_46443_) {
                this.doThornBurst(world, pos, state);
            }
            return false;
        }
        return super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    @Deprecated
    public PushReaction m_5537_(BlockState state) {
        return PushReaction.BLOCK;
    }

    private void doThornBurst(Level world, BlockPos pos, BlockState state) {
        switch ((Direction.Axis)state.m_61143_((Property)f_55923_)) {
            case Y: {
                this.growThorns(world, pos, Direction.UP);
                this.growThorns(world, pos, Direction.DOWN);
                break;
            }
            case X: {
                this.growThorns(world, pos, Direction.EAST);
                this.growThorns(world, pos, Direction.WEST);
                break;
            }
            case Z: {
                this.growThorns(world, pos, Direction.NORTH);
                this.growThorns(world, pos, Direction.SOUTH);
            }
        }
        this.growThorns(world, pos, Direction.m_122404_((Random)world.f_46441_));
        this.growThorns(world, pos, Direction.m_122404_((Random)world.f_46441_));
        this.growThorns(world, pos, Direction.m_122404_((Random)world.f_46441_));
    }

    private void growThorns(Level world, BlockPos pos, Direction dir) {
        BlockPos dPos;
        int length = 1 + world.f_46441_.nextInt(3);
        for (int i = 1; i < length && world.m_46859_(dPos = pos.m_5484_(dir, i)); ++i) {
            world.m_7731_(dPos, (BlockState)((Block)TFBlocks.GREEN_THORNS.get()).m_49966_().m_61124_((Property)f_55923_, (Comparable)dir.m_122434_()), 2);
        }
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        boolean flag = fluidstate.m_76152_() == Fluids.f_76193_;
        return (BlockState)super.m_5573_(context).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    @Override
    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{WATERLOGGED});
    }
}

