/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DoubleHighBlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.IItemRenderProperties;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryObject;
import twilightforest.TwilightForestMod;
import twilightforest.block.AbstractSkullCandleBlock;
import twilightforest.block.HollowLogClimbable;
import twilightforest.block.HollowLogHorizontal;
import twilightforest.block.HollowLogVertical;
import twilightforest.block.HugeLilyPadBlock;
import twilightforest.block.TFBlocks;
import twilightforest.block.entity.TFBlockEntities;
import twilightforest.client.ISTER;
import twilightforest.item.FurnaceFuelItem;
import twilightforest.item.HollowLogItem;
import twilightforest.item.HugeLilyPadItem;
import twilightforest.item.HugeWaterLilyItem;
import twilightforest.item.SkullCandleItem;
import twilightforest.item.TFItems;
import twilightforest.item.TrophyItem;
import twilightforest.item.WearableItem;

public class TFBlockItems {
    public static void registerBlockItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry r = event.getRegistry();
        r.register((IForgeRegistryEntry)TFBlockItems.trophyBlock(TFBlocks.NAGA_TROPHY, TFBlocks.NAGA_WALL_TROPHY));
        r.register((IForgeRegistryEntry)TFBlockItems.trophyBlock(TFBlocks.LICH_TROPHY, TFBlocks.LICH_WALL_TROPHY));
        r.register((IForgeRegistryEntry)TFBlockItems.trophyBlock(TFBlocks.MINOSHROOM_TROPHY, TFBlocks.MINOSHROOM_WALL_TROPHY));
        r.register((IForgeRegistryEntry)TFBlockItems.trophyBlock(TFBlocks.HYDRA_TROPHY, TFBlocks.HYDRA_WALL_TROPHY));
        r.register((IForgeRegistryEntry)TFBlockItems.trophyBlock(TFBlocks.KNIGHT_PHANTOM_TROPHY, TFBlocks.KNIGHT_PHANTOM_WALL_TROPHY));
        r.register((IForgeRegistryEntry)TFBlockItems.trophyBlock(TFBlocks.UR_GHAST_TROPHY, TFBlocks.UR_GHAST_WALL_TROPHY));
        r.register((IForgeRegistryEntry)TFBlockItems.trophyBlock(TFBlocks.ALPHA_YETI_TROPHY, TFBlocks.ALPHA_YETI_WALL_TROPHY));
        r.register((IForgeRegistryEntry)TFBlockItems.trophyBlock(TFBlocks.SNOW_QUEEN_TROPHY, TFBlocks.SNOW_QUEEN_WALL_TROPHY));
        r.register((IForgeRegistryEntry)TFBlockItems.trophyBlock(TFBlocks.QUEST_RAM_TROPHY, TFBlocks.QUEST_RAM_WALL_TROPHY));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.TWILIGHT_PORTAL_MINIATURE_STRUCTURE));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.NAGA_COURTYARD_MINIATURE_STRUCTURE));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.LICH_TOWER_MINIATURE_STRUCTURE));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.NAGA_BOSS_SPAWNER));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.LICH_BOSS_SPAWNER));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.MINOSHROOM_BOSS_SPAWNER));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.HYDRA_BOSS_SPAWNER));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.KNIGHT_PHANTOM_BOSS_SPAWNER));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.UR_GHAST_BOSS_SPAWNER));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.ALPHA_YETI_BOSS_SPAWNER));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.SNOW_QUEEN_BOSS_SPAWNER));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.FINAL_BOSS_BOSS_SPAWNER));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.ETCHED_NAGASTONE));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.CRACKED_ETCHED_NAGASTONE));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.MOSSY_ETCHED_NAGASTONE));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.NAGASTONE_PILLAR));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.CRACKED_NAGASTONE_PILLAR));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.MOSSY_NAGASTONE_PILLAR));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.NAGASTONE_STAIRS_LEFT));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.CRACKED_NAGASTONE_STAIRS_LEFT));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.MOSSY_NAGASTONE_STAIRS_LEFT));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.NAGASTONE_STAIRS_RIGHT));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.CRACKED_NAGASTONE_STAIRS_RIGHT));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.MOSSY_NAGASTONE_STAIRS_RIGHT));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.NAGASTONE_HEAD));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.NAGASTONE));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.SPIRAL_BRICKS));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.TWISTED_STONE));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.TWISTED_STONE_PILLAR));
        r.register((IForgeRegistryEntry)TFBlockItems.makeBlockItem((Item)new BlockItem((Block)TFBlocks.KEEPSAKE_CASKET.get(), TFItems.defaultBuilder().m_41486_()){

            public void initializeClient(Consumer<IItemRenderProperties> consumer) {
                consumer.accept(new IItemRenderProperties(){

                    public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                        return new ISTER(TFBlockEntities.KEEPSAKE_CASKET.getId());
                    }
                });
            }
        }, TFBlocks.KEEPSAKE_CASKET));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.CANDELABRA));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.BOLD_STONE_PILLAR));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.DEATH_TOME_SPAWNER));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.EMPTY_CANOPY_BOOKSHELF));
        r.register((IForgeRegistryEntry)TFBlockItems.skullCandleItem(TFBlocks.ZOMBIE_SKULL_CANDLE, TFBlocks.ZOMBIE_WALL_SKULL_CANDLE));
        r.register((IForgeRegistryEntry)TFBlockItems.skullCandleItem(TFBlocks.SKELETON_SKULL_CANDLE, TFBlocks.SKELETON_WALL_SKULL_CANDLE));
        r.register((IForgeRegistryEntry)TFBlockItems.skullCandleItem(TFBlocks.WITHER_SKELE_SKULL_CANDLE, TFBlocks.WITHER_SKELE_WALL_SKULL_CANDLE));
        r.register((IForgeRegistryEntry)TFBlockItems.skullCandleItem(TFBlocks.CREEPER_SKULL_CANDLE, TFBlocks.CREEPER_WALL_SKULL_CANDLE));
        r.register((IForgeRegistryEntry)TFBlockItems.skullCandleItem(TFBlocks.PLAYER_SKULL_CANDLE, TFBlocks.PLAYER_WALL_SKULL_CANDLE));
        r.register((IForgeRegistryEntry)TFBlockItems.makeBlockItem((Item)new HugeWaterLilyItem((Block)TFBlocks.HUGE_WATER_LILY.get(), TFItems.defaultBuilder()), TFBlocks.HUGE_WATER_LILY));
        r.register((IForgeRegistryEntry)TFBlockItems.makeBlockItem((Item)new HugeLilyPadItem((HugeLilyPadBlock)((Object)TFBlocks.HUGE_LILY_PAD.get()), TFItems.defaultBuilder()), TFBlocks.HUGE_LILY_PAD));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.MAZESTONE));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.MAZESTONE_BRICK));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.CRACKED_MAZESTONE));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.MOSSY_MAZESTONE));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.DECORATIVE_MAZESTONE));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.CUT_MAZESTONE));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.MAZESTONE_BORDER));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.MAZESTONE_MOSAIC));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.SMOKER));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.ENCASED_SMOKER));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.FIRE_JET));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.ENCASED_FIRE_JET));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.STRONGHOLD_SHIELD));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.TROPHY_PEDESTAL));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.UNDERBRICK));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.CRACKED_UNDERBRICK));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.MOSSY_UNDERBRICK));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.UNDERBRICK_FLOOR));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.TOWERWOOD));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.CRACKED_TOWERWOOD));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.MOSSY_TOWERWOOD));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.INFESTED_TOWERWOOD));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.ENCASED_TOWERWOOD));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.VANISHING_BLOCK));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.REAPPEARING_BLOCK));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.LOCKED_VANISHING_BLOCK));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.CARMINITE_BUILDER));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.ANTIBUILDER));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.CARMINITE_REACTOR));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.GHAST_TRAP));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.AURORA_BLOCK));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.AURORA_PILLAR));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.AURORA_SLAB));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.AURORALIZED_GLASS));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.TROLLSTEINN));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.TROLLVIDR));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.UNRIPE_TROLLBER));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.TROLLBER));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.HUGE_MUSHGLOOM));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.HUGE_MUSHGLOOM_STEM));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.UBEROUS_SOIL));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.HUGE_STALK));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.BEANSTALK_LEAVES));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.WISPY_CLOUD));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.FLUFFY_CLOUD));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.GIANT_COBBLESTONE));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.GIANT_LOG));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.GIANT_LEAVES));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.GIANT_OBSIDIAN));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.DEADROCK));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.CRACKED_DEADROCK));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.WEATHERED_DEADROCK));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.BROWN_THORNS));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.GREEN_THORNS));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.BURNT_THORNS));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.THORN_ROSE));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.THORN_LEAVES));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.CASTLE_BRICK));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.WORN_CASTLE_BRICK));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.CRACKED_CASTLE_BRICK));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.MOSSY_CASTLE_BRICK));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.THICK_CASTLE_BRICK));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.CASTLE_ROOF_TILE));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.ENCASED_CASTLE_BRICK_PILLAR));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.ENCASED_CASTLE_BRICK_TILE));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.BOLD_CASTLE_BRICK_PILLAR));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.BOLD_CASTLE_BRICK_TILE));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.CASTLE_BRICK_STAIRS));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.WORN_CASTLE_BRICK_STAIRS));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.CRACKED_CASTLE_BRICK_STAIRS));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.MOSSY_CASTLE_BRICK_STAIRS));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.ENCASED_CASTLE_BRICK_STAIRS));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.BOLD_CASTLE_BRICK_STAIRS));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.PINK_CASTLE_RUNE_BRICK));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.YELLOW_CASTLE_RUNE_BRICK));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.BLUE_CASTLE_RUNE_BRICK));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.VIOLET_CASTLE_RUNE_BRICK));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.PINK_CASTLE_DOOR));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.YELLOW_CASTLE_DOOR));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.BLUE_CASTLE_DOOR));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.VIOLET_CASTLE_DOOR));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.PINK_FORCE_FIELD));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.ORANGE_FORCE_FIELD));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.GREEN_FORCE_FIELD));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.BLUE_FORCE_FIELD));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.VIOLET_FORCE_FIELD));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.UNCRAFTING_TABLE));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.CINDER_FURNACE));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.CINDER_LOG));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.CINDER_WOOD));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.SLIDER));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.IRON_LADDER));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.IRONWOOD_BLOCK));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.STEELEAF_BLOCK));
        r.register((IForgeRegistryEntry)TFBlockItems.fireImmuneBlock(TFBlocks.FIERY_BLOCK));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.KNIGHTMETAL_BLOCK));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.CARMINITE_BLOCK));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.ARCTIC_FUR_BLOCK));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.MOSS_PATCH));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.MAYAPPLE));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.CLOVER_PATCH));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.FIDDLEHEAD));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.MUSHGLOOM));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.TORCHBERRY_PLANT));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.ROOT_STRAND));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.FALLEN_LEAVES));
        r.register((IForgeRegistryEntry)TFBlockItems.wearableBlock(TFBlocks.FIREFLY, TFBlockEntities.FIREFLY));
        r.register((IForgeRegistryEntry)TFBlockItems.wearableBlock(TFBlocks.CICADA, TFBlockEntities.CICADA));
        r.register((IForgeRegistryEntry)TFBlockItems.wearableBlock(TFBlocks.MOONWORM, TFBlockEntities.MOONWORM));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.FIREFLY_JAR));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.FIREFLY_SPAWNER));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.CICADA_JAR));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.HEDGE));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.ROOT_BLOCK));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.LIVEROOT_BLOCK));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.MANGROVE_ROOT));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.TWILIGHT_OAK_LEAVES));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.CANOPY_LEAVES));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.MANGROVE_LEAVES));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.DARK_LEAVES));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.TIME_LEAVES));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.TRANSFORMATION_LEAVES));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.MINING_LEAVES));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.SORTING_LEAVES));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.RAINBOW_OAK_LEAVES));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.TWILIGHT_OAK_LOG));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.CANOPY_LOG));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.MANGROVE_LOG));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.DARK_LOG));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.TIME_LOG));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.TRANSFORMATION_LOG));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.MINING_LOG));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.SORTING_LOG));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.STRIPPED_TWILIGHT_OAK_LOG));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.STRIPPED_CANOPY_LOG));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.STRIPPED_MANGROVE_LOG));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.STRIPPED_DARK_LOG));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.STRIPPED_TIME_LOG));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.STRIPPED_TRANSFORMATION_LOG));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.STRIPPED_MINING_LOG));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.STRIPPED_SORTING_LOG));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.TWILIGHT_OAK_WOOD));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.CANOPY_WOOD));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.MANGROVE_WOOD));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.DARK_WOOD));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.TIME_WOOD));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.TRANSFORMATION_WOOD));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.MINING_WOOD));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.SORTING_WOOD));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.STRIPPED_TWILIGHT_OAK_WOOD));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.STRIPPED_CANOPY_WOOD));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.STRIPPED_MANGROVE_WOOD));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.STRIPPED_DARK_WOOD));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.STRIPPED_TIME_WOOD));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.STRIPPED_TRANSFORMATION_WOOD));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.STRIPPED_MINING_WOOD));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.STRIPPED_SORTING_WOOD));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.TIME_LOG_CORE));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.TRANSFORMATION_LOG_CORE));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.MINING_LOG_CORE));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.SORTING_LOG_CORE));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.TWILIGHT_OAK_SAPLING));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.CANOPY_SAPLING));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.MANGROVE_SAPLING));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.DARKWOOD_SAPLING));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.HOLLOW_OAK_SAPLING));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.TIME_SAPLING));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.TRANSFORMATION_SAPLING));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.MINING_SAPLING));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.SORTING_SAPLING));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.RAINBOW_OAK_SAPLING));
        r.register((IForgeRegistryEntry)TFBlockItems.burningItem(TFBlocks.OAK_BANISTER, 300));
        r.register((IForgeRegistryEntry)TFBlockItems.burningItem(TFBlocks.SPRUCE_BANISTER, 300));
        r.register((IForgeRegistryEntry)TFBlockItems.burningItem(TFBlocks.BIRCH_BANISTER, 300));
        r.register((IForgeRegistryEntry)TFBlockItems.burningItem(TFBlocks.JUNGLE_BANISTER, 300));
        r.register((IForgeRegistryEntry)TFBlockItems.burningItem(TFBlocks.ACACIA_BANISTER, 300));
        r.register((IForgeRegistryEntry)TFBlockItems.burningItem(TFBlocks.DARK_OAK_BANISTER, 300));
        r.register((IForgeRegistryEntry)TFBlockItems.burningItem(TFBlocks.CRIMSON_BANISTER, 300));
        r.register((IForgeRegistryEntry)TFBlockItems.burningItem(TFBlocks.WARPED_BANISTER, 300));
        r.register((IForgeRegistryEntry)TFBlockItems.hollowLog(TFBlocks.HOLLOW_OAK_LOG_HORIZONTAL, TFBlocks.HOLLOW_OAK_LOG_VERTICAL, TFBlocks.HOLLOW_OAK_LOG_CLIMBABLE, "hollow_oak_log"));
        r.register((IForgeRegistryEntry)TFBlockItems.hollowLog(TFBlocks.HOLLOW_SPRUCE_LOG_HORIZONTAL, TFBlocks.HOLLOW_SPRUCE_LOG_VERTICAL, TFBlocks.HOLLOW_SPRUCE_LOG_CLIMBABLE, "hollow_spruce_log"));
        r.register((IForgeRegistryEntry)TFBlockItems.hollowLog(TFBlocks.HOLLOW_BIRCH_LOG_HORIZONTAL, TFBlocks.HOLLOW_BIRCH_LOG_VERTICAL, TFBlocks.HOLLOW_BIRCH_LOG_CLIMBABLE, "hollow_birch_log"));
        r.register((IForgeRegistryEntry)TFBlockItems.hollowLog(TFBlocks.HOLLOW_JUNGLE_LOG_HORIZONTAL, TFBlocks.HOLLOW_JUNGLE_LOG_VERTICAL, TFBlocks.HOLLOW_JUNGLE_LOG_CLIMBABLE, "hollow_jungle_log"));
        r.register((IForgeRegistryEntry)TFBlockItems.hollowLog(TFBlocks.HOLLOW_ACACIA_LOG_HORIZONTAL, TFBlocks.HOLLOW_ACACIA_LOG_VERTICAL, TFBlocks.HOLLOW_ACACIA_LOG_CLIMBABLE, "hollow_acacia_log"));
        r.register((IForgeRegistryEntry)TFBlockItems.hollowLog(TFBlocks.HOLLOW_DARK_OAK_LOG_HORIZONTAL, TFBlocks.HOLLOW_DARK_OAK_LOG_VERTICAL, TFBlocks.HOLLOW_DARK_OAK_LOG_CLIMBABLE, "hollow_dark_oak_log"));
        r.register((IForgeRegistryEntry)TFBlockItems.hollowLog(TFBlocks.HOLLOW_CRIMSON_STEM_HORIZONTAL, TFBlocks.HOLLOW_CRIMSON_STEM_VERTICAL, TFBlocks.HOLLOW_CRIMSON_STEM_CLIMBABLE, "hollow_crimson_stem"));
        r.register((IForgeRegistryEntry)TFBlockItems.hollowLog(TFBlocks.HOLLOW_WARPED_STEM_HORIZONTAL, TFBlocks.HOLLOW_WARPED_STEM_VERTICAL, TFBlocks.HOLLOW_WARPED_STEM_CLIMBABLE, "hollow_warped_stem"));
        r.register((IForgeRegistryEntry)TFBlockItems.hollowLog(TFBlocks.HOLLOW_TWILIGHT_OAK_LOG_HORIZONTAL, TFBlocks.HOLLOW_TWILIGHT_OAK_LOG_VERTICAL, TFBlocks.HOLLOW_TWILIGHT_OAK_LOG_CLIMBABLE, "hollow_twilight_oak_log"));
        r.register((IForgeRegistryEntry)TFBlockItems.hollowLog(TFBlocks.HOLLOW_CANOPY_LOG_HORIZONTAL, TFBlocks.HOLLOW_CANOPY_LOG_VERTICAL, TFBlocks.HOLLOW_CANOPY_LOG_CLIMBABLE, "hollow_canopy_log"));
        r.register((IForgeRegistryEntry)TFBlockItems.hollowLog(TFBlocks.HOLLOW_MANGROVE_LOG_HORIZONTAL, TFBlocks.HOLLOW_MANGROVE_LOG_VERTICAL, TFBlocks.HOLLOW_MANGROVE_LOG_CLIMBABLE, "hollow_mangrove_log"));
        r.register((IForgeRegistryEntry)TFBlockItems.hollowLog(TFBlocks.HOLLOW_DARK_LOG_HORIZONTAL, TFBlocks.HOLLOW_DARK_LOG_VERTICAL, TFBlocks.HOLLOW_DARK_LOG_CLIMBABLE, "hollow_dark_log"));
        r.register((IForgeRegistryEntry)TFBlockItems.hollowLog(TFBlocks.HOLLOW_TIME_LOG_HORIZONTAL, TFBlocks.HOLLOW_TIME_LOG_VERTICAL, TFBlocks.HOLLOW_TIME_LOG_CLIMBABLE, "hollow_time_log"));
        r.register((IForgeRegistryEntry)TFBlockItems.hollowLog(TFBlocks.HOLLOW_TRANSFORMATION_LOG_HORIZONTAL, TFBlocks.HOLLOW_TRANSFORMATION_LOG_VERTICAL, TFBlocks.HOLLOW_TRANSFORMATION_LOG_CLIMBABLE, "hollow_transformation_log"));
        r.register((IForgeRegistryEntry)TFBlockItems.hollowLog(TFBlocks.HOLLOW_MINING_LOG_HORIZONTAL, TFBlocks.HOLLOW_MINING_LOG_VERTICAL, TFBlocks.HOLLOW_MINING_LOG_CLIMBABLE, "hollow_mining_log"));
        r.register((IForgeRegistryEntry)TFBlockItems.hollowLog(TFBlocks.HOLLOW_SORTING_LOG_HORIZONTAL, TFBlocks.HOLLOW_SORTING_LOG_VERTICAL, TFBlocks.HOLLOW_SORTING_LOG_CLIMBABLE, "hollow_sorting_log"));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.TWILIGHT_OAK_PLANKS));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.TWILIGHT_OAK_STAIRS));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.TWILIGHT_OAK_SLAB));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.TWILIGHT_OAK_BUTTON));
        r.register((IForgeRegistryEntry)TFBlockItems.burningItem(TFBlocks.TWILIGHT_OAK_FENCE, 300));
        r.register((IForgeRegistryEntry)TFBlockItems.burningItem(TFBlocks.TWILIGHT_OAK_GATE, 300));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.TWILIGHT_OAK_PLATE));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.TWILIGHT_OAK_TRAPDOOR));
        r.register((IForgeRegistryEntry)TFBlockItems.tallBlock(TFBlocks.TWILIGHT_OAK_DOOR));
        r.register((IForgeRegistryEntry)TFBlockItems.signBlock(TFBlocks.TWILIGHT_OAK_SIGN, TFBlocks.TWILIGHT_WALL_SIGN));
        r.register((IForgeRegistryEntry)TFBlockItems.burningItem(TFBlocks.TWILIGHT_OAK_BANISTER, 300));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.CANOPY_PLANKS));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.CANOPY_STAIRS));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.CANOPY_SLAB));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.CANOPY_BUTTON));
        r.register((IForgeRegistryEntry)TFBlockItems.burningItem(TFBlocks.CANOPY_FENCE, 300));
        r.register((IForgeRegistryEntry)TFBlockItems.burningItem(TFBlocks.CANOPY_GATE, 300));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.CANOPY_PLATE));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.CANOPY_TRAPDOOR));
        r.register((IForgeRegistryEntry)TFBlockItems.tallBlock(TFBlocks.CANOPY_DOOR));
        r.register((IForgeRegistryEntry)TFBlockItems.signBlock(TFBlocks.CANOPY_SIGN, TFBlocks.CANOPY_WALL_SIGN));
        r.register((IForgeRegistryEntry)TFBlockItems.burningItem(TFBlocks.CANOPY_BANISTER, 300));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.CANOPY_BOOKSHELF));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.MANGROVE_PLANKS));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.MANGROVE_STAIRS));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.MANGROVE_SLAB));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.MANGROVE_BUTTON));
        r.register((IForgeRegistryEntry)TFBlockItems.burningItem(TFBlocks.MANGROVE_FENCE, 300));
        r.register((IForgeRegistryEntry)TFBlockItems.burningItem(TFBlocks.MANGROVE_GATE, 300));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.MANGROVE_PLATE));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.MANGROVE_TRAPDOOR));
        r.register((IForgeRegistryEntry)TFBlockItems.tallBlock(TFBlocks.MANGROVE_DOOR));
        r.register((IForgeRegistryEntry)TFBlockItems.signBlock(TFBlocks.MANGROVE_SIGN, TFBlocks.MANGROVE_WALL_SIGN));
        r.register((IForgeRegistryEntry)TFBlockItems.burningItem(TFBlocks.MANGROVE_BANISTER, 300));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.DARK_PLANKS));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.DARK_STAIRS));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.DARK_SLAB));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.DARK_BUTTON));
        r.register((IForgeRegistryEntry)TFBlockItems.burningItem(TFBlocks.DARK_FENCE, 300));
        r.register((IForgeRegistryEntry)TFBlockItems.burningItem(TFBlocks.DARK_GATE, 300));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.DARK_PLATE));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.DARK_TRAPDOOR));
        r.register((IForgeRegistryEntry)TFBlockItems.tallBlock(TFBlocks.DARK_DOOR));
        r.register((IForgeRegistryEntry)TFBlockItems.signBlock(TFBlocks.DARKWOOD_SIGN, TFBlocks.DARKWOOD_WALL_SIGN));
        r.register((IForgeRegistryEntry)TFBlockItems.burningItem(TFBlocks.DARKWOOD_BANISTER, 300));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.TIME_PLANKS));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.TIME_STAIRS));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.TIME_SLAB));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.TIME_BUTTON));
        r.register((IForgeRegistryEntry)TFBlockItems.burningItem(TFBlocks.TIME_FENCE, 300));
        r.register((IForgeRegistryEntry)TFBlockItems.burningItem(TFBlocks.TIME_GATE, 300));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.TIME_PLATE));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.TIME_TRAPDOOR));
        r.register((IForgeRegistryEntry)TFBlockItems.tallBlock(TFBlocks.TIME_DOOR));
        r.register((IForgeRegistryEntry)TFBlockItems.signBlock(TFBlocks.TIME_SIGN, TFBlocks.TIME_WALL_SIGN));
        r.register((IForgeRegistryEntry)TFBlockItems.burningItem(TFBlocks.TIME_BANISTER, 300));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.TRANSFORMATION_PLANKS));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.TRANSFORMATION_STAIRS));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.TRANSFORMATION_SLAB));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.TRANSFORMATION_BUTTON));
        r.register((IForgeRegistryEntry)TFBlockItems.burningItem(TFBlocks.TRANSFORMATION_FENCE, 300));
        r.register((IForgeRegistryEntry)TFBlockItems.burningItem(TFBlocks.TRANSFORMATION_GATE, 300));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.TRANSFORMATION_PLATE));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.TRANSFORMATION_TRAPDOOR));
        r.register((IForgeRegistryEntry)TFBlockItems.tallBlock(TFBlocks.TRANSFORMATION_DOOR));
        r.register((IForgeRegistryEntry)TFBlockItems.signBlock(TFBlocks.TRANSFORMATION_SIGN, TFBlocks.TRANSFORMATION_WALL_SIGN));
        r.register((IForgeRegistryEntry)TFBlockItems.burningItem(TFBlocks.TRANSFORMATION_BANISTER, 300));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.MINING_PLANKS));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.MINING_STAIRS));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.MINING_SLAB));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.MINING_BUTTON));
        r.register((IForgeRegistryEntry)TFBlockItems.burningItem(TFBlocks.MINING_FENCE, 300));
        r.register((IForgeRegistryEntry)TFBlockItems.burningItem(TFBlocks.MINING_GATE, 300));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.MINING_PLATE));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.MINING_TRAPDOOR));
        r.register((IForgeRegistryEntry)TFBlockItems.tallBlock(TFBlocks.MINING_DOOR));
        r.register((IForgeRegistryEntry)TFBlockItems.signBlock(TFBlocks.MINING_SIGN, TFBlocks.MINING_WALL_SIGN));
        r.register((IForgeRegistryEntry)TFBlockItems.burningItem(TFBlocks.MINING_BANISTER, 300));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.SORTING_PLANKS));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.SORTING_STAIRS));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.SORTING_SLAB));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.SORTING_BUTTON));
        r.register((IForgeRegistryEntry)TFBlockItems.burningItem(TFBlocks.SORTING_FENCE, 300));
        r.register((IForgeRegistryEntry)TFBlockItems.burningItem(TFBlocks.SORTING_GATE, 300));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.SORTING_PLATE));
        r.register((IForgeRegistryEntry)TFBlockItems.blockItem(TFBlocks.SORTING_TRAPDOOR));
        r.register((IForgeRegistryEntry)TFBlockItems.tallBlock(TFBlocks.SORTING_DOOR));
        r.register((IForgeRegistryEntry)TFBlockItems.signBlock(TFBlocks.SORTING_SIGN, TFBlocks.SORTING_WALL_SIGN));
        r.register((IForgeRegistryEntry)TFBlockItems.burningItem(TFBlocks.SORTING_BANISTER, 300));
        TFBlockItems.makeBEWLRItem((IForgeRegistry<Item>)r, TFBlocks.TWILIGHT_OAK_CHEST, TFBlockEntities.TF_CHEST.getId());
        TFBlockItems.makeBEWLRItem((IForgeRegistry<Item>)r, TFBlocks.CANOPY_CHEST, TFBlockEntities.TF_CHEST.getId());
        TFBlockItems.makeBEWLRItem((IForgeRegistry<Item>)r, TFBlocks.MANGROVE_CHEST, TFBlockEntities.TF_CHEST.getId());
        TFBlockItems.makeBEWLRItem((IForgeRegistry<Item>)r, TFBlocks.DARKWOOD_CHEST, TFBlockEntities.TF_CHEST.getId());
        TFBlockItems.makeBEWLRItem((IForgeRegistry<Item>)r, TFBlocks.TIME_CHEST, TFBlockEntities.TF_CHEST.getId());
        TFBlockItems.makeBEWLRItem((IForgeRegistry<Item>)r, TFBlocks.TRANSFORMATION_CHEST, TFBlockEntities.TF_CHEST.getId());
        TFBlockItems.makeBEWLRItem((IForgeRegistry<Item>)r, TFBlocks.MINING_CHEST, TFBlockEntities.TF_CHEST.getId());
        TFBlockItems.makeBEWLRItem((IForgeRegistry<Item>)r, TFBlocks.SORTING_CHEST, TFBlockEntities.TF_CHEST.getId());
    }

    private static <B extends Block> Item hollowLog(RegistryObject<HollowLogHorizontal> horizontalLog, RegistryObject<HollowLogVertical> verticalLog, RegistryObject<HollowLogClimbable> climbable, String name) {
        return (Item)new HollowLogItem(horizontalLog, verticalLog, climbable, TFItems.defaultBuilder()).setRegistryName("twilightforest", name);
    }

    private static <B extends Block> Item blockItem(RegistryObject<B> block) {
        return TFBlockItems.makeBlockItem((Item)new BlockItem((Block)block.get(), TFItems.defaultBuilder()), block);
    }

    private static <B extends Block> Item fireImmuneBlock(RegistryObject<B> block) {
        return TFBlockItems.makeBlockItem((Item)new BlockItem((Block)block.get(), TFItems.defaultBuilder().m_41486_()), block);
    }

    private static <B extends AbstractSkullCandleBlock> Item skullCandleItem(RegistryObject<B> floor, RegistryObject<B> wall) {
        return TFBlockItems.makeBlockItem((Item)new SkullCandleItem((AbstractSkullCandleBlock)((Object)floor.get()), (AbstractSkullCandleBlock)((Object)wall.get()), TFItems.defaultBuilder().m_41497_(Rarity.UNCOMMON)){

            public void initializeClient(Consumer<IItemRenderProperties> consumer) {
                consumer.accept(new IItemRenderProperties(){

                    public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                        return new ISTER(TFBlockEntities.SKULL_CANDLE.getId());
                    }
                });
            }
        }, floor);
    }

    private static <B extends Block> Item burningItem(RegistryObject<B> block, int burntime) {
        return TFBlockItems.makeBlockItem((Item)new FurnaceFuelItem((Block)block.get(), TFItems.defaultBuilder(), burntime), block);
    }

    private static <B extends Block, W extends Block> Item trophyBlock(RegistryObject<B> block, RegistryObject<W> wallblock) {
        return TFBlockItems.makeBlockItem((Item)new TrophyItem((Block)block.get(), (Block)wallblock.get(), TFItems.defaultBuilder().m_41497_(TwilightForestMod.getRarity())){

            public void initializeClient(Consumer<IItemRenderProperties> consumer) {
                consumer.accept(new IItemRenderProperties(){

                    public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                        return new ISTER(TFBlockEntities.TROPHY.getId());
                    }
                });
            }
        }, block);
    }

    private static <T extends Block, E extends BlockEntity> Item wearableBlock(RegistryObject<T> block, final RegistryObject<BlockEntityType<E>> tileentity) {
        return TFBlockItems.makeBlockItem((Item)new WearableItem((Block)block.get(), TFItems.defaultBuilder()){

            public void initializeClient(Consumer<IItemRenderProperties> consumer) {
                consumer.accept(new IItemRenderProperties(){

                    public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                        return new ISTER(tileentity.getId());
                    }
                });
            }
        }, block);
    }

    private static <B extends Block> Item tallBlock(RegistryObject<B> block) {
        return TFBlockItems.makeBlockItem((Item)new DoubleHighBlockItem((Block)block.get(), TFItems.defaultBuilder()), block);
    }

    private static <B extends Block, W extends Block> Item signBlock(RegistryObject<B> block, RegistryObject<W> wallblock) {
        return TFBlockItems.makeBlockItem((Item)new SignItem(TFItems.defaultBuilder().m_41487_(16), (Block)block.get(), (Block)wallblock.get()), block);
    }

    private static Item makeBlockItem(Item blockitem, RegistryObject<? extends Block> block) {
        return (Item)blockitem.setRegistryName(Objects.requireNonNull(block.getId()));
    }

    private static void makeBEWLRItem(IForgeRegistry<Item> r, RegistryObject<? extends Block> block, final ResourceLocation rl) {
        r.register((IForgeRegistryEntry)TFBlockItems.makeBlockItem((Item)new BlockItem((Block)block.get(), TFItems.defaultBuilder()){

            public void initializeClient(Consumer<IItemRenderProperties> consumer) {
                consumer.accept(new IItemRenderProperties(){

                    public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                        return new ISTER(rl);
                    }
                });
            }
        }, block));
    }
}

