/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.world.surfacerules;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.the_bumblezone.utils.OpenSimplex2F;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.SurfaceRules;

public record PollinatedSurfaceSource(BlockState resultState, RandomLayerStateRule rule) implements SurfaceRules.RuleSource
{
    public static final Codec<PollinatedSurfaceSource> CODEC = BlockState.f_61039_.xmap(PollinatedSurfaceSource::new, PollinatedSurfaceSource::resultState).fieldOf("result_state").codec();

    PollinatedSurfaceSource(BlockState blockState) {
        this(blockState, new RandomLayerStateRule(blockState));
    }

    public Codec<? extends SurfaceRules.RuleSource> m_183290_() {
        return CODEC;
    }

    public SurfaceRules.SurfaceRule apply(SurfaceRules.Context context) {
        return this.rule;
    }

    public static class RandomLayerStateRule
    implements SurfaceRules.SurfaceRule {
        protected BlockState blockState;
        protected static long seed;
        private static OpenSimplex2F noiseGenerator;
        private final boolean haslayer;
        private final float xzScale = 0.035f;
        private final float yScale = 0.015f;

        public RandomLayerStateRule(BlockState blockState) {
            this.blockState = blockState;
            this.haslayer = this.blockState.m_61138_((Property)BlockStateProperties.f_61417_);
        }

        public static void initNoise(long seedIn) {
            if (seed != seedIn || noiseGenerator == null) {
                noiseGenerator = new OpenSimplex2F(seedIn);
                seed = seedIn;
            }
        }

        public BlockState m_183550_(int x, int y, int z) {
            if (this.haslayer) {
                double noiseVal = noiseGenerator.noise3_Classic((float)x * 0.035f, (float)y * 0.015f, (float)z * 0.035f);
                int layerHeight = Math.max(0, (int)((noiseVal / 2.0 + 0.5) * 8.0));
                layerHeight = Math.min(8, layerHeight + (Integer)this.blockState.m_61143_((Property)BlockStateProperties.f_61417_));
                return (BlockState)this.blockState.m_61124_((Property)BlockStateProperties.f_61417_, (Comparable)Integer.valueOf(layerHeight));
            }
            return this.blockState;
        }

        static {
            noiseGenerator = null;
        }
    }
}

