/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.world.structures;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.the_bumblezone.world.structures.pieces.BuriedStructurePiece;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.PostPlacementProcessor;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;

public class PollinatedStreamStructure
extends StructureFeature<JigsawConfiguration> {
    public PollinatedStreamStructure(Codec<JigsawConfiguration> codec) {
        super(codec, PollinatedStreamStructure::generatePieces, PostPlacementProcessor.f_192427_);
    }

    private static boolean validSpot(ChunkGenerator chunkGenerator, BlockPos centerPos, LevelHeightAccessor heightLimitView) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        mutable.m_122190_((Vec3i)centerPos);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            mutable.m_122190_((Vec3i)centerPos).m_122175_(direction, 12);
            NoiseColumn columnOfBlocks = chunkGenerator.m_141914_(mutable.m_123341_(), mutable.m_123343_(), heightLimitView);
            BlockState state = columnOfBlocks.m_183556_(41);
            if (!state.m_60767_().m_76334_()) {
                return false;
            }
            mutable.m_122190_((Vec3i)centerPos).m_122175_(direction, 55);
            columnOfBlocks = chunkGenerator.m_141914_(mutable.m_123341_(), mutable.m_123343_(), heightLimitView);
            state = columnOfBlocks.m_183556_(41);
            if (state.m_60767_().m_76334_()) continue;
            return false;
        }
        return true;
    }

    public static Optional<PieceGenerator<JigsawConfiguration>> generatePieces(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        WorldgenRandom positionedRandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(context.f_197354_() + (long)context.f_197355_().f_45578_ * ((long)context.f_197355_().f_45579_ * 17L)));
        int x = context.f_197355_().m_45604_();
        int z = context.f_197355_().m_45605_();
        BlockPos centerPos = new BlockPos(x, positionedRandom.nextInt(45) + 10, z);
        if (!PollinatedStreamStructure.validSpot(context.f_197352_(), centerPos, context.f_197357_())) {
            return Optional.empty();
        }
        JigsawConfiguration newConfig = new JigsawConfiguration(((JigsawConfiguration)context.f_197356_()).m_204802_(), 12);
        PieceGeneratorSupplier.Context newContext = new PieceGeneratorSupplier.Context(context.f_197352_(), context.f_197353_(), context.f_197354_(), context.f_197355_(), (FeatureConfiguration)newConfig, context.f_197357_(), context.f_197358_(), context.f_197359_(), context.f_197360_());
        return JigsawPlacement.m_210284_((PieceGeneratorSupplier.Context)newContext, BuriedStructurePiece::new, (BlockPos)centerPos, (boolean)false, (boolean)false);
    }

    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }
}

