/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.world.structures;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.the_bumblezone.world.structures.pieces.BuriedStructurePiece;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.PostPlacementProcessor;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;

public class HoneyCaveRoomStructure
extends StructureFeature<JigsawConfiguration> {
    public HoneyCaveRoomStructure(Codec<JigsawConfiguration> codec) {
        super(codec, HoneyCaveRoomStructure::generatePieces, PostPlacementProcessor.f_192427_);
    }

    private static boolean validSpot(ChunkGenerator chunkGenerator, BlockPos centerPos, LevelHeightAccessor heightLimitView) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        int radius = 24;
        for (int x = -radius; x <= radius; x += radius) {
            for (int z = -radius; z <= radius; z += radius) {
                mutable.m_122190_((Vec3i)centerPos).m_122184_(x, 0, z);
                NoiseColumn columnOfBlocks = chunkGenerator.m_141914_(mutable.m_123341_(), mutable.m_123343_(), heightLimitView);
                BlockState state = columnOfBlocks.m_183556_(mutable.m_123342_());
                BlockState aboveState = columnOfBlocks.m_183556_(mutable.m_123342_() + 15);
                if (!state.m_60795_() && state.m_60819_().m_76178_() && !aboveState.m_60795_() && aboveState.m_60819_().m_76178_()) continue;
                return false;
            }
        }
        return true;
    }

    public static Optional<PieceGenerator<JigsawConfiguration>> generatePieces(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        WorldgenRandom positionedRandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(context.f_197354_() + (long)context.f_197355_().f_45578_ * ((long)context.f_197355_().f_45579_ * 17L)));
        int height = context.f_197352_().m_6337_() + positionedRandom.nextInt(Math.max(context.f_197352_().m_6331_() - (context.f_197352_().m_6337_() + 50), 1));
        BlockPos centerPos = new BlockPos(context.f_197355_().m_45604_(), height, context.f_197355_().m_45605_());
        if (!HoneyCaveRoomStructure.validSpot(context.f_197352_(), centerPos, context.f_197357_())) {
            return Optional.empty();
        }
        JigsawConfiguration newConfig = new JigsawConfiguration(((JigsawConfiguration)context.f_197356_()).m_204802_(), 12);
        PieceGeneratorSupplier.Context newContext = new PieceGeneratorSupplier.Context(context.f_197352_(), context.f_197353_(), context.f_197354_(), context.f_197355_(), (FeatureConfiguration)newConfig, context.f_197357_(), context.f_197358_(), context.f_197359_(), context.f_197360_());
        return JigsawPlacement.m_210284_((PieceGeneratorSupplier.Context)newContext, BuriedStructurePiece::new, (BlockPos)centerPos, (boolean)false, (boolean)false);
    }

    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.LOCAL_MODIFICATIONS;
    }
}

