/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.world.processors;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.the_bumblezone.blocks.HoneycombBrood;
import com.telepathicgrunt.the_bumblezone.configs.BzModCompatibilityConfigs;
import com.telepathicgrunt.the_bumblezone.configs.BzWorldgenConfigs;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ProductiveBeesCompat;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzProcessors;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class SpiderInfestedBeeDungeonProcessor
extends StructureProcessor {
    public static final Codec<SpiderInfestedBeeDungeonProcessor> CODEC = Codec.unit(SpiderInfestedBeeDungeonProcessor::new);

    private SpiderInfestedBeeDungeonProcessor() {
    }

    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader worldView, BlockPos pos, BlockPos blockPos, StructureTemplate.StructureBlockInfo structureBlockInfoLocal, StructureTemplate.StructureBlockInfo structureBlockInfoWorld, StructurePlaceSettings structurePlacementData) {
        BlockState blockState = structureBlockInfoWorld.f_74676_;
        BlockPos worldPos = structureBlockInfoWorld.f_74675_;
        WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        random.setSeed(worldPos.m_121878_() * (long)worldPos.m_123342_());
        CompoundTag nbt = structureBlockInfoWorld.f_74677_;
        if (blockState.m_60713_(Blocks.f_50677_)) {
            String metadata = structureBlockInfoWorld.f_74677_.m_128461_("metadata");
            BlockState belowBlock = worldView.m_46865_(worldPos).m_8055_(worldPos);
            if (belowBlock.m_60795_()) {
                blockState = Blocks.f_50627_.m_49966_();
            } else {
                switch (metadata) {
                    case "center": {
                        if (random.nextFloat() < 0.1f) {
                            blockState = ((Block)BzBlocks.HONEY_COCOON.get()).m_49966_();
                            nbt = new CompoundTag();
                            nbt.m_128359_("LootTable", "the_bumblezone:structures/spider_infested_bee_dungeon");
                            break;
                        }
                        if (random.nextFloat() < 0.6f) {
                            blockState = ((Block)BzBlocks.HONEY_CRYSTAL.get()).m_49966_();
                            break;
                        }
                        if (random.nextFloat() < 0.25f) {
                            blockState = GeneralUtils.VANILLA_CANDLES.get(random.nextInt(GeneralUtils.VANILLA_CANDLES.size()));
                            blockState = (BlockState)blockState.m_61124_((Property)CandleBlock.f_152790_, (Comparable)Integer.valueOf(random.nextInt(4) + 1));
                            blockState = (BlockState)blockState.m_61124_((Property)CandleBlock.f_152791_, (Comparable)Boolean.valueOf(false));
                            break;
                        }
                        if (random.nextFloat() < 0.05f) {
                            blockState = Blocks.f_50033_.m_49966_();
                            break;
                        }
                        blockState = Blocks.f_50627_.m_49966_();
                        break;
                    }
                    case "inner_ring": {
                        if (random.nextFloat() < 0.3f) {
                            blockState = ((Block)BzBlocks.HONEY_CRYSTAL.get()).m_49966_();
                            break;
                        }
                        if (random.nextFloat() < 0.07f) {
                            blockState = Blocks.f_50033_.m_49966_();
                            break;
                        }
                        blockState = Blocks.f_50627_.m_49966_();
                        break;
                    }
                    case "outer_ring": {
                        if (random.nextFloat() < 0.4f) {
                            blockState = ((Block)BzBlocks.HONEY_CRYSTAL.get()).m_49966_();
                            break;
                        }
                        if (random.nextFloat() < 0.2f) {
                            blockState = GeneralUtils.VANILLA_CANDLES.get(random.nextInt(GeneralUtils.VANILLA_CANDLES.size()));
                            blockState = (BlockState)blockState.m_61124_((Property)CandleBlock.f_152790_, (Comparable)Integer.valueOf(random.nextInt(random.nextInt(4) + 1) + 1));
                            blockState = (BlockState)blockState.m_61124_((Property)CandleBlock.f_152791_, (Comparable)Boolean.valueOf(false));
                            break;
                        }
                        if (random.nextFloat() < 0.07f) {
                            blockState = Blocks.f_50033_.m_49966_();
                            break;
                        }
                        blockState = Blocks.f_50627_.m_49966_();
                        break;
                    }
                }
            }
        } else if (blockState.m_60713_(Blocks.f_50720_) || blockState.m_60713_((Block)BzBlocks.FILLED_POROUS_HONEYCOMB.get())) {
            if (ModChecker.productiveBeesPresent && (double)random.nextFloat() < (Double)BzModCompatibilityConfigs.oreHoneycombSpawnRateSpiderBeeDungeon.get()) {
                StructureTemplate.StructureBlockInfo info = ProductiveBeesCompat.PBGetRottenedHoneycomb(worldPos, (Random)random);
                if (info != null) {
                    return info;
                }
            } else {
                blockState = random.nextFloat() < 0.15f ? Blocks.f_50720_.m_49966_() : ((Block)BzBlocks.POROUS_HONEYCOMB.get()).m_49966_();
            }
        } else if (blockState.m_60713_((Block)BzBlocks.HONEYCOMB_BROOD.get())) {
            blockState = random.nextFloat() < 0.6f ? (BlockState)((Block)BzBlocks.EMPTY_HONEYCOMB_BROOD.get()).m_49966_().m_61124_((Property)HoneycombBrood.f_52588_, (Comparable)((Direction)blockState.m_61143_((Property)HoneycombBrood.f_52588_))) : (random.nextDouble() < (Double)BzWorldgenConfigs.spawnerRateSpiderBeeDungeon.get() ? Blocks.f_50085_.m_49966_() : ((Block)BzBlocks.POROUS_HONEYCOMB.get()).m_49966_());
        } else if (blockState.m_60713_((Block)BzFluids.SUGAR_WATER_BLOCK.get())) {
            blockState = Blocks.f_50627_.m_49966_();
        }
        return new StructureTemplate.StructureBlockInfo(worldPos, blockState, nbt);
    }

    protected StructureProcessorType<?> m_6953_() {
        return BzProcessors.SPIDER_INFESTED_BEE_DUNGEON_PROCESSOR;
    }
}

