/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.world.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.blocks.PileOfPollen;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzProcessors;
import com.telepathicgrunt.the_bumblezone.utils.OpenSimplex2F;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class PollenPilingProcessor
extends StructureProcessor {
    public static final Codec<PollenPilingProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("xz_scale").forGetter(config -> Float.valueOf(config.xzScale)), (App)Codec.FLOAT.fieldOf("y_scale").forGetter(config -> Float.valueOf(config.yScale)), (App)Codec.BOOL.fieldOf("pollen_replace_solids").forGetter(config -> config.pollenReplaceSolids)).apply((Applicative)instance, instance.stable(PollenPilingProcessor::new)));
    private final float xzScale;
    private final float yScale;
    private final boolean pollenReplaceSolids;
    protected long seed;
    private OpenSimplex2F noiseGenerator = null;

    public PollenPilingProcessor(float xzScale, float yScale, boolean pollenReplaceSolids) {
        this.xzScale = xzScale;
        this.yScale = yScale;
        this.pollenReplaceSolids = pollenReplaceSolids;
    }

    public void setSeed(long seed) {
        if (this.seed != seed || this.noiseGenerator == null) {
            this.noiseGenerator = new OpenSimplex2F(seed);
            this.seed = seed;
        }
    }

    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader worldView, BlockPos pos, BlockPos blockPos, StructureTemplate.StructureBlockInfo structureBlockInfoLocal, StructureTemplate.StructureBlockInfo structureBlockInfoWorld, StructurePlaceSettings structurePlacementData) {
        BlockPos abovePos;
        BlockState aboveState;
        ChunkAccess chunk;
        this.setSeed(worldView instanceof WorldGenRegion ? ((WorldGenRegion)worldView).m_7328_() : 0L);
        StructureTemplate.StructureBlockInfo structureBlockInfoToReturn = structureBlockInfoWorld;
        BlockState structureState = structureBlockInfoToReturn.f_74676_;
        BlockPos worldPos = structureBlockInfoToReturn.f_74675_;
        if (structureState.m_60713_((Block)BzBlocks.PILE_OF_POLLEN.get())) {
            if (!this.pollenReplaceSolids && !worldView.m_8055_(worldPos).m_60795_()) {
                return null;
            }
            BlockPos belowPos = worldPos.m_7495_();
            if (belowPos.m_123342_() <= worldView.m_141937_() || belowPos.m_123342_() >= worldView.m_151558_()) {
                return null;
            }
            chunk = worldView.m_46865_(belowPos);
            BlockState belowState = chunk.m_8055_(belowPos);
            if (!belowState.m_60815_()) {
                ((LevelAccessor)worldView).m_186460_(belowPos, structureState.m_60734_(), 0);
            }
            BlockPos.MutableBlockPos sidePos = new BlockPos.MutableBlockPos();
            for (Direction direction : Direction.values()) {
                sidePos.m_122190_((Vec3i)worldPos).m_122173_(direction);
                if (!worldView.m_8055_((BlockPos)sidePos).m_60819_().m_76170_()) continue;
                return new StructureTemplate.StructureBlockInfo(worldPos, ((Block)BzBlocks.FILLED_POROUS_HONEYCOMB.get()).m_49966_(), null);
            }
            double noiseVal = this.noiseGenerator.noise3_Classic((float)worldPos.m_123341_() * this.xzScale, (float)worldPos.m_123342_() * this.yScale, (float)worldPos.m_123343_() * this.xzScale);
            int layerHeight = Math.max(0, (int)((noiseVal / 2.0 + 0.5) * 2.5));
            layerHeight = Math.min(8, layerHeight + (Integer)structureState.m_61143_((Property)PileOfPollen.LAYERS));
            structureBlockInfoToReturn = new StructureTemplate.StructureBlockInfo(worldPos, (BlockState)structureState.m_61124_((Property)PileOfPollen.LAYERS, (Comparable)Integer.valueOf(layerHeight)), structureBlockInfoToReturn.f_74677_);
        }
        if (!structureState.m_60815_() && (aboveState = (chunk = worldView.m_46865_(abovePos = worldPos.m_7494_())).m_8055_(abovePos)).m_60713_((Block)BzBlocks.PILE_OF_POLLEN.get())) {
            ((LevelAccessor)worldView).m_186460_(abovePos, aboveState.m_60734_(), 0);
        }
        return structureBlockInfoToReturn;
    }

    protected StructureProcessorType<?> m_6953_() {
        return BzProcessors.POLLEN_PILING_PROCESSOR;
    }
}

