/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.world.features.decorators;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.the_bumblezone.modinit.BzPlacements;
import java.util.ArrayList;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class HoneycombHolePlacer
extends PlacementModifier {
    private static final HoneycombHolePlacer INSTANCE = new HoneycombHolePlacer();
    public static final Codec<HoneycombHolePlacer> CODEC = Codec.unit(() -> INSTANCE);

    public static HoneycombHolePlacer honeycombHolePlacer() {
        return INSTANCE;
    }

    public PlacementModifierType<?> m_183327_() {
        return BzPlacements.HONEYCOMB_HOLE_PLACER;
    }

    public Stream<BlockPos> m_183381_(PlacementContext placementContext, Random random, BlockPos blockPos) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(blockPos.m_123341_() - 4, 236, blockPos.m_123343_() + 4);
        ArrayList<BlockPos> blockPosList = new ArrayList<BlockPos>();
        boolean alternate = false;
        for (int repeat = 0; repeat < 2; ++repeat) {
            for (int count = 0; count < 23; ++count) {
                if (alternate) {
                    mutableBlockPos.m_122184_(0, -8, -8);
                } else {
                    mutableBlockPos.m_122184_(0, -8, 8);
                }
                boolean bl = alternate = !alternate;
                if (!this.isPlaceValid(placementContext, (BlockPos)mutableBlockPos)) continue;
                blockPosList.add(mutableBlockPos.m_7949_());
            }
            mutableBlockPos.m_122178_(blockPos.m_123341_() + 4, 236, blockPos.m_123343_() + 12);
        }
        return blockPosList.stream();
    }

    private boolean isPlaceValid(PlacementContext world, BlockPos pos) {
        boolean completelySolidSlice = false;
        boolean airInSlice = false;
        for (int x = -3; x <= 3; ++x) {
            SliceState state = this.StateOfThisSlice(world, pos.m_142386_(x));
            if (state == SliceState.SOLID) {
                completelySolidSlice = true;
                continue;
            }
            if (state != SliceState.AIR) continue;
            airInSlice = true;
        }
        return completelySolidSlice && airInSlice;
    }

    private SliceState StateOfThisSlice(PlacementContext world, BlockPos pos) {
        for (double z = -4.5; z <= 4.5; z += 1.0) {
            for (double y = -3.5; y <= 3.5; y += 1.0) {
                BlockState blockState;
                double distanceSq = z * z + y * y;
                if (!(distanceSq > 5.0) || !(distanceSq < 18.0) || (blockState = world.m_191828_(pos.m_142022_(0.0, y + 1.0, z))).m_60815_()) continue;
                if (blockState.m_60734_() == Blocks.f_50016_) {
                    return SliceState.AIR;
                }
                return SliceState.NEITHER;
            }
        }
        return SliceState.SOLID;
    }

    private static enum SliceState {
        NEITHER,
        AIR,
        SOLID;

    }
}

