/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.world.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.the_bumblezone.utils.OpenSimplex2F;
import com.telepathicgrunt.the_bumblezone.world.features.configs.BiomeBasedLayerConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class LayeredBlockSurface
extends Feature<BiomeBasedLayerConfig> {
    protected long seed;
    protected static OpenSimplex2F noiseGen;

    public void setSeed(long seed) {
        if (this.seed != seed || noiseGen == null) {
            noiseGen = new OpenSimplex2F(seed);
            this.seed = seed;
        }
    }

    public LayeredBlockSurface(Codec<BiomeBasedLayerConfig> configFactory) {
        super(configFactory);
    }

    public boolean m_142674_(FeaturePlaceContext<BiomeBasedLayerConfig> context) {
        this.setSeed(context.m_159774_().m_7328_());
        BlockPos.MutableBlockPos mutableBlockPos = context.m_159777_().m_122032_();
        BlockPos.MutableBlockPos mutableBlockPosForChunk = new BlockPos.MutableBlockPos();
        ChunkPos chunkPos = new ChunkPos((BlockPos)mutableBlockPos);
        Biome targetBiome = (Biome)context.m_159774_().m_5962_().m_175515_(Registry.f_122885_).m_7745_(((BiomeBasedLayerConfig)context.m_159778_()).biomeRL);
        for (int xOffset = -1; xOffset <= 1; ++xOffset) {
            for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                ChunkPos currentChunkPos = new ChunkPos(chunkPos.f_45578_ + xOffset, chunkPos.f_45579_ + zOffset);
                mutableBlockPosForChunk.m_122190_((Vec3i)currentChunkPos.m_45615_());
                ChunkAccess cachedChunk = context.m_159774_().m_46865_(currentChunkPos.m_45615_());
                this.fillChunkWithPollen(context, currentChunkPos.m_45615_(), cachedChunk, targetBiome);
            }
        }
        return true;
    }

    private boolean doesBiomeChangeInChunk(FeaturePlaceContext<BiomeBasedLayerConfig> context, BlockPos.MutableBlockPos mutableBlockPosForChunk) {
        ChunkGenerator chunkGenerator = context.m_159775_();
        Biome biome = (Biome)chunkGenerator.m_203495_(QuartPos.m_175400_((int)mutableBlockPosForChunk.m_123341_()), 40, QuartPos.m_175400_((int)mutableBlockPosForChunk.m_123343_())).m_203334_();
        if (biome != chunkGenerator.m_203495_(QuartPos.m_175400_((int)(mutableBlockPosForChunk.m_123341_() + 16)), 40, QuartPos.m_175400_((int)mutableBlockPosForChunk.m_123343_())).m_203334_()) {
            return true;
        }
        if (biome != chunkGenerator.m_203495_(QuartPos.m_175400_((int)mutableBlockPosForChunk.m_123341_()), 40, QuartPos.m_175400_((int)(mutableBlockPosForChunk.m_123343_() + 16))).m_203334_()) {
            return true;
        }
        return biome != chunkGenerator.m_203495_(QuartPos.m_175400_((int)(mutableBlockPosForChunk.m_123341_() + 16)), 40, QuartPos.m_175400_((int)(mutableBlockPosForChunk.m_123343_() + 16))).m_203334_();
    }

    private void fillChunkWithPollen(FeaturePlaceContext<BiomeBasedLayerConfig> context, BlockPos startPos, ChunkAccess chunk, Biome targetBiome) {
        int configHeight = ((BiomeBasedLayerConfig)context.m_159778_()).height;
        BlockState configBlockState = ((BiomeBasedLayerConfig)context.m_159778_()).state;
        BlockPos.MutableBlockPos mutable = context.m_159777_().m_122032_();
        BlockState previousBlockState = Blocks.f_50016_.m_49966_();
        boolean configBlockHasLayers = configBlockState.m_61138_((Property)BlockStateProperties.f_61417_);
        for (int xOffset = 0; xOffset <= 15; ++xOffset) {
            for (int zOffset = 0; zOffset <= 15; ++zOffset) {
                mutable.m_122178_(startPos.m_123341_() + xOffset, context.m_159775_().m_6331_() + context.m_159775_().m_142062_(), startPos.m_123343_() + zOffset);
                if (targetBiome != context.m_159774_().m_204166_((BlockPos)mutable).m_203334_()) continue;
                while (mutable.m_123342_() >= context.m_159775_().m_142062_()) {
                    BlockState currentBlockState = chunk.m_8055_((BlockPos)mutable);
                    if (!currentBlockState.m_60795_() && currentBlockState.m_60819_().m_76178_() && !currentBlockState.m_60713_(configBlockState.m_60734_()) && previousBlockState.m_60734_() == Blocks.f_50016_) {
                        for (int height = 1; height <= configHeight; ++height) {
                            if (configBlockHasLayers) {
                                int layerHeight = 8;
                                if (height == configHeight) {
                                    float xzScale = 0.035f;
                                    float yScale = 0.015f;
                                    double noiseVal = Math.abs(noiseGen.noise3_Classic((float)mutable.m_123341_() * xzScale, (float)mutable.m_123342_() * yScale + (float)height, (float)mutable.m_123343_() * xzScale));
                                    layerHeight = Math.max(1, (int)((noiseVal * 0.6 + 0.4) * 8.0));
                                    layerHeight = Math.min(8, layerHeight);
                                }
                                chunk.m_6978_(mutable.m_6630_(height), (BlockState)configBlockState.m_61124_((Property)BlockStateProperties.f_61417_, (Comparable)Integer.valueOf(layerHeight)), false);
                                context.m_159774_().m_186460_(mutable.m_6630_(height), configBlockState.m_60734_(), 0);
                                continue;
                            }
                            chunk.m_6978_(mutable.m_6630_(height), configBlockState, false);
                        }
                    }
                    previousBlockState = currentBlockState;
                    mutable.m_122173_(Direction.DOWN);
                }
            }
        }
    }
}

