/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.world.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ProductiveBeesCompat;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;

public class BlockEntityCombOre
extends Feature<OreConfiguration> {
    private static final Map<ResourceKey<Level>, Map<Long, ChunkAccess>> CACHED_CHUNKS_ALL_WORLDS = new WeakHashMap<ResourceKey<Level>, Map<Long, ChunkAccess>>();

    public BlockEntityCombOre(Codec<OreConfiguration> configFactory) {
        super(configFactory);
    }

    public boolean m_142674_(FeaturePlaceContext<OreConfiguration> context) {
        BlockPos.MutableBlockPos blockposMutable = new BlockPos.MutableBlockPos();
        float angleOfRotation = (float)(Math.PI * (double)context.m_159776_().nextFloat());
        float sinOfAngle = Mth.m_14031_((float)angleOfRotation);
        float cosOfAngle = Mth.m_14089_((float)angleOfRotation);
        float size = (float)((OreConfiguration)context.m_159778_()).f_67839_ * 0.5f;
        float stretchedFactor = 0.7f;
        if (((OreConfiguration)context.m_159778_()).f_67839_ < 10) {
            stretchedFactor = 1.0f;
        }
        int maxY = (int)(size / 3.0f);
        int minY = -maxY - 1;
        String nbt = null;
        if (ModChecker.productiveBeesPresent && ProductiveBeesCompat.PBIsConfigurableComb(((OreConfiguration.TargetBlockState)((OreConfiguration)context.m_159778_()).f_161005_.get((int)0)).f_161033_.m_60734_())) {
            nbt = ProductiveBeesCompat.PBGetRandomCombType(context.m_159776_());
        }
        for (int y = minY; y <= maxY; ++y) {
            float yModified = y;
            if (y < 0) {
                yModified = (float)y + 0.25f;
            } else if (y > 0) {
                y = (int)((float)y + 0.5f);
            }
            float percentageOfRadius = 1.0f - yModified / size * (yModified / size) * 3.0f;
            float majorRadiusSq = size * percentageOfRadius * (size * percentageOfRadius);
            float minorRadiusSq = size * stretchedFactor * percentageOfRadius * (size * stretchedFactor * percentageOfRadius);
            int x = (int)(-size);
            while ((float)x < size) {
                int z = (int)(-size);
                while ((float)z < size) {
                    float majorComp = ((float)x + 0.5f) * cosOfAngle - ((float)z + 0.5f) * sinOfAngle;
                    float minorComp = ((float)x + 0.5f) * sinOfAngle + ((float)z + 0.5f) * cosOfAngle;
                    float result = majorComp * majorComp / (majorRadiusSq * majorRadiusSq) + minorComp * minorComp / (minorRadiusSq * minorRadiusSq);
                    if (result * 100.0f < 1.0f && (x != 0 || z != 0 || !((float)(y * y) >= size * size))) {
                        blockposMutable.m_122178_(context.m_159777_().m_123341_() + x, context.m_159777_().m_123342_() + y, context.m_159777_().m_123343_() + z);
                        ChunkAccess cachedChunk = this.getCachedChunk((ServerLevelAccessor)context.m_159774_(), (BlockPos)blockposMutable);
                        BlockState blockToReplace = cachedChunk.m_8055_((BlockPos)blockposMutable);
                        for (OreConfiguration.TargetBlockState targetBlockState : ((OreConfiguration)context.m_159778_()).f_161005_) {
                            if (!targetBlockState.f_161032_.m_7715_(blockToReplace, context.m_159776_())) continue;
                            if (ModChecker.productiveBeesPresent && ProductiveBeesCompat.PBIsConfigurableComb(targetBlockState.f_161033_.m_60734_())) {
                                ProductiveBeesCompat.placeConfigurableCombBlockEntity(blockposMutable, cachedChunk, nbt, targetBlockState, targetBlockState.f_161033_.m_60734_());
                                continue;
                            }
                            cachedChunk.m_6978_((BlockPos)blockposMutable, targetBlockState.f_161033_, false);
                        }
                    }
                    ++z;
                }
                ++x;
            }
        }
        return true;
    }

    public ChunkAccess getCachedChunk(ServerLevelAccessor world, BlockPos blockpos) {
        long posLong;
        ChunkAccess cachedChunk;
        ResourceKey worldKey = world.m_6018_().m_46472_();
        Map worldStorage = CACHED_CHUNKS_ALL_WORLDS.computeIfAbsent((ResourceKey<Level>)worldKey, k -> new WeakHashMap());
        if (worldStorage.size() > 9) {
            worldStorage.clear();
        }
        if ((cachedChunk = (ChunkAccess)worldStorage.get(posLong = (long)(blockpos.m_123341_() >> 4) & 0xFFFFFFFFL | ((long)(blockpos.m_123343_() >> 4) & 0xFFFFFFFFL) << 32)) == null) {
            cachedChunk = world.m_46865_(blockpos);
            worldStorage.put(posLong, cachedChunk);
        }
        return cachedChunk;
    }
}

