/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.world.dimension;

import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.capabilities.BzCapabilities;
import com.telepathicgrunt.the_bumblezone.capabilities.EntityPositionAndDimension;
import com.telepathicgrunt.the_bumblezone.entities.EntityTeleportationBackend;
import com.telepathicgrunt.the_bumblezone.world.dimension.BzDimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;

public class BzWorldSavedData
extends SavedData {
    private static final String TELEPORTATION_DATA = "the_bumblezoneteleportation";
    private static final BzWorldSavedData CLIENT_DUMMY = new BzWorldSavedData(null);
    private static final List<Pair<Entity, ResourceKey<Level>>> QUEUED_ENTITIES_TO_TELEPORT = new ArrayList<Pair<Entity, ResourceKey<Level>>>();

    public BzWorldSavedData(CompoundTag tag) {
    }

    public static BzWorldSavedData get(Level world) {
        if (!(world instanceof ServerLevel)) {
            return CLIENT_DUMMY;
        }
        DimensionDataStorage storage = ((ServerLevel)world).m_8895_();
        return (BzWorldSavedData)storage.m_164858_(BzWorldSavedData::new, TELEPORTATION_DATA);
    }

    public CompoundTag m_7176_(CompoundTag data) {
        return null;
    }

    public static void queueEntityToTeleport(Entity entity, ResourceKey<Level> destination) {
        if (!BzWorldSavedData.isEntityQueuedToTeleportAlready(entity)) {
            QUEUED_ENTITIES_TO_TELEPORT.add((Pair<Entity, ResourceKey<Level>>)Pair.of((Object)entity, destination));
        }
    }

    public static boolean isEntityQueuedToTeleportAlready(Entity entity) {
        return QUEUED_ENTITIES_TO_TELEPORT.stream().anyMatch(entry -> ((Entity)entry.getFirst()).equals((Object)entity));
    }

    public static void worldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.world.m_5776_()) {
            BzWorldSavedData.tick((ServerLevel)event.world);
        }
    }

    public static void tick(ServerLevel world) {
        if (QUEUED_ENTITIES_TO_TELEPORT.size() == 0) {
            return;
        }
        HashSet<Entity> teleportedEntities = new HashSet<Entity>();
        for (Pair<Entity, ResourceKey<Level>> entry2 : QUEUED_ENTITIES_TO_TELEPORT) {
            Entity entity = (Entity)entry2.getFirst();
            if (teleportedEntities.contains(entity)) continue;
            ResourceKey destinationKey = (ResourceKey)entry2.getSecond();
            ServerLevel destination = world.m_6018_().m_142572_().m_129880_(destinationKey);
            if (destinationKey.equals(BzDimension.BZ_WORLD_KEY)) {
                BzWorldSavedData.enteringBumblezone(entity, teleportedEntities);
                continue;
            }
            if (entity.m_6688_() != null) {
                BzWorldSavedData.exitingBumblezone(entity.m_6688_(), destination, teleportedEntities);
                continue;
            }
            BzWorldSavedData.exitingBumblezone(entity, destination, teleportedEntities);
        }
        QUEUED_ENTITIES_TO_TELEPORT.removeIf(entry -> teleportedEntities.contains(entry.getFirst()));
    }

    public static void enteringBumblezone(Entity entity, Set<Entity> teleportedEntities) {
        if (!entity.f_19853_.m_5776_()) {
            EntityPositionAndDimension capability = (EntityPositionAndDimension)entity.getCapability(BzCapabilities.ENTITY_POS_AND_DIM_CAPABILITY).orElseThrow(RuntimeException::new);
            capability.setNonBZPos(entity.m_20182_());
            capability.setNonBZDim(entity.f_19853_.m_46472_().m_135782_());
            MinecraftServer minecraftServer = entity.m_20194_();
            ServerLevel bumblezoneWorld = minecraftServer.m_129880_(BzDimension.BZ_WORLD_KEY);
            if (bumblezoneWorld == null) {
                if (entity instanceof ServerPlayer) {
                    ServerPlayer playerEntity = (ServerPlayer)entity;
                    Bumblezone.LOGGER.log(org.apache.logging.log4j.Level.INFO, "Bumblezone: Please restart the server. The Bumblezone dimension hasn't been made yet due to this bug: https://bugs.mojang.com/browse/MC-195468. A restart will fix this.");
                    TextComponent message = new TextComponent("Please restart the server. The Bumblezone dimension hasn't been made yet due to this bug: \u00c2\u00a76https://bugs.mojang.com/browse/MC-195468\u00c2\u00a7f. A restart will fix this.");
                    playerEntity.m_5661_((Component)message, true);
                }
                return;
            }
            Vec3 destinationPosition = EntityTeleportationBackend.getBzCoordinate(entity, (ServerLevel)entity.f_19853_, bumblezoneWorld);
            Entity baseVehicle = entity.m_20201_();
            BzWorldSavedData.teleportEntityAndAssignToVehicle(baseVehicle, null, bumblezoneWorld, destinationPosition, teleportedEntities);
            ((ServerLevel)entity.f_19853_).m_8886_();
            bumblezoneWorld.m_8886_();
        }
    }

    public static void exitingBumblezone(Entity entity, ServerLevel destination, Set<Entity> teleportedEntities) {
        boolean upwardChecking = entity.m_20186_() > 0.0;
        Vec3 destinationPosition = EntityTeleportationBackend.destPostFromOutOfBoundsTeleport(entity, destination, upwardChecking);
        if (destinationPosition == null) {
            ((ServerPlayer)entity).m_5661_((Component)new TextComponent("Error teleporting out of Bumblezone. destinationPosition is null. Report to Bumblezone dev pls."), true);
        }
        Entity baseVehicle = entity.m_20201_();
        BzWorldSavedData.teleportEntityAndAssignToVehicle(baseVehicle, null, destination, destinationPosition, teleportedEntities);
        ((ServerLevel)entity.f_19853_).m_8886_();
        destination.m_8886_();
    }

    private static void teleportEntityAndAssignToVehicle(Entity entity, Entity vehicle, ServerLevel destination, Vec3 destinationPosition, Set<Entity> teleportedEntities) {
        Player teleportedEntity;
        List passengers = entity.m_20197_();
        entity.m_20153_();
        entity.m_20091_();
        if (destination.m_46472_().equals(BzDimension.BZ_WORLD_KEY)) {
            EntityPositionAndDimension capability = (EntityPositionAndDimension)entity.getCapability(BzCapabilities.ENTITY_POS_AND_DIM_CAPABILITY).orElseThrow(RuntimeException::new);
            capability.setNonBZPos(entity.m_20182_());
            capability.setNonBZDim(entity.f_19853_.m_46472_().m_135782_());
        }
        if (entity instanceof ServerPlayer) {
            if (destination.m_46472_().equals(BzDimension.BZ_WORLD_KEY)) {
                ((ServerPlayer)entity).m_5661_((Component)new TextComponent("Teleporting into the Bumblezone..."), true);
            } else {
                ((ServerPlayer)entity).m_5661_((Component)new TextComponent("Teleporting out of Bumblezone..."), true);
            }
            if (((ServerPlayer)entity).m_5803_()) {
                ((ServerPlayer)entity).m_6145_(true, true);
            }
            ((ServerPlayer)entity).m_8999_(destination, destinationPosition.f_82479_, destinationPosition.f_82480_, destinationPosition.f_82481_, entity.m_146908_(), entity.m_146909_());
            teleportedEntity = destination.m_46003_(entity.m_142081_());
        } else {
            Entity newEntity = entity;
            if ((newEntity = newEntity.m_6095_().m_20615_((Level)destination)) == null) {
                return;
            }
            entity.m_7678_(destinationPosition.f_82479_, destinationPosition.f_82480_, destinationPosition.f_82481_, entity.m_146908_(), entity.m_146909_());
            newEntity.m_20361_(entity);
            newEntity.m_7678_(destinationPosition.f_82479_, destinationPosition.f_82480_, destinationPosition.f_82481_, entity.m_146908_(), entity.m_146909_());
            destination.m_143334_(newEntity);
            teleportedEntity = newEntity;
            entity.m_142687_(Entity.RemovalReason.CHANGED_DIMENSION);
        }
        if (teleportedEntity != null) {
            teleportedEntities.add(entity);
            ChunkPos chunkpos = new ChunkPos(new BlockPos(destinationPosition.f_82479_, destinationPosition.f_82480_, destinationPosition.f_82481_));
            destination.m_7726_().m_8387_(TicketType.f_9448_, chunkpos, 1, (Object)entity.m_142049_());
            if (vehicle != null) {
                teleportedEntity.m_20329_(vehicle);
            }
            if (teleportedEntity instanceof LivingEntity) {
                BzWorldSavedData.reAddStatusEffect((LivingEntity)teleportedEntity);
            }
            passengers.forEach(arg_0 -> BzWorldSavedData.lambda$teleportEntityAndAssignToVehicle$2((Entity)teleportedEntity, destination, destinationPosition, teleportedEntities, arg_0));
        }
    }

    private static void reAddStatusEffect(LivingEntity livingEntity) {
        ArrayList effectInstanceList = new ArrayList(livingEntity.m_21220_());
        for (int i = effectInstanceList.size() - 1; i >= 0; --i) {
            MobEffectInstance effectInstance = (MobEffectInstance)effectInstanceList.get(i);
            if (effectInstance == null) continue;
            livingEntity.m_21195_(effectInstance.m_19544_());
            livingEntity.m_7292_(new MobEffectInstance(effectInstance.m_19544_(), effectInstance.m_19557_(), effectInstance.m_19564_(), effectInstance.m_19571_(), effectInstance.m_19572_(), effectInstance.m_19575_()));
        }
    }

    private static /* synthetic */ void lambda$teleportEntityAndAssignToVehicle$2(Entity teleportedEntity, ServerLevel destination, Vec3 destinationPosition, Set teleportedEntities, Entity passenger) {
        BzWorldSavedData.teleportEntityAndAssignToVehicle(passenger, teleportedEntity, destination, destinationPosition, teleportedEntities);
    }
}

