/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.world.dimension;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.mixin.world.NoiseChunkAccessor;
import com.telepathicgrunt.the_bumblezone.mixin.world.NoiseGeneratorSettingsInvoker;
import com.telepathicgrunt.the_bumblezone.modinit.BzEntities;
import com.telepathicgrunt.the_bumblezone.utils.BzPlacingUtils;
import com.telepathicgrunt.the_bumblezone.utils.OpenSimplex2F;
import com.telepathicgrunt.the_bumblezone.world.dimension.BiomeInfluencedNoiseSampler;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.Mth;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.Beardifier;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.SurfaceSystem;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import org.jetbrains.annotations.Nullable;

public class BzChunkGenerator
extends ChunkGenerator {
    public static final Codec<BzChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryOps.m_206832_((ResourceKey)Registry.f_211073_).forGetter(bzChunkGenerator -> bzChunkGenerator.f_207955_), (App)RegistryOps.m_206832_((ResourceKey)Registry.f_194568_).forGetter(bzChunkGenerator -> bzChunkGenerator.noises), (App)BiomeSource.f_47888_.fieldOf("biome_source").forGetter(bzChunkGenerator -> bzChunkGenerator.f_62137_), (App)Codec.LONG.fieldOf("seed").orElse((Object)0L).stable().forGetter(bzChunkGenerator -> bzChunkGenerator.seed), (App)NoiseGeneratorSettings.f_64431_.fieldOf("settings").forGetter(bzChunkGenerator -> bzChunkGenerator.settings), (App)RegistryOps.m_206832_((ResourceKey)Registry.f_122885_).forGetter(bzChunkGenerator -> bzChunkGenerator.biomeRegistry), (App)RegistryOps.m_206832_((ResourceKey)Registry.f_122882_).forGetter(bzChunkGenerator -> bzChunkGenerator.configuredStructureFeaturesRegistry)).apply((Applicative)instance, instance.stable(BzChunkGenerator::new)));
    private static final BlockState[] EMPTY_COLUMN = new BlockState[0];
    protected final BlockState defaultBlock;
    protected final BlockState defaultFluid;
    private final Registry<NormalNoise.NoiseParameters> noises;
    private final long seed;
    protected final Holder<NoiseGeneratorSettings> settings;
    private final NoiseRouter router;
    private final Climate.Sampler sampler;
    private final Registry<Biome> biomeRegistry;
    private final Registry<ConfiguredStructureFeature<?, ?>> configuredStructureFeaturesRegistry;
    private final SurfaceSystem surfaceSystem;
    private final Aquifer.FluidPicker globalFluidPicker;
    private static final MobSpawnSettings.SpawnerData INITIAL_HONEY_SLIME_ENTRY = new MobSpawnSettings.SpawnerData((EntityType)BzEntities.HONEY_SLIME.get(), 1, 1, 3);
    private static final MobSpawnSettings.SpawnerData INITIAL_BEE_ENTRY = new MobSpawnSettings.SpawnerData(EntityType.f_20550_, 1, 1, 4);
    private static final MobSpawnSettings.SpawnerData INITIAL_BEEHEMOTH_ENTRY = new MobSpawnSettings.SpawnerData((EntityType)BzEntities.BEEHEMOTH.get(), 1, 1, 1);

    public BzChunkGenerator(Registry<StructureSet> structureSetRegistry, Registry<NormalNoise.NoiseParameters> parametersRegistry, BiomeSource biomeSource, long seed, Holder<NoiseGeneratorSettings> supplier, Registry<Biome> biomeRegistry, Registry<ConfiguredStructureFeature<?, ?>> configuredStructureFeaturesRegistry) {
        this(structureSetRegistry, parametersRegistry, biomeSource, biomeSource, seed, supplier, biomeRegistry, configuredStructureFeaturesRegistry);
    }

    private BzChunkGenerator(Registry<StructureSet> structureSetRegistry, Registry<NormalNoise.NoiseParameters> parametersRegistry, BiomeSource biomeSource, BiomeSource biomeSource2, long seed, Holder<NoiseGeneratorSettings> supplier, Registry<Biome> biomeRegistry, Registry<ConfiguredStructureFeature<?, ?>> configuredStructureFeaturesRegistry) {
        super(structureSetRegistry, Optional.empty(), biomeSource, biomeSource2, seed);
        this.noises = parametersRegistry;
        this.seed = seed;
        this.settings = supplier;
        this.biomeRegistry = biomeRegistry;
        NoiseGeneratorSettings noiseGeneratorSettings = (NoiseGeneratorSettings)this.settings.m_203334_();
        this.defaultBlock = noiseGeneratorSettings.f_64440_();
        this.defaultFluid = noiseGeneratorSettings.f_64441_();
        NoiseRouter noiseRouter = noiseGeneratorSettings.m_209366_(parametersRegistry, seed);
        this.sampler = new Climate.Sampler(noiseRouter.f_209384_(), noiseRouter.f_209385_(), noiseRouter.f_209386_(), noiseRouter.f_209387_(), noiseRouter.f_209388_(), noiseRouter.f_209389_(), noiseRouter.f_209395_());
        DensityFunction newFinalDensity = DensityFunctions.m_208293_((DensityFunction)new BiomeNoise(this.m_183403_(), this.biomeRegistry, this.m_62218_()), (DensityFunction)noiseRouter.f_209391_());
        newFinalDensity = DensityFunctions.m_208281_((DensityFunction)newFinalDensity);
        newFinalDensity = DensityFunctions.m_208293_((DensityFunction)new RoughSurfaceNoise(), (DensityFunction)newFinalDensity);
        newFinalDensity = DensityFunctions.m_208281_((DensityFunction)newFinalDensity);
        this.router = new NoiseRouter(noiseRouter.f_209378_(), noiseRouter.f_209379_(), noiseRouter.f_209380_(), noiseRouter.f_209381_(), noiseRouter.f_209382_(), noiseRouter.f_209383_(), noiseRouter.f_209384_(), noiseRouter.f_209385_(), noiseRouter.f_209386_(), noiseRouter.f_209387_(), noiseRouter.f_209388_(), noiseRouter.f_209389_(), noiseRouter.f_209390_(), newFinalDensity, noiseRouter.f_209392_(), noiseRouter.f_209393_(), noiseRouter.f_209394_(), noiseRouter.f_209395_());
        Aquifer.FluidStatus fluidStatus = new Aquifer.FluidStatus(-54, Blocks.f_49991_.m_49966_());
        int seaLevel = noiseGeneratorSettings.f_64444_();
        Aquifer.FluidStatus fluidStatus2 = new Aquifer.FluidStatus(seaLevel, noiseGeneratorSettings.f_64441_());
        this.globalFluidPicker = (j, k, lx) -> k < Math.min(-54, seaLevel) ? fluidStatus : fluidStatus2;
        this.surfaceSystem = new SurfaceSystem(parametersRegistry, this.defaultBlock, seaLevel, seed, noiseGeneratorSettings.m_188893_());
        this.configuredStructureFeaturesRegistry = configuredStructureFeaturesRegistry;
    }

    public static void registerChunkGenerator() {
        Registry.m_122965_((Registry)Registry.f_122890_, (ResourceLocation)new ResourceLocation("the_bumblezone", "chunk_generator"), CODEC);
    }

    public Climate.Sampler m_183403_() {
        return this.sampler;
    }

    public void m_183516_(WorldGenRegion worldGenRegion, long seed, BiomeManager biomeManager, StructureFeatureManager structureFeatureManager, ChunkAccess chunkAccess, GenerationStep.Carving carving) {
    }

    protected Codec<? extends ChunkGenerator> m_6909_() {
        return CODEC;
    }

    public ChunkGenerator m_6819_(long seed) {
        return new BzChunkGenerator((Registry<StructureSet>)this.f_207955_, this.noises, this.f_62137_.m_7206_(seed), seed, this.settings, this.biomeRegistry, this.configuredStructureFeaturesRegistry);
    }

    public boolean stable(long seed, ResourceKey<NoiseGeneratorSettings> resourceKey) {
        return this.seed == seed && this.settings.m_203565_(resourceKey);
    }

    public int m_142647_(int x, int z, Heightmap.Types types, LevelHeightAccessor levelHeightAccessor) {
        NoiseSettings noiseSettings = ((NoiseGeneratorSettings)this.settings.m_203334_()).f_64439_();
        int maxY = Math.max(noiseSettings.f_158688_(), levelHeightAccessor.m_141937_());
        int minY = Math.min(noiseSettings.f_158688_() + noiseSettings.f_64508_(), levelHeightAccessor.m_151558_());
        int maxYCell = Mth.m_14042_((int)maxY, (int)noiseSettings.m_189212_());
        int minYCell = Mth.m_14042_((int)(minY - maxY), (int)noiseSettings.m_189212_());
        return minYCell <= 0 ? levelHeightAccessor.m_141937_() : this.iterateNoiseColumn(x, z, null, types.m_64299_(), maxYCell, minYCell).orElse(levelHeightAccessor.m_141937_());
    }

    public NoiseColumn m_141914_(int x, int z, LevelHeightAccessor levelHeightAccessor) {
        NoiseSettings noiseSettings = ((NoiseGeneratorSettings)this.settings.m_203334_()).f_64439_();
        int minY = Math.max(noiseSettings.f_158688_(), levelHeightAccessor.m_141937_());
        int maxY = Math.min(noiseSettings.f_158688_() + noiseSettings.f_64508_(), levelHeightAccessor.m_151558_());
        int minYCell = Mth.m_14042_((int)minY, (int)noiseSettings.m_189212_());
        int maxYCell = Mth.m_14042_((int)(maxY - minY), (int)noiseSettings.m_189212_());
        if (maxYCell <= 0) {
            return new NoiseColumn(minY, EMPTY_COLUMN);
        }
        BlockState[] blockStates = new BlockState[maxYCell * noiseSettings.m_189212_()];
        this.iterateNoiseColumn(x, z, blockStates, null, minYCell, maxYCell);
        return new NoiseColumn(minY, blockStates);
    }

    public void m_207076_(List<String> list, BlockPos blockPos) {
    }

    private OptionalInt iterateNoiseColumn(int x, int z, @Nullable BlockState[] blockStates, @Nullable Predicate<BlockState> predicate, int minYCell, int maxYCell) {
        NoiseSettings noiseSettings = ((NoiseGeneratorSettings)this.settings.m_203334_()).f_64439_();
        int cellWidth = noiseSettings.m_189213_();
        int cellHeight = noiseSettings.m_189212_();
        int o = Math.floorDiv(x, cellWidth);
        int p = Math.floorDiv(z, cellWidth);
        int q = Math.floorMod(x, cellWidth);
        int r = Math.floorMod(z, cellWidth);
        int s = o * cellWidth;
        int t = p * cellWidth;
        double d = (double)q / (double)cellWidth;
        double e = (double)r / (double)cellWidth;
        NoiseChunk noiseChunk = NoiseChunk.m_209194_((int)s, (int)t, (int)minYCell, (int)maxYCell, (NoiseRouter)this.router, (NoiseGeneratorSettings)((NoiseGeneratorSettings)this.settings.m_203334_()), (Aquifer.FluidPicker)this.globalFluidPicker);
        noiseChunk.m_188791_();
        noiseChunk.m_188749_(0);
        for (int currentYCell = maxYCell - 1; currentYCell >= 0; --currentYCell) {
            noiseChunk.m_188810_(currentYCell, 0);
            for (int yInCell = cellHeight - 1; yInCell >= 0; --yInCell) {
                BlockState blockState2;
                int y = (minYCell + currentYCell) * cellHeight + yInCell;
                double f = (double)yInCell / (double)cellHeight;
                noiseChunk.m_209191_(y, f);
                noiseChunk.m_209230_(x, d);
                noiseChunk.m_209241_(z, e);
                BlockState blockState = ((NoiseChunkAccessor)noiseChunk).callGetInterpolatedState();
                BlockState blockState3 = blockState2 = blockState == null ? this.defaultBlock : blockState;
                if ((blockState == null || blockState.m_60795_()) && y < this.m_6337_()) {
                    blockState2 = this.defaultFluid;
                }
                if (blockStates != null) {
                    int index = currentYCell * cellHeight + yInCell;
                    blockStates[index] = blockState2;
                }
                if (predicate == null || !predicate.test(blockState2)) continue;
                return OptionalInt.of(y + 1);
            }
        }
        return OptionalInt.empty();
    }

    public void m_183621_(WorldGenRegion worldGenRegion, StructureFeatureManager structureFeatureManager, ChunkAccess chunkAccess) {
        if (!SharedConstants.m_183707_((ChunkPos)chunkAccess.m_7697_())) {
            WorldGenerationContext worldGenerationContext = new WorldGenerationContext((ChunkGenerator)this, (LevelHeightAccessor)worldGenRegion);
            NoiseGeneratorSettings noiseGeneratorSettings = (NoiseGeneratorSettings)this.settings.m_203334_();
            NoiseChunk noiseChunk = chunkAccess.m_207937_(this.router, () -> new Beardifier(structureFeatureManager, chunkAccess), noiseGeneratorSettings, this.globalFluidPicker, Blender.m_190202_((WorldGenRegion)worldGenRegion));
            this.surfaceSystem.m_189944_(worldGenRegion.m_7062_(), worldGenRegion.m_5962_().m_175515_(Registry.f_122885_), noiseGeneratorSettings.f_209354_(), worldGenerationContext, chunkAccess, noiseChunk, noiseGeneratorSettings.f_188871_());
        }
    }

    public CompletableFuture<ChunkAccess> m_183489_(Executor executor, Blender blender, StructureFeatureManager structureFeatureManager, ChunkAccess chunkAccess) {
        NoiseSettings noiseSettings = ((NoiseGeneratorSettings)this.settings.m_203334_()).f_64439_();
        LevelHeightAccessor levelHeightAccessor = chunkAccess.m_183618_();
        int minY = Math.max(noiseSettings.f_158688_(), levelHeightAccessor.m_141937_());
        int maxY = Math.min(noiseSettings.f_158688_() + noiseSettings.f_64508_(), levelHeightAccessor.m_151558_());
        int minYCell = Mth.m_14042_((int)minY, (int)noiseSettings.m_189212_());
        int maxYCell = Mth.m_14042_((int)(maxY - minY), (int)noiseSettings.m_189212_());
        if (maxYCell <= 0) {
            return CompletableFuture.completedFuture(chunkAccess);
        }
        int maxChunkSection = chunkAccess.m_151564_(maxYCell * noiseSettings.m_189212_() - 1 + minY);
        int minChunkSection = chunkAccess.m_151564_(minY);
        HashSet set = Sets.newHashSet();
        for (int currentChunkSection = maxChunkSection; currentChunkSection >= minChunkSection; --currentChunkSection) {
            LevelChunkSection levelChunkSection = chunkAccess.m_183278_(currentChunkSection);
            levelChunkSection.m_62981_();
            set.add(levelChunkSection);
        }
        return CompletableFuture.supplyAsync(Util.m_183946_((String)"wgen_fill_noise", () -> this.doFill(blender, structureFeatureManager, chunkAccess, minYCell, maxYCell)), Util.m_183991_()).whenCompleteAsync((chunkAccessx, throwable) -> {
            for (LevelChunkSection levelChunkSectionx : set) {
                levelChunkSectionx.m_63006_();
            }
        }, executor);
    }

    private ChunkAccess doFill(Blender blender, StructureFeatureManager structureFeatureManager, ChunkAccess chunkAccess, int minYCell, int maxYCell) {
        NoiseGeneratorSettings noiseGeneratorSettings = (NoiseGeneratorSettings)this.settings.m_203334_();
        NoiseChunk noiseChunk = chunkAccess.m_207937_(this.router, () -> new Beardifier(structureFeatureManager, chunkAccess), noiseGeneratorSettings, this.globalFluidPicker, blender);
        Heightmap heightmap = chunkAccess.m_6005_(Heightmap.Types.OCEAN_FLOOR_WG);
        Heightmap heightmap2 = chunkAccess.m_6005_(Heightmap.Types.WORLD_SURFACE_WG);
        ChunkPos chunkPos = chunkAccess.m_7697_();
        int k = chunkPos.m_45604_();
        int l = chunkPos.m_45605_();
        Aquifer aquifer = noiseChunk.m_188817_();
        noiseChunk.m_188791_();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        NoiseSettings noiseSettings = noiseGeneratorSettings.f_64439_();
        int m = noiseSettings.m_189213_();
        int n = noiseSettings.m_189212_();
        int o = 16 / m;
        int p = 16 / m;
        for (int q = 0; q < o; ++q) {
            noiseChunk.m_188749_(q);
            for (int r = 0; r < p; ++r) {
                LevelChunkSection levelChunkSection = chunkAccess.m_183278_(chunkAccess.m_151559_() - 1);
                for (int s = maxYCell - 1; s >= 0; --s) {
                    noiseChunk.m_188810_(s, r);
                    for (int t = n - 1; t >= 0; --t) {
                        int yy = (minYCell + s) * n + t;
                        int v = yy & 0xF;
                        int w = chunkAccess.m_151564_(yy);
                        if (chunkAccess.m_151564_(levelChunkSection.m_63017_()) != w) {
                            levelChunkSection = chunkAccess.m_183278_(w);
                        }
                        double d = (double)t / (double)n;
                        for (int x = 0; x < m; ++x) {
                            int xx = k + q * m + x;
                            int z = xx & 0xF;
                            double e = (double)x / (double)m;
                            noiseChunk.m_209230_(xx, e);
                            for (int aa = 0; aa < m; ++aa) {
                                int zz = l + r * m + aa;
                                int ac = zz & 0xF;
                                double f = (double)aa / (double)m;
                                noiseChunk.m_209241_(zz, f);
                                noiseChunk.m_209191_(yy, d);
                                BlockState blockState = ((NoiseChunkAccessor)noiseChunk).callGetInterpolatedState();
                                if (blockState == null) {
                                    blockState = this.defaultBlock;
                                }
                                if (blockState.m_60795_() && yy < this.m_6337_()) {
                                    blockState = this.defaultFluid;
                                }
                                if (blockState.m_60795_() || SharedConstants.m_183707_((ChunkPos)chunkAccess.m_7697_())) continue;
                                if (blockState.m_60791_() != 0 && chunkAccess instanceof ProtoChunk) {
                                    mutableBlockPos.m_122178_(xx, yy, zz);
                                    ((ProtoChunk)chunkAccess).m_63277_((BlockPos)mutableBlockPos);
                                }
                                levelChunkSection.m_62991_(z, v, ac, blockState, false);
                                heightmap.m_64249_(z, yy, ac, blockState);
                                heightmap2.m_64249_(z, yy, ac, blockState);
                                if (!aquifer.m_142203_() || blockState.m_60819_().m_76178_()) continue;
                                mutableBlockPos.m_122178_(xx, yy, zz);
                                chunkAccess.m_8113_((BlockPos)mutableBlockPos);
                            }
                        }
                    }
                }
            }
            noiseChunk.m_188804_();
        }
        return chunkAccess;
    }

    public int m_6331_() {
        return ((NoiseGeneratorSettings)this.settings.m_203334_()).f_64439_().f_64508_();
    }

    public int m_6337_() {
        return ((NoiseGeneratorSettings)this.settings.m_203334_()).f_64444_();
    }

    public int m_142062_() {
        return ((NoiseGeneratorSettings)this.settings.m_203334_()).f_64439_().f_158688_();
    }

    @Deprecated
    public Optional<BlockState> topMaterial(CarvingContext carvingContext, Function<BlockPos, Holder<Biome>> function, ChunkAccess chunkAccess, NoiseChunk noiseChunk, BlockPos blockPos, boolean bl) {
        return this.surfaceSystem.m_189971_(((NoiseGeneratorSettings)this.settings.m_203334_()).f_188871_(), carvingContext, function, chunkAccess, noiseChunk, blockPos, bl);
    }

    public WeightedRandomList<MobSpawnSettings.SpawnerData> m_203315_(Holder<Biome> biome, StructureFeatureManager accessor, MobCategory group, BlockPos pos) {
        return super.m_203315_(biome, accessor, group, pos);
    }

    public void m_6929_(WorldGenRegion region) {
        NoiseGeneratorSettings noiseGeneratorSettings = (NoiseGeneratorSettings)this.settings.m_203334_();
        if (!((NoiseGeneratorSettingsInvoker)noiseGeneratorSettings).thebumblezone_callDisableMobGeneration()) {
            ChunkPos chunkPos = region.m_143488_();
            Biome biome = (Biome)region.m_204166_(chunkPos.m_45615_()).m_203334_();
            WorldgenRandom sharedseedrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(RandomSupport.m_189328_()));
            sharedseedrandom.m_64690_(region.m_7328_(), chunkPos.m_45604_(), chunkPos.m_45605_());
            while (sharedseedrandom.nextFloat() < biome.m_47518_().m_48344_()) {
                Mob mobEntity;
                float threshold = sharedseedrandom.nextFloat();
                MobSpawnSettings.SpawnerData biome$spawnlistentry = threshold < 0.15f ? INITIAL_HONEY_SLIME_ENTRY : (threshold < 0.95f ? INITIAL_BEE_ENTRY : INITIAL_BEEHEMOTH_ENTRY);
                int startingX = chunkPos.m_45604_() + sharedseedrandom.nextInt(16);
                int startingZ = chunkPos.m_45605_() + sharedseedrandom.nextInt(16);
                BlockPos.MutableBlockPos blockpos = new BlockPos.MutableBlockPos(startingX, 0, startingZ);
                int height = BzPlacingUtils.topOfSurfaceBelowHeight((LevelAccessor)region, sharedseedrandom.nextInt(255), -1, (BlockPos)blockpos) + 1;
                if (!biome$spawnlistentry.f_48404_.m_20654_() || height <= 0 || height >= 255) continue;
                float width = biome$spawnlistentry.f_48404_.m_20678_();
                double xLength = Mth.m_14008_((double)startingX, (double)((double)chunkPos.m_45604_() + (double)width), (double)((double)chunkPos.m_45604_() + 16.0 - (double)width));
                double zLength = Mth.m_14008_((double)startingZ, (double)((double)chunkPos.m_45605_() + (double)width), (double)((double)chunkPos.m_45605_() + 16.0 - (double)width));
                Entity entity = biome$spawnlistentry.f_48404_.m_20615_((Level)region.m_6018_());
                if (entity == null) continue;
                entity.m_7678_(xLength, (double)height, zLength, sharedseedrandom.nextFloat() * 360.0f, 0.0f);
                if (!(entity instanceof Mob) || !(mobEntity = (Mob)entity).m_5545_((LevelAccessor)region, MobSpawnType.CHUNK_GENERATION) || !mobEntity.m_6914_((LevelReader)region)) continue;
                mobEntity.m_6518_((ServerLevelAccessor)region, region.m_6436_(new BlockPos(mobEntity.m_20182_())), MobSpawnType.CHUNK_GENERATION, null, null);
                region.m_7967_((Entity)mobEntity);
            }
        }
    }

    record BiomeNoise(Climate.Sampler sampler, Registry<Biome> biomeRegistry, BiomeSource biomeSource) implements DensityFunction.SimpleFunction
    {
        public double m_207386_(DensityFunction.FunctionContext functionContext) {
            return BiomeInfluencedNoiseSampler.calculateBaseNoise(functionContext.m_207115_(), functionContext.m_207113_(), this.sampler, this.biomeSource, this.biomeRegistry);
        }

        public double m_207402_() {
            return 0.0;
        }

        public double m_207401_() {
            return 2.0;
        }

        public Codec<? extends DensityFunction> m_207500_() {
            return null;
        }
    }

    record RoughSurfaceNoise() implements DensityFunction.SimpleFunction
    {
        private static final OpenSimplex2F noiseGen = new OpenSimplex2F(0L);

        public double m_207386_(DensityFunction.FunctionContext functionContext) {
            return noiseGen.noise3_Classic(functionContext.m_207115_(), functionContext.m_207114_(), functionContext.m_207113_()) / 100.0 - 0.01;
        }

        public double m_207402_() {
            return 0.0;
        }

        public double m_207401_() {
            return 2.0;
        }

        public Codec<? extends DensityFunction> m_207500_() {
            return null;
        }
    }
}

