/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.world.dimension;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.mixin.world.BiomeSourceAccessor;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.BzBiomeLayer;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.BzBiomeMergeLayer;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.BzBiomeNonstandardLayer;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.BzBiomePillarLayer;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.BzBiomePollinatedFieldsLayer;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.BzBiomePollinatedPillarLayer;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.BzBiomeScaleLayer;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.vanilla.Area;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.vanilla.AreaFactory;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.vanilla.AreaTransformer1;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.vanilla.BigContext;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.vanilla.Layer;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.vanilla.LazyArea;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.vanilla.LazyAreaContext;
import com.telepathicgrunt.the_bumblezone.world.dimension.layer.vanilla.ZoomLayer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.LongFunction;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;

public class BzBiomeProvider
extends BiomeSource {
    public static final Codec<BzBiomeProvider> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("seed").orElse((Object)0L).stable().forGetter(bzBiomeProvider -> bzBiomeProvider.seed), (App)RegistryOps.m_206832_((ResourceKey)Registry.f_122885_).forGetter(biomeSource -> biomeSource.biomeRegistry)).apply((Applicative)instance, instance.stable(BzBiomeProvider::new)));
    public static ResourceLocation HIVE_WALL = new ResourceLocation("the_bumblezone", "hive_wall");
    public static ResourceLocation HIVE_PILLAR = new ResourceLocation("the_bumblezone", "hive_pillar");
    public static ResourceLocation SUGAR_WATER_FLOOR = new ResourceLocation("the_bumblezone", "sugar_water_floor");
    public static ResourceLocation POLLINATED_FIELDS = new ResourceLocation("the_bumblezone", "pollinated_fields");
    public static ResourceLocation POLLINATED_PILLAR = new ResourceLocation("the_bumblezone", "pollinated_pillar");
    private final long seed;
    private final Layer biomeSampler;
    private final Registry<Biome> biomeRegistry;
    public static List<Biome> nonstandardBiome = new ArrayList<Biome>();

    public BzBiomeProvider(long seed, Registry<Biome> biomeRegistry) {
        super(biomeRegistry.m_203611_().filter(entry -> entry.m_205785_().m_135782_().m_135827_().equals("the_bumblezone")).collect(Collectors.toList()));
        nonstandardBiome = ((BiomeSourceAccessor)((Object)this)).getPossibleBiomes().stream().map(Holder::m_203334_).filter(biome -> {
            ResourceLocation rlKey = biomeRegistry.m_7981_(biome);
            return rlKey != null && !rlKey.equals((Object)HIVE_WALL) && !rlKey.equals((Object)HIVE_PILLAR) && !rlKey.equals((Object)SUGAR_WATER_FLOOR) && !rlKey.equals((Object)POLLINATED_FIELDS) && !rlKey.equals((Object)POLLINATED_PILLAR);
        }).collect(Collectors.toList());
        this.seed = seed;
        this.biomeRegistry = biomeRegistry;
        this.biomeSampler = BzBiomeProvider.buildWorldProcedure(seed, biomeRegistry);
    }

    public static void registerBiomeProvider() {
        Registry.m_122965_((Registry)Registry.f_122889_, (ResourceLocation)new ResourceLocation("the_bumblezone", "biome_source"), CODEC);
    }

    protected Codec<? extends BiomeSource> m_5820_() {
        return CODEC;
    }

    public BiomeSource m_7206_(long seed) {
        return new BzBiomeProvider(seed, this.biomeRegistry);
    }

    public static <T extends Area, C extends BigContext<T>> AreaFactory<T> stack(long seed, AreaTransformer1 parent, AreaFactory<T> incomingArea, int count, LongFunction<C> contextFactory) {
        AreaFactory<T> LayerFactory = incomingArea;
        for (int i = 0; i < count; ++i) {
            LayerFactory = parent.run((BigContext)contextFactory.apply(seed + (long)i), LayerFactory);
        }
        return LayerFactory;
    }

    public static Layer buildWorldProcedure(long seed, Registry<Biome> biomeRegistry) {
        AreaFactory<LazyArea> layerFactory = BzBiomeProvider.build(salt -> new LazyAreaContext(25, seed, salt), seed, biomeRegistry);
        return new Layer(layerFactory);
    }

    public static <T extends Area, C extends BigContext<T>> AreaFactory<T> build(LongFunction<C> contextFactory, long seed, Registry<Biome> biomeRegistry) {
        AreaFactory layer = new BzBiomeLayer(seed, biomeRegistry).run((BigContext)contextFactory.apply(200L));
        layer = new BzBiomePillarLayer(biomeRegistry).run((BigContext)contextFactory.apply(1008L), layer);
        layer = new BzBiomeScaleLayer(HIVE_PILLAR, biomeRegistry).run((BigContext)contextFactory.apply(1055L), layer);
        layer = ZoomLayer.FUZZY.run((BigContext)contextFactory.apply(2003L), layer);
        layer = ZoomLayer.FUZZY.run((BigContext)contextFactory.apply(2523L), layer);
        AreaFactory layerOverlay = new BzBiomeNonstandardLayer(biomeRegistry).run((BigContext)contextFactory.apply(204L));
        layerOverlay = ZoomLayer.NORMAL.run((BigContext)contextFactory.apply(2423L), layerOverlay);
        layerOverlay = new BzBiomePollinatedPillarLayer(biomeRegistry).run((BigContext)contextFactory.apply(3008L), layerOverlay);
        layerOverlay = new BzBiomeScaleLayer(POLLINATED_PILLAR, biomeRegistry).run((BigContext)contextFactory.apply(4455L), layerOverlay);
        layerOverlay = ZoomLayer.NORMAL.run((BigContext)contextFactory.apply(2503L), layerOverlay);
        layerOverlay = ZoomLayer.NORMAL.run((BigContext)contextFactory.apply(2603L), layerOverlay);
        layerOverlay = new BzBiomePollinatedFieldsLayer(biomeRegistry).run((BigContext)contextFactory.apply(3578L), layerOverlay);
        layerOverlay = new BzBiomeScaleLayer(POLLINATED_FIELDS, biomeRegistry).run((BigContext)contextFactory.apply(4055L), layerOverlay);
        layerOverlay = ZoomLayer.FUZZY.run((BigContext)contextFactory.apply(2853L), layerOverlay);
        layerOverlay = ZoomLayer.FUZZY.run((BigContext)contextFactory.apply(3583L), layerOverlay);
        layerOverlay = ZoomLayer.NORMAL.run((BigContext)contextFactory.apply(4583L), layerOverlay);
        layer = new BzBiomeMergeLayer().run((BigContext)contextFactory.apply(5583L), layerOverlay, layer);
        return layer;
    }

    public Holder<Biome> m_203407_(int x, int y, int z, Climate.Sampler sampler) {
        return this.biomeSampler.sample(this.biomeRegistry, x, z);
    }
}

