/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.world.dimension;

import com.telepathicgrunt.the_bumblezone.modinit.BzBiomeHeightRegistry;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;

public final class BiomeInfluencedNoiseSampler {
    private static final int RADIUS = 2;
    private static final float[] BIOME_WEIGHT_TABLE = (float[])Util.m_137469_((Object)new float[(int)Math.pow(5.0, 2.0)], array -> {
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                float weight = 10.0f / Mth.m_14116_((float)((float)(x * x + z * z) + 0.2f));
                array[x + 2 + (z + 2) * 5] = weight / 22.0f;
            }
        }
    });
    private static final Map<Long, Float> CACHED_INFLUENCE_RESULT = new ConcurrentHashMap<Long, Float>();

    public static double calculateBaseNoise(int x, int z, Climate.Sampler sampler, BiomeSource biomeSource, Registry<Biome> biomeRegistry) {
        long longPos = (long)x & 0xFFFFFFFFL | ((long)z & 0xFFFFFFFFL) << 32;
        Float cachedResult = CACHED_INFLUENCE_RESULT.get(longPos);
        if (cachedResult != null) {
            return cachedResult.floatValue();
        }
        BzBiomeHeightRegistry.BiomeTerrain centerBiomeInfo = BzBiomeHeightRegistry.BIOME_HEIGHT_REGISTRY.m_6612_(biomeRegistry.m_7981_((Object)((Biome)biomeSource.m_203407_(x >> 2, 40, z >> 2, sampler).m_203334_()))).orElse(new BzBiomeHeightRegistry.BiomeTerrain(4.0f, 1.0f));
        float totalHeight = 0.0f;
        for (int xOffset = -2; xOffset <= 2; ++xOffset) {
            for (int zOffset = -2; zOffset <= 2; ++zOffset) {
                BzBiomeHeightRegistry.BiomeTerrain biomeTerrain = BzBiomeHeightRegistry.BIOME_HEIGHT_REGISTRY.m_6612_(biomeRegistry.m_7981_((Object)((Biome)biomeSource.m_203407_((x >> 2) + xOffset, 40, (z >> 2) + zOffset, sampler).m_203334_()))).orElse(new BzBiomeHeightRegistry.BiomeTerrain(4.0f, 1.0f));
                float biomeDepth = biomeTerrain.depth;
                float weight = BIOME_WEIGHT_TABLE[xOffset + 2 + (zOffset + 2) * 5];
                if (biomeDepth != centerBiomeInfo.depth) {
                    biomeDepth = Mth.m_14179_((float)centerBiomeInfo.weightModifier, (float)biomeDepth, (float)centerBiomeInfo.depth);
                }
                totalHeight += biomeDepth * weight;
            }
        }
        float finalInfluence = Math.min(totalHeight / 123.0f, 0.4585f);
        if (CACHED_INFLUENCE_RESULT.size() > 2000) {
            CACHED_INFLUENCE_RESULT.clear();
        }
        CACHED_INFLUENCE_RESULT.put(longPos, Float.valueOf(finalInfluence));
        return finalInfluence;
    }
}

