/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Doubles;
import com.mojang.datafixers.util.Pair;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class GeneralUtils {
    private static int ACTIVE_ENTITIES = 0;
    private static final Set<Bee> BEE_SET = new HashSet<Bee>();
    public static final List<BlockState> VANILLA_CANDLES = ImmutableList.of((Object)Blocks.f_152482_.m_49966_(), (Object)Blocks.f_152518_.m_49966_(), (Object)Blocks.f_152524_.m_49966_(), (Object)Blocks.f_152520_.m_49966_(), (Object)Blocks.f_152521_.m_49966_(), (Object)Blocks.f_152516_.m_49966_(), (Object)Blocks.f_152522_.m_49966_(), (Object)Blocks.f_152512_.m_49966_(), (Object)Blocks.f_152517_.m_49966_(), (Object)Blocks.f_152514_.m_49966_(), (Object)Blocks.f_152511_.m_49966_(), (Object)Blocks.f_152484_.m_49966_(), (Object[])new BlockState[]{Blocks.f_152515_.m_49966_(), Blocks.f_152519_.m_49966_(), Blocks.f_152523_.m_49966_(), Blocks.f_152483_.m_49966_(), Blocks.f_152513_.m_49966_()});

    public static void updateEntityCount(ServerLevel world) {
        BEE_SET.clear();
        int counter = 0;
        for (Entity entity : world.m_8583_()) {
            ++counter;
            if (!(entity instanceof Bee)) continue;
            BEE_SET.add((Bee)entity);
        }
        ACTIVE_ENTITIES = counter;
        BEE_SET.removeIf(bee -> bee.m_21532_() || bee.m_27854_() || bee.m_8077_() || bee.m_21523_() || bee.m_20160_());
    }

    public static int getEntityCountInBz() {
        return ACTIVE_ENTITIES;
    }

    public static void adjustEntityCountInBz(int adjust) {
        ACTIVE_ENTITIES += adjust;
    }

    public static Set<Bee> getAllWildBees() {
        return BEE_SET;
    }

    public static <T> T getRandomEntry(List<Pair<T, Integer>> rlList, Random random) {
        int index;
        double totalWeight = 0.0;
        for (Pair<T, Integer> pair : rlList) {
            totalWeight += (double)((Integer)pair.getSecond()).intValue();
        }
        double randomWeightPicked = (double)random.nextFloat() * totalWeight;
        for (index = 0; index < rlList.size() - 1 && !((randomWeightPicked -= (double)((Integer)rlList.get(index).getSecond()).intValue()) <= 0.0); ++index) {
        }
        return (T)rlList.get(index).getFirst();
    }

    public static BlockPos getRandomBlockposWithinRange(Level world, Entity entity, int maxRadius, int minRadius) {
        BlockPos newBeePos = new BlockPos(entity.m_20185_() + (double)((world.f_46441_.nextInt(maxRadius) + minRadius) * (world.f_46441_.nextBoolean() ? 1 : -1)), Doubles.constrainToRange((double)(entity.m_20186_() + (double)((world.f_46441_.nextInt(maxRadius) + minRadius) * (world.f_46441_.nextBoolean() ? 1 : -1))), (double)1.0, (double)254.0), entity.m_20189_() + (double)((world.f_46441_.nextInt(maxRadius) + minRadius) * (world.f_46441_.nextBoolean() ? 1 : -1)));
        return newBeePos;
    }

    public static void givePlayerItem(Player playerEntity, InteractionHand hand, ItemStack itemstackToGive, boolean giveContainerItem, boolean shrinkCurrentItem) {
        ItemStack playerItem = playerEntity.m_21120_(hand);
        ItemStack copiedPlayerItem = playerItem.m_41777_();
        if (shrinkCurrentItem) {
            playerItem.m_41774_(1);
        }
        if (!itemstackToGive.m_41619_()) {
            if (playerItem.m_41619_()) {
                playerEntity.m_21008_(hand, itemstackToGive);
            } else if (!playerEntity.m_150109_().m_36054_(itemstackToGive)) {
                playerEntity.m_36176_(itemstackToGive, false);
            }
        }
        if (giveContainerItem && copiedPlayerItem.hasContainerItem()) {
            ItemStack containerItem = copiedPlayerItem.getContainerItem();
            if (playerEntity.m_21120_(hand).m_41619_()) {
                playerEntity.m_21008_(hand, containerItem);
            } else if (!playerEntity.m_150109_().m_36054_(containerItem)) {
                playerEntity.m_36176_(containerItem, false);
            }
        }
    }

    public static class BasicItemTrade
    implements VillagerTrades.ItemListing {
        private final Item itemToTrade;
        private final Item itemToReceive;
        private final int amountToGive;
        private final int amountToReceive;
        protected final int maxUses;
        protected final int experience;
        protected final float multiplier;

        public BasicItemTrade(Item itemToTrade, Item itemToReceive, int amountToGive, int amountToReceive) {
            this(itemToReceive, itemToTrade, amountToGive, amountToReceive, 20, 2, 0.05f);
        }

        public BasicItemTrade(Item itemToTrade, Item itemToReceive, int amountToGive, int amountToReceive, int maxUses, int experience, float multiplier) {
            this.itemToTrade = itemToTrade;
            this.itemToReceive = itemToReceive;
            this.amountToGive = amountToGive;
            this.amountToReceive = amountToReceive;
            this.maxUses = maxUses;
            this.experience = experience;
            this.multiplier = multiplier;
        }

        public MerchantOffer m_5670_(Entity entity, Random random) {
            ItemStack in = new ItemStack((ItemLike)this.itemToTrade, this.amountToGive);
            ItemStack out = new ItemStack((ItemLike)this.itemToReceive, this.amountToReceive);
            return new MerchantOffer(in, out, this.maxUses, this.experience, this.multiplier);
        }
    }

    public static final class Lazy<T> {
        private volatile T value;

        public T getOrCompute(Supplier<T> supplier) {
            T result = this.value;
            return result == null ? this.maybeCompute(supplier) : result;
        }

        private synchronized T maybeCompute(Supplier<T> supplier) {
            if (this.value == null) {
                this.value = Objects.requireNonNull(supplier.get());
            }
            return this.value;
        }
    }
}

