/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.packets;

import com.telepathicgrunt.the_bumblezone.items.BumbleBeeChestplate;
import com.telepathicgrunt.the_bumblezone.packets.MessageHandler;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public record BumbleBeeChestplateFlyingPacket(byte isFlying) {
    public static void sendToServer(boolean isFlying) {
        MessageHandler.DEFAULT_CHANNEL.send(PacketDistributor.SERVER.with(() -> null), (Object)new BumbleBeeChestplateFlyingPacket((byte)(isFlying ? 1 : 0)));
    }

    public static BumbleBeeChestplateFlyingPacket parse(FriendlyByteBuf buf) {
        return new BumbleBeeChestplateFlyingPacket(buf.readByte());
    }

    public static void compose(BumbleBeeChestplateFlyingPacket pkt, FriendlyByteBuf buf) {
        buf.writeByte((int)pkt.isFlying);
    }

    public static class Handler {
        public static void handle(BumbleBeeChestplateFlyingPacket pkt, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer serverPlayer = ((NetworkEvent.Context)ctx.get()).getSender();
                if (serverPlayer == null) {
                    return;
                }
                ItemStack itemStack = BumbleBeeChestplate.getEntityBeeChestplate((Entity)serverPlayer);
                if (!itemStack.m_41619_()) {
                    CompoundTag tag = itemStack.m_41784_();
                    tag.m_128379_("isFlying", pkt.isFlying() != 0);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

