/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat;

import com.telepathicgrunt.the_bumblezone.configs.BzModCompatibilityConfigs;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modinit.BzFeatures;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import cy.jdkdigital.productivebees.common.block.AdvancedBeehive;
import cy.jdkdigital.productivebees.common.block.AdvancedBeehiveAbstract;
import cy.jdkdigital.productivebees.common.block.ConfigurableCombBlock;
import cy.jdkdigital.productivebees.common.block.ExpansionBox;
import cy.jdkdigital.productivebees.common.block.entity.CombBlockBlockEntity;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBee;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModEntities;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import cy.jdkdigital.productivebees.state.properties.VerticalHive;
import java.awt.Color;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;

public class ProductiveBeesCompat {
    private static final Lazy<List<String>> SPIDER_DUNGEON_HONEYCOMBS = Lazy.of(() -> BeeReloadListener.INSTANCE.getData().entrySet().stream().filter(e -> {
        CompoundTag tag = (CompoundTag)e.getValue();
        int primary = tag.m_128451_("primaryColor");
        return ((List)BzModCompatibilityConfigs.allowedCombsForDungeons.get()).contains(e.getKey()) && tag.m_128471_("createComb") && (ProductiveBeesCompat.colorsAreClose(new Color(106, 127, 0), new Color(primary), 150) || ProductiveBeesCompat.colorsAreClose(new Color(129, 198, 0), new Color(primary), 150) || ProductiveBeesCompat.colorsAreClose(new Color(34, 45, 0), new Color(primary), 150));
    }).map(Map.Entry::getKey).toList());
    private static final Lazy<List<String>> BEE_DUNGEON_HONEYCOMBS = Lazy.of(() -> BeeReloadListener.INSTANCE.getData().entrySet().stream().filter(e -> {
        CompoundTag tag = (CompoundTag)e.getValue();
        return ((List)BzModCompatibilityConfigs.allowedCombsForDungeons.get()).contains(e.getKey()) && tag.m_128471_("createComb") && !((List)SPIDER_DUNGEON_HONEYCOMBS.get()).contains(e.getKey());
    }).map(Map.Entry::getKey).toList());
    private static final Lazy<List<String>> ORE_HONEYCOMBS = Lazy.of(() -> BeeReloadListener.INSTANCE.getData().entrySet().stream().filter(e -> ((List)BzModCompatibilityConfigs.allowedCombsAsOres.get()).contains(e.getKey()) && ((CompoundTag)e.getValue()).m_128471_("createComb")).map(Map.Entry::getKey).toList());
    private static final Lazy<List<String>> ALL_BEES = Lazy.of(() -> BeeReloadListener.INSTANCE.getData().keySet().stream().filter(e -> ((List)BzModCompatibilityConfigs.allowedBees.get()).contains(e)).toList());
    private static final ResourceLocation FEATURE_RL = new ResourceLocation("the_bumblezone", "productivebees_be_comb_feature");
    public static final TagKey<Block> SOLITARY_OVERWORLD_NESTS_TAG = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation("productivebees", "solitary_overworld_nests"));

    public static void setupProductiveBees() {
        Registry.m_122965_((Registry)BuiltinRegistries.f_123861_, (ResourceLocation)FEATURE_RL, (Object)new ConfiguredFeature((Feature)BzFeatures.BLOCKENTITY_COMBS_FEATURE.get(), (FeatureConfiguration)new OreConfiguration((RuleTest)new TagMatchTest(BzTags.HONEYCOMBS_THAT_FEATURES_CAN_CARVE), ((Block)ModBlocks.CONFIGURABLE_COMB.get()).m_49966_(), 16)));
        Registry.m_122965_((Registry)BuiltinRegistries.f_194653_, (ResourceLocation)new ResourceLocation("the_bumblezone", "productivebees_be_comb_feature"), (Object)new PlacedFeature(BuiltinRegistries.f_123861_.m_206081_(ResourceKey.m_135785_((ResourceKey)Registry.f_122881_, (ResourceLocation)FEATURE_RL)), List.of(RarityFilter.m_191900_((int)2), InSquarePlacement.m_191715_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158930_((int)10), (VerticalAnchor)VerticalAnchor.m_158935_((int)10)), BiomeFilter.m_191561_())));
        if (((Boolean)BzModCompatibilityConfigs.spawnProductiveBeesHoneycombVariants.get()).booleanValue()) {
            MinecraftForge.EVENT_BUS.addListener(ProductiveBeesCompat::PBAddWorldgen);
        }
        ModChecker.productiveBeesPresent = true;
    }

    private static boolean colorsAreClose(Color a, Color z, int threshold) {
        int b;
        int g;
        int r = a.getRed() - z.getRed();
        return r * r + (g = a.getGreen() - z.getGreen()) * g + (b = a.getBlue() - z.getBlue()) * b <= threshold * threshold;
    }

    public static void PBAddWorldgen(BiomeLoadingEvent event) {
        if (ModChecker.productiveBeesPresent && event.getName().m_135827_().equals("the_bumblezone")) {
            event.getGeneration().m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, BuiltinRegistries.f_194653_.m_206081_(ResourceKey.m_135785_((ResourceKey)Registry.f_194567_, (ResourceLocation)FEATURE_RL)));
        }
    }

    public static boolean PBIsExpandedBeehiveBlock(BlockState block) {
        if (block.m_60734_() instanceof ExpansionBox && block.m_61143_((Property)AdvancedBeehive.EXPANDED) != VerticalHive.NONE) {
            return true;
        }
        if (block.m_204336_(SOLITARY_OVERWORLD_NESTS_TAG)) {
            return true;
        }
        return block.m_60734_() instanceof AdvancedBeehiveAbstract;
    }

    public static boolean PBMobSpawnEvent(LivingSpawnEvent.CheckSpawn event, boolean isChild) {
        if (((List)ALL_BEES.get()).size() == 0) {
            return false;
        }
        Mob entity = (Mob)event.getEntity();
        LevelAccessor world = event.getWorld();
        ConfigurableBee productiveBeeEntity = (ConfigurableBee)((EntityType)ModEntities.CONFIGURABLE_BEE.get()).m_20615_(entity.f_19853_);
        if (productiveBeeEntity == null) {
            return false;
        }
        BlockPos.MutableBlockPos blockpos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)entity.m_142538_());
        productiveBeeEntity.m_7678_((double)((float)blockpos.m_123341_() + 0.5f), (double)((float)blockpos.m_123342_() + 0.5f), (double)((float)blockpos.m_123343_() + 0.5f), world.m_5822_().nextFloat() * 360.0f, 0.0f);
        productiveBeeEntity.m_6863_(isChild);
        CompoundTag newTag = new CompoundTag();
        newTag.m_128359_("type", (String)((List)ALL_BEES.get()).get(world.m_5822_().nextInt(((List)ALL_BEES.get()).size())));
        productiveBeeEntity.m_6518_((ServerLevelAccessor)world, world.m_6436_(productiveBeeEntity.m_142538_()), event.getSpawnReason(), null, newTag);
        productiveBeeEntity.setBeeType(newTag.m_128461_("type"));
        world.m_7967_((Entity)productiveBeeEntity);
        return true;
    }

    public static boolean PBIsConfigurableComb(Block block) {
        return block instanceof ConfigurableCombBlock;
    }

    public static void placeConfigurableCombBlockEntity(BlockPos.MutableBlockPos blockposMutable, ChunkAccess cachedChunk, String nbt, OreConfiguration.TargetBlockState targetBlockState, Block combBlock) {
        if (nbt != null) {
            cachedChunk.m_6978_((BlockPos)blockposMutable, targetBlockState.f_161033_, false);
            CombBlockBlockEntity be = (CombBlockBlockEntity)((ConfigurableCombBlock)combBlock).m_142194_((BlockPos)blockposMutable, targetBlockState.f_161033_);
            be.setType(nbt);
            cachedChunk.m_142169_((BlockEntity)be);
        }
    }

    public static String PBGetRandomCombType(Random random) {
        if (!((Boolean)BzModCompatibilityConfigs.spawnProductiveBeesHoneycombVariants.get()).booleanValue() || ((List)ORE_HONEYCOMBS.get()).size() == 0) {
            return null;
        }
        return (String)((List)ORE_HONEYCOMBS.get()).get(random.nextInt(((List)ORE_HONEYCOMBS.get()).size()));
    }

    public static StructureTemplate.StructureBlockInfo PBGetRottenedHoneycomb(BlockPos worldPos, Random random) {
        if (!((Boolean)BzModCompatibilityConfigs.spawnProductiveBeesHoneycombVariants.get()).booleanValue() || ((List)SPIDER_DUNGEON_HONEYCOMBS.get()).size() == 0) {
            return null;
        }
        CompoundTag newTag = new CompoundTag();
        newTag.m_128359_("type", (String)((List)SPIDER_DUNGEON_HONEYCOMBS.get()).get(random.nextInt(((List)SPIDER_DUNGEON_HONEYCOMBS.get()).size())));
        return new StructureTemplate.StructureBlockInfo(worldPos, ((Block)ModBlocks.CONFIGURABLE_COMB.get()).m_49966_(), newTag);
    }

    public static StructureTemplate.StructureBlockInfo PBGetRandomHoneycomb(BlockPos worldPos, Random random) {
        if (!((Boolean)BzModCompatibilityConfigs.spawnProductiveBeesHoneycombVariants.get()).booleanValue() || ((List)BEE_DUNGEON_HONEYCOMBS.get()).size() == 0) {
            return null;
        }
        CompoundTag newTag = new CompoundTag();
        newTag.m_128359_("type", (String)((List)BEE_DUNGEON_HONEYCOMBS.get()).get(random.nextInt(((List)BEE_DUNGEON_HONEYCOMBS.get()).size())));
        return new StructureTemplate.StructureBlockInfo(worldPos, ((Block)ModBlocks.CONFIGURABLE_COMB.get()).m_49966_(), newTag);
    }
}

