/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat;

import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.modcompat.FriendsAndFoesCompat;
import com.telepathicgrunt.the_bumblezone.modcompat.ProductiveBeesCompat;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.logging.log4j.Level;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;

public class ModChecker {
    public static boolean productiveBeesPresent = false;
    public static boolean pokecubePresent = false;
    public static boolean friendsAndFoesPresent = false;

    public static void setupModCompat() {
        String modid = "";
        try {
            modid = "productivebees";
            ModChecker.loadupModCompat(modid, () -> ProductiveBeesCompat.setupProductiveBees());
            modid = "friendsandfoes";
            ModChecker.loadupModCompat(modid, () -> FriendsAndFoesCompat.setupCompat());
        }
        catch (Throwable e) {
            ModChecker.printErrorToLogs("classloading " + modid + " and so, mod compat done afterwards broke");
            e.printStackTrace();
        }
    }

    private static void loadupModCompat(String modid, Runnable runnable) {
        try {
            if (ModList.get().isLoaded(modid)) {
                runnable.run();
            }
        }
        catch (Throwable e) {
            ModChecker.printErrorToLogs(modid);
            e.printStackTrace();
        }
    }

    private static void printErrorToLogs(String currentModID) {
        Bumblezone.LOGGER.log(Level.ERROR, "  ------------------------------------------------NOTICE-------------------------------------------------------------------------\n\n  ERROR: Something broke when trying to add mod compatibility with %s. Please let The Bumblezone developer (TelepathicGrunt) know about this!\n\n  ------------------------------------------------NOTICE-------------------------------------------------------------------------\n".formatted(currentModID));
    }

    private static boolean isNotOutdated(String currentModID, String minVersion, boolean checkQualifierInstead) {
        if (!ModList.get().isLoaded(currentModID)) {
            return true;
        }
        IModInfo modInfo = ((ModContainer)ModList.get().getModContainerById(currentModID).get()).getModInfo();
        ArtifactVersion modVersion = modInfo.getVersion();
        if (checkQualifierInstead && modVersion.getQualifier() != null) {
            modVersion = new DefaultArtifactVersion(modVersion.getQualifier());
        }
        if (modVersion.compareTo((Object)new DefaultArtifactVersion(minVersion)) < 0) {
            Bumblezone.LOGGER.log(Level.INFO, "------------------------------------------------NOTICE-------------------------------------------------------------------------");
            Bumblezone.LOGGER.log(Level.INFO, " ");
            Bumblezone.LOGGER.log(Level.INFO, "BUMBLEZONE: You're using a version of " + modInfo.getDisplayName() + " that is outdated. Please update " + modInfo.getDisplayName() + " to the latest version of that mod to enable compat with Bumblezone again.");
            Bumblezone.LOGGER.log(Level.INFO, " ");
            Bumblezone.LOGGER.log(Level.INFO, "------------------------------------------------NOTICE-------------------------------------------------------------------------");
            return false;
        }
        return true;
    }
}

