/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items;

import com.mojang.serialization.DynamicOps;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import org.apache.logging.log4j.Logger;

public class HoneyCompass
extends Item
implements Vanishable {
    public static final String TAG_TARGET_POS = "TargetPos";
    public static final String TAG_TARGET_DIMENSION = "TargetDimension";
    public static final String TAG_TYPE = "CompassType";
    public static final String TARGET_BLOCK = "TargetBlock";

    public HoneyCompass(Item.Properties properties) {
        super(properties);
    }

    public boolean m_5812_(ItemStack itemStack) {
        return this.isStructureCompass(itemStack) || super.m_5812_(itemStack);
    }

    public String m_5671_(ItemStack itemStack) {
        if (this.isStructureCompass(itemStack)) {
            return "item.the_bumblezone.honey_compass_structure";
        }
        if (this.isBlockCompass(itemStack)) {
            return "item.the_bumblezone.honey_compass_block";
        }
        return super.m_5671_(itemStack);
    }

    public void m_6883_(ItemStack itemStack, Level level, Entity entity, int i, boolean bl) {
        if (!level.f_46443_ && this.isBlockCompass(itemStack)) {
            CompoundTag compoundTag = itemStack.m_41784_();
            if (compoundTag.m_128441_(TAG_TARGET_POS) && compoundTag.m_128441_(TARGET_BLOCK) && compoundTag.m_128441_(TAG_TARGET_DIMENSION)) {
                Optional optional = Level.f_46427_.parse((DynamicOps)NbtOps.f_128958_, (Object)compoundTag.m_128423_(TAG_TARGET_DIMENSION)).result();
                if (optional.isPresent() && ((ResourceKey)optional.get()).equals((Object)level.m_46472_())) {
                    BlockPos blockPos = NbtUtils.m_129239_((CompoundTag)compoundTag.m_128469_(TAG_TARGET_POS));
                    if (!level.m_46739_(blockPos)) {
                        compoundTag.m_128473_(TAG_TARGET_POS);
                        compoundTag.m_128473_(TAG_TARGET_DIMENSION);
                        compoundTag.m_128473_(TARGET_BLOCK);
                        compoundTag.m_128473_(TAG_TYPE);
                        return;
                    }
                    ChunkAccess chunk = level.m_6522_(blockPos.m_123341_() >> 4, blockPos.m_123343_() >> 4, ChunkStatus.f_62326_, false);
                    if (chunk != null && !Registry.f_122824_.m_7981_((Object)chunk.m_8055_(blockPos).m_60734_()).toString().equals(compoundTag.m_128461_(TARGET_BLOCK))) {
                        compoundTag.m_128473_(TAG_TARGET_POS);
                        compoundTag.m_128473_(TAG_TARGET_DIMENSION);
                        compoundTag.m_128473_(TARGET_BLOCK);
                        compoundTag.m_128473_(TAG_TYPE);
                    }
                }
            } else {
                compoundTag.m_128473_(TAG_TARGET_POS);
                compoundTag.m_128473_(TAG_TARGET_DIMENSION);
                compoundTag.m_128473_(TARGET_BLOCK);
                compoundTag.m_128473_(TAG_TYPE);
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.m_21120_(interactionHand);
        BlockPos playerPos = player.m_142538_();
        if (!level.m_5776_() && !this.isStructureCompass(itemStack)) {
            boolean singleCompass;
            BlockPos structurePos = ((ServerLevel)level).m_207561_(BzTags.HONEY_COMPASS_LOCATING, playerPos, 100, false);
            if (structurePos == null) {
                return super.m_7203_(level, player, interactionHand);
            }
            level.m_5594_(null, playerPos, (SoundEvent)BzSounds.HONEY_COMPASS_STRUCTURE_LOCK.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                BzCriterias.HONEY_COMPASS_USE_TRIGGER.trigger(serverPlayer);
            }
            boolean bl = singleCompass = !player.m_150110_().f_35937_ && itemStack.m_41613_() == 1;
            if (singleCompass) {
                this.addStructureTags((ResourceKey<Level>)level.m_46472_(), structurePos, itemStack.m_41784_());
            } else {
                ItemStack newCompass = new ItemStack((ItemLike)BzItems.HONEY_COMPASS.get(), 1);
                CompoundTag newCompoundTag = itemStack.m_41782_() ? itemStack.m_41783_().m_6426_() : new CompoundTag();
                newCompass.m_41751_(newCompoundTag);
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41774_(1);
                }
                this.addStructureTags((ResourceKey<Level>)level.m_46472_(), structurePos, newCompoundTag);
                if (!player.m_150109_().m_36054_(newCompass)) {
                    player.m_36176_(newCompass, false);
                }
            }
            return InteractionResultHolder.m_19090_((Object)itemStack);
        }
        return super.m_7203_(level, player, interactionHand);
    }

    public InteractionResult m_6225_(UseOnContext useOnContext) {
        BlockPos blockPos = useOnContext.m_8083_();
        Level level = useOnContext.m_43725_();
        Player player = useOnContext.m_43723_();
        ItemStack handCompass = useOnContext.m_43722_();
        BlockState targetBlock = level.m_8055_(blockPos);
        if (player != null && HoneyCompass.isValidBeeHive(targetBlock)) {
            boolean singleCompass;
            level.m_5594_(null, blockPos, (SoundEvent)BzSounds.HONEY_COMPASS_BLOCK_LOCK.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                BzCriterias.HONEY_COMPASS_USE_TRIGGER.trigger(serverPlayer);
            }
            boolean bl = singleCompass = !player.m_150110_().f_35937_ && handCompass.m_41613_() == 1;
            if (singleCompass) {
                this.addBlockTags((ResourceKey<Level>)level.m_46472_(), blockPos, handCompass.m_41784_(), targetBlock.m_60734_());
            } else {
                ItemStack newCompass = new ItemStack((ItemLike)BzItems.HONEY_COMPASS.get(), 1);
                CompoundTag newCompoundTag = handCompass.m_41782_() ? handCompass.m_41783_().m_6426_() : new CompoundTag();
                newCompass.m_41751_(newCompoundTag);
                if (!player.m_150110_().f_35937_) {
                    handCompass.m_41774_(1);
                }
                this.addBlockTags((ResourceKey<Level>)level.m_46472_(), blockPos, newCompoundTag, targetBlock.m_60734_());
                if (!player.m_150109_().m_36054_(newCompass)) {
                    player.m_36176_(newCompass, false);
                }
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6225_(useOnContext);
    }

    public static boolean isValidBeeHive(BlockState block) {
        if (block.m_204336_(BzTags.BLACKLISTED_HONEY_COMPASS_BLOCKS)) {
            return false;
        }
        return block.m_204336_(BlockTags.f_13072_) || block.m_60734_() instanceof BeehiveBlock;
    }

    private void addStructureTags(ResourceKey<Level> resourceKey, BlockPos blockPos, CompoundTag compoundTag) {
        compoundTag.m_128365_(TAG_TARGET_POS, (Tag)NbtUtils.m_129224_((BlockPos)blockPos));
        Level.f_46427_.encodeStart((DynamicOps)NbtOps.f_128958_, resourceKey).resultOrPartial(arg_0 -> ((Logger)Bumblezone.LOGGER).error(arg_0)).ifPresent(tag -> compoundTag.m_128365_(TAG_TARGET_DIMENSION, tag));
        compoundTag.m_128359_(TAG_TYPE, "structure");
        compoundTag.m_128473_(TARGET_BLOCK);
    }

    private void addBlockTags(ResourceKey<Level> resourceKey, BlockPos blockPos, CompoundTag compoundTag, Block block) {
        compoundTag.m_128365_(TAG_TARGET_POS, (Tag)NbtUtils.m_129224_((BlockPos)blockPos));
        Level.f_46427_.encodeStart((DynamicOps)NbtOps.f_128958_, resourceKey).resultOrPartial(arg_0 -> ((Logger)Bumblezone.LOGGER).error(arg_0)).ifPresent(tag -> compoundTag.m_128365_(TAG_TARGET_DIMENSION, tag));
        compoundTag.m_128359_(TAG_TYPE, "block");
        compoundTag.m_128359_(TARGET_BLOCK, Registry.f_122824_.m_7981_((Object)block).toString());
    }

    private boolean isBlockCompass(ItemStack compassItem) {
        if (compassItem.m_41782_()) {
            CompoundTag tag = compassItem.m_41783_();
            return tag != null && tag.m_128441_(TAG_TYPE) && tag.m_128461_(TAG_TYPE).equals("block");
        }
        return false;
    }

    private boolean isStructureCompass(ItemStack compassItem) {
        if (compassItem.m_41782_()) {
            CompoundTag tag = compassItem.m_41783_();
            return tag != null && tag.m_128441_(TAG_TYPE) && tag.m_128461_(TAG_TYPE).equals("structure");
        }
        return false;
    }
}

