/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items;

import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BeeCannon
extends Item
implements Vanishable {
    public static final String TAG_BEES = "BeesStored";

    public BeeCannon(Item.Properties properties) {
        super(properties.m_41503_(50));
    }

    public void m_5551_(ItemStack beeCannon, Level level, LivingEntity livingEntity, int currentDuration) {
        if (!level.m_5776_() && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            ItemStack mutableBeeCannon = player.m_21120_(InteractionHand.MAIN_HAND);
            int numberOfBees = BeeCannon.getNumberOfBees(mutableBeeCannon);
            int remainingDuration = this.m_8105_(mutableBeeCannon) - currentDuration;
            if (remainingDuration >= 10 && numberOfBees > 0) {
                List<Entity> bees = BeeCannon.tryReleaseBees(level, mutableBeeCannon);
                bees.forEach(bee -> {
                    Vec3 playerEyePos = new Vec3(player.m_20185_(), player.m_20188_() - 0.25, player.m_20189_());
                    bee.m_7678_(playerEyePos.m_7096_(), playerEyePos.m_7098_(), playerEyePos.m_7094_(), player.m_146908_(), player.m_146909_());
                    bee.m_20256_(player.m_20154_().m_82542_(2.5, 2.5, 2.5));
                    level.m_7967_(bee);
                    if (bee instanceof NeutralMob) {
                        LivingEntity targetEntity;
                        Entity patt4383$temp;
                        EntityHitResult entityHitResult;
                        float maxDistance = 15.0f;
                        Vec3 maxDistanceDirection = player.m_20154_().m_82542_((double)maxDistance, (double)maxDistance, (double)maxDistance);
                        Vec3 finalPos = playerEyePos.m_82549_(maxDistanceDirection);
                        BlockHitResult hitResult = level.m_45547_(new ClipContext(playerEyePos, finalPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
                        if (hitResult.m_6662_() != HitResult.Type.MISS) {
                            finalPos = hitResult.m_82450_();
                        }
                        if ((entityHitResult = ProjectileUtil.m_150175_((Level)level, (Entity)player, (Vec3)playerEyePos, (Vec3)finalPos, (AABB)player.m_142469_().m_82369_(maxDistanceDirection), entity -> !entity.m_20177_(player), (float)1.0f)) != null && entityHitResult.m_6662_() != HitResult.Type.MISS && (patt4383$temp = entityHitResult.m_82443_()) instanceof LivingEntity && !((targetEntity = (LivingEntity)patt4383$temp) instanceof Bee)) {
                            ((NeutralMob)bee).m_7870_(60);
                            ((NeutralMob)bee).m_6925_(targetEntity.m_142081_());
                            if (bee instanceof Bee) {
                                Bee trueBee = (Bee)bee;
                                trueBee.m_6710_(targetEntity);
                            }
                        }
                    }
                    level.m_5594_(null, player.m_142538_(), (SoundEvent)BzSounds.BEE_CANNON_FIRES.get(), SoundSource.PLAYERS, 1.0f, level.m_5822_().nextFloat() * 0.2f + 0.6f);
                    mutableBeeCannon.m_41622_(1, (LivingEntity)player, playerEntity -> playerEntity.m_21166_(EquipmentSlot.MAINHAND));
                    if (numberOfBees >= 3 && player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        BzCriterias.BEE_CANNON_FULL_TRIGGER.trigger(serverPlayer);
                    }
                });
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack beeCannon = player.m_21120_(interactionHand);
        if (BeeCannon.getNumberOfBees(beeCannon) == 0) {
            return InteractionResultHolder.m_19100_((Object)beeCannon);
        }
        player.m_6672_(interactionHand);
        return InteractionResultHolder.m_19096_((Object)beeCannon);
    }

    public InteractionResult m_6880_(ItemStack beeCannon, Player playerEntity, LivingEntity entity, InteractionHand playerHand) {
        Bee bee;
        if (playerEntity.f_19853_.m_5776_() || !(entity instanceof Bee) || (bee = (Bee)entity).m_21660_() || bee.m_6095_().m_204039_(BzTags.BLACKLISTED_BEE_CANNON_BEES)) {
            return InteractionResult.PASS;
        }
        ItemStack mutableBeeCannon = playerEntity.m_21120_(playerHand);
        boolean addedBee = BeeCannon.tryAddBee(mutableBeeCannon, (Entity)entity);
        if (addedBee) {
            playerEntity.m_21011_(playerHand, true);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static List<Entity> tryReleaseBees(Level level, ItemStack beeCannonItem) {
        if (BeeCannon.getNumberOfBees(beeCannonItem) > 0) {
            CompoundTag tag = beeCannonItem.m_41784_();
            ListTag beeList = tag.m_128437_(TAG_BEES, 10);
            ObjectArrayList releasedBees = new ObjectArrayList();
            for (int i = beeList.size() - 1; i >= 0; --i) {
                CompoundTag beeTag = beeList.m_128728_(0);
                beeList.remove(0);
                releasedBees.add(EntityType.m_20645_((CompoundTag)beeTag, (Level)level, entityx -> entityx));
            }
            return releasedBees;
        }
        return new ObjectArrayList();
    }

    public static boolean tryAddBee(ItemStack beeCannonItem, Entity bee) {
        if (BeeCannon.getNumberOfBees(beeCannonItem) < 3) {
            CompoundTag cannonTag = beeCannonItem.m_41784_();
            ListTag beeList = cannonTag.m_128437_(TAG_BEES, 10);
            CompoundTag beeTag = new CompoundTag();
            bee.m_20223_(beeTag);
            bee.m_8127_();
            bee.m_20153_();
            beeTag.m_128473_("UUID");
            beeList.add((Object)beeTag);
            bee.m_146870_();
            return true;
        }
        return false;
    }

    public static int getNumberOfBees(ItemStack beeCannonItem) {
        if (beeCannonItem.m_41782_()) {
            CompoundTag tag = beeCannonItem.m_41783_();
            if (tag.m_128441_(TAG_BEES)) {
                ListTag beeList = tag.m_128437_(TAG_BEES, 10);
                return beeList.size();
            }
            ListTag listTag = new ListTag();
            tag.m_128365_(TAG_BEES, (Tag)listTag);
        }
        return 0;
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return repair.m_204117_(BzTags.BEE_CANNON_REPAIR_ITEMS);
    }

    public int m_6473_() {
        return 1;
    }

    public int m_8105_(ItemStack itemStack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack itemStack) {
        return UseAnim.BOW;
    }
}

