/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.nonliving;

import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzEnchantments;
import com.telepathicgrunt.the_bumblezone.modinit.BzEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import javax.annotation.Nullable;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class ThrownStingerSpearEntity
extends AbstractArrow {
    private static final EntityDataAccessor<Byte> ID_LOYALTY = SynchedEntityData.m_135353_(ThrownStingerSpearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> ID_FOIL = SynchedEntityData.m_135353_(ThrownStingerSpearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private ItemStack spearItem = new ItemStack((ItemLike)BzItems.STINGER_SPEAR.get());
    private boolean dealtDamage;
    public int clientSideReturnSpearTickCount;

    public ThrownStingerSpearEntity(EntityType<? extends ThrownStingerSpearEntity> entityType, Level level) {
        super(entityType, level);
    }

    public ThrownStingerSpearEntity(Level level, LivingEntity livingEntity, ItemStack itemStack) {
        super((EntityType)BzEntities.THROWN_STINGER_SPEAR_ENTITY.get(), livingEntity, level);
        this.spearItem = itemStack.m_41777_();
        this.f_19804_.m_135381_(ID_LOYALTY, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)itemStack)));
        this.f_19804_.m_135381_(ID_FOIL, (Object)itemStack.m_41790_());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_LOYALTY, (Object)0);
        this.f_19804_.m_135372_(ID_FOIL, (Object)false);
    }

    public ItemStack getSpearItemStack() {
        return this.spearItem;
    }

    public void m_8119_() {
        if (this.f_36704_ > 4) {
            this.dealtDamage = true;
        }
        Entity entity = this.m_37282_();
        byte loyalty = (Byte)this.f_19804_.m_135370_(ID_LOYALTY);
        if (loyalty > 0 && (this.dealtDamage || this.m_36797_()) && entity != null) {
            if (!this.isAcceptibleReturnOwner()) {
                if (!this.f_19853_.f_46443_ && this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                    this.m_5552_(this.m_7941_(), 0.1f);
                }
                this.m_146870_();
            } else {
                this.m_36790_(true);
                Vec3 vec3 = entity.m_146892_().m_82546_(this.m_20182_());
                this.m_20343_(this.m_20185_(), this.m_20186_() + vec3.f_82480_ * 0.015 * (double)loyalty, this.m_20189_());
                if (this.f_19853_.f_46443_) {
                    this.f_19791_ = this.m_20186_();
                }
                double returnSpeed = 0.05 * (double)loyalty;
                this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_(vec3.m_82541_().m_82490_(returnSpeed)));
                if (this.clientSideReturnSpearTickCount == 0) {
                    this.m_5496_((SoundEvent)BzSounds.STINGER_SPEAR_RETURN.get(), 10.0f, 1.0f);
                }
                ++this.clientSideReturnSpearTickCount;
            }
        }
        super.m_8119_();
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        ServerPlayer serverPlayer;
        Entity entity;
        LivingEntity livingEntity;
        Entity owner;
        Entity entity2 = entityHitResult.m_82443_();
        float damageAmount = 1.5f;
        if (entity2 instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity2;
            damageAmount += EnchantmentHelper.m_44833_((ItemStack)this.spearItem, (MobType)livingentity.m_6336_());
        }
        DamageSource damagesource = DamageSource.m_19337_((Entity)this, (Entity)((owner = this.m_37282_()) == null ? this : owner));
        this.dealtDamage = true;
        SoundEvent soundevent = (SoundEvent)BzSounds.STINGER_SPEAR_HIT.get();
        if (entity2.m_6469_(damagesource, damageAmount)) {
            if (entity2.m_6095_() == EntityType.f_20566_) {
                return;
            }
            if (entity2 instanceof LivingEntity) {
                LivingEntity hitEntity = (LivingEntity)entity2;
                if (owner instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)hitEntity, (Entity)owner);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)owner), (Entity)hitEntity);
                }
                this.m_7761_(hitEntity);
            }
        }
        if (entity2 instanceof LivingEntity && (livingEntity = (LivingEntity)entity2).m_21224_() && (entity = this.m_37282_()) instanceof ServerPlayer && !(serverPlayer = (ServerPlayer)entity).m_142538_().m_123314_((Vec3i)this.m_142538_(), 50.0)) {
            BzCriterias.STINGER_SPEAR_LONG_RANGE_KILL_TRIGGER.trigger(serverPlayer);
        }
        this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
        this.m_5496_(soundevent, 1.0f, 1.0f);
    }

    protected void m_7761_(LivingEntity livingEntity) {
        Entity entity2;
        int potentPoisonLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)BzEnchantments.POTENT_POISON.get()), (ItemStack)this.spearItem);
        if (livingEntity.m_6336_() != MobType.f_21641_) {
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 100 + 100 * (potentPoisonLevel - (potentPoisonLevel - 1) / 2), potentPoisonLevel, true, true, true));
            entity2 = this.m_37282_();
            if (entity2 instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity2;
                BzCriterias.STINGER_SPEAR_POISONING_TRIGGER.trigger(serverPlayer);
            }
        }
        if ((entity2 = this.m_37282_()) instanceof Player) {
            Player player = (Player)entity2;
            int neuroToxinLevel = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)BzEnchantments.NEUROTOXINS.get()), (ItemStack)this.spearItem);
            if (neuroToxinLevel > 0) {
                this.spearItem.m_41622_(5, (LivingEntity)player, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
            }
        }
    }

    protected float m_6882_() {
        return 0.75f;
    }

    private boolean isAcceptibleReturnOwner() {
        Entity entity = this.m_37282_();
        if (entity != null && entity.m_6084_()) {
            return !(entity instanceof ServerPlayer) || !entity.m_5833_();
        }
        return false;
    }

    protected ItemStack m_7941_() {
        return this.spearItem.m_41777_();
    }

    public boolean isFoil() {
        return (Boolean)this.f_19804_.m_135370_(ID_FOIL);
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 vec3, Vec3 vec31) {
        return this.dealtDamage ? null : super.m_6351_(vec3, vec31);
    }

    protected boolean m_142470_(Player player) {
        return super.m_142470_(player) || this.m_36797_() && this.m_150171_((Entity)player) && player.m_150109_().m_36054_(this.m_7941_());
    }

    protected SoundEvent m_7239_() {
        return (SoundEvent)BzSounds.STINGER_SPEAR_HIT_GROUND.get();
    }

    public void m_6123_(Player player) {
        if (this.m_150171_((Entity)player) || this.m_37282_() == null) {
            super.m_6123_(player);
        }
    }

    public void m_6901_() {
        byte loyalty = (Byte)this.f_19804_.m_135370_(ID_LOYALTY);
        if (this.f_36705_ != AbstractArrow.Pickup.ALLOWED || loyalty <= 0) {
            super.m_6901_();
        }
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (compoundTag.m_128425_("Trident", 10)) {
            this.spearItem = ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("StingerSpear"));
        }
        this.dealtDamage = compoundTag.m_128471_("DealtDamage");
        this.f_19804_.m_135381_(ID_LOYALTY, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)this.spearItem)));
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128365_("StingerSpear", (Tag)this.spearItem.m_41739_(new CompoundTag()));
        compoundTag.m_128379_("DealtDamage", this.dealtDamage);
    }

    public boolean m_6000_(double x, double y, double z) {
        return true;
    }
}

