/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.mobs;

import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.client.LivingEntityFlyingSoundInstance;
import com.telepathicgrunt.the_bumblezone.configs.BzBeeAggressionConfigs;
import com.telepathicgrunt.the_bumblezone.entities.BeeInteractivity;
import com.telepathicgrunt.the_bumblezone.entities.goals.BeehemothAIRide;
import com.telepathicgrunt.the_bumblezone.entities.goals.BeehemothFlyingStillGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.BeehemothRandomFlyGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.BeehemothTemptGoal;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundAddMobPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BeehemothEntity
extends TamableAnimal
implements FlyingAnimal {
    private static final EntityDataAccessor<Boolean> SADDLED = SynchedEntityData.m_135353_(BeehemothEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> QUEEN = SynchedEntityData.m_135353_(BeehemothEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> FRIENDSHIP = SynchedEntityData.m_135353_(BeehemothEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final TranslatableComponent QUEEN_NAME = new TranslatableComponent("entity.the_bumblezone.beehemoth_queen");
    public static final int TICKS_PER_FLAP = Mth.m_14167_((float)1.4959966f);
    private boolean stopWandering = false;
    public float offset1;
    public float offset2;
    public float offset3;
    public float offset4;
    public float offset5;
    public float offset6;
    public boolean movingStraightUp = false;
    public boolean movingStraightDown = false;

    public BeehemothEntity(EntityType<? extends BeehemothEntity> type, Level world) {
        super(type, world);
        this.f_21342_ = new MoveHelperController(this);
        this.offset1 = this.f_19796_.nextFloat() - 0.5f;
        this.offset2 = this.f_19796_.nextFloat() - 0.5f;
        this.offset3 = this.f_19796_.nextFloat() - 0.5f;
        this.offset4 = this.f_19796_.nextFloat() - 0.5f;
        this.offset5 = this.f_19796_.nextFloat() - 0.5f;
        this.offset6 = this.f_19796_.nextFloat() - 0.5f;
    }

    protected Component m_5677_() {
        if (this.isQueen()) {
            return QUEEN_NAME;
        }
        return super.m_5677_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SADDLED, (Object)false);
        this.f_19804_.m_135372_(QUEEN, (Object)false);
        this.f_19804_.m_135372_(FRIENDSHIP, (Object)0);
    }

    public static AttributeSupplier.Builder getAttributeBuilder() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 42.0).m_22268_(Attributes.f_22280_, 0.6).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22277_, 128.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new BeehemothAIRide(this));
        this.f_21345_.m_25352_(1, (Goal)new BeehemothTemptGoal(this, 1.5, Ingredient.m_204132_(BzTags.HONEY_BUCKETS)));
        this.f_21345_.m_25352_(2, (Goal)new BeehemothFlyingStillGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new BeehemothRandomFlyGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 60.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new FloatGoal((Mob)this));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("saddled", this.isSaddled());
        tag.m_128379_("queen", this.isQueen());
        tag.m_128405_("friendship", this.getFriendship());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setSaddled(tag.m_128471_("saddled"));
        this.setQueen(tag.m_128441_("queen") && tag.m_128471_("queen"));
        this.setFriendship(tag.m_128451_("friendship"));
    }

    protected PathNavigation m_6037_(Level pLevel) {
        return new DirectPathNavigator((Mob)this, pLevel);
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public boolean isQueen() {
        return (Boolean)this.f_19804_.m_135370_(QUEEN);
    }

    public boolean isSaddled() {
        return (Boolean)this.f_19804_.m_135370_(SADDLED);
    }

    public void setSaddled(boolean saddled) {
        this.f_19804_.m_135381_(SADDLED, (Object)saddled);
    }

    public void setQueen(boolean queen) {
        this.f_19804_.m_135381_(QUEEN, (Object)queen);
    }

    public int getFriendship() {
        return (Integer)this.f_19804_.m_135370_(FRIENDSHIP);
    }

    public void setFriendship(Integer newFriendship) {
        this.f_19804_.m_135381_(FRIENDSHIP, (Object)Math.min(Math.max(newFriendship, -100), 1000));
    }

    public void addFriendship(Integer deltaFriendship) {
        this.f_19804_.m_135381_(FRIENDSHIP, (Object)Math.min(Math.max(this.getFriendship() + deltaFriendship, -100), 1000));
    }

    public boolean isStopWandering() {
        return this.stopWandering;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (this.m_20092_() && source == DamageSource.f_19310_) {
            this.spawnMadParticles();
            this.m_6677_(source);
            return false;
        }
        Entity entity = source.m_7639_();
        if (entity != null && entity.m_142081_().equals(this.m_142504_())) {
            this.addFriendship((int)(-3.0f * amount));
        }
        if (((Boolean)BzBeeAggressionConfigs.beehemothTriggersWrath.get()).booleanValue() && entity instanceof LivingEntity) {
            Player player;
            LivingEntity livingEntity = (LivingEntity)entity;
            this.addFriendship((int)(-amount));
            if (!(livingEntity instanceof Player && (player = (Player)livingEntity).m_7500_() || !livingEntity.f_19853_.m_46472_().m_135782_().equals((Object)Bumblezone.MOD_DIMENSION_ID) && !((Boolean)BzBeeAggressionConfigs.allowWrathOfTheHiveOutsideBumblezone.get()).booleanValue() || livingEntity.m_5833_() || !((Boolean)BzBeeAggressionConfigs.aggressiveBees.get()).booleanValue())) {
                if (livingEntity.m_21023_((MobEffect)BzEffects.PROTECTION_OF_THE_HIVE.get())) {
                    livingEntity.m_21195_((MobEffect)BzEffects.PROTECTION_OF_THE_HIVE.get());
                } else {
                    livingEntity.m_7292_(new MobEffectInstance((MobEffect)BzEffects.WRATH_OF_THE_HIVE.get(), ((Integer)BzBeeAggressionConfigs.howLongWrathOfTheHiveLasts.get()).intValue(), 2, false, ((Boolean)BzBeeAggressionConfigs.showWrathOfTheHiveParticles.get()).booleanValue(), true));
                }
            }
        } else {
            this.addFriendship((int)(-amount));
        }
        this.spawnMadParticles();
        this.m_21839_(false);
        return super.m_6469_(source, amount);
    }

    public float getFinalFlyingSpeed() {
        float finalFlyingSpeed = this.f_20887_;
        finalFlyingSpeed = finalFlyingSpeed == 0.02f ? (float)this.m_21133_(Attributes.f_22280_) / 0.6f : (finalFlyingSpeed /= 0.02f);
        return finalFlyingSpeed;
    }

    public static boolean checkMobSpawnRules(EntityType<? extends Mob> entityType, LevelAccessor iWorld, MobSpawnType spawnReason, BlockPos blockPos, Random random) {
        return true;
    }

    public boolean m_5545_(LevelAccessor world, MobSpawnType spawnReason) {
        return true;
    }

    public boolean m_6914_(LevelReader worldReader) {
        AABB box = this.m_142469_();
        return !worldReader.m_46855_(box) && worldReader.m_45556_(box).noneMatch(state -> state.m_60767_().m_76334_()) && worldReader.m_45784_((Entity)this);
    }

    public Entity m_6688_() {
        Iterator iterator = this.m_20197_().iterator();
        if (iterator.hasNext()) {
            Entity p = (Entity)iterator.next();
            return p;
        }
        return null;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        InteractionResult actionresulttype1;
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        ResourceLocation itemRL = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item);
        if (this.f_19853_.f_46443_) {
            if (this.m_21824_() && this.m_21830_((LivingEntity)player)) {
                return InteractionResult.SUCCESS;
            }
            return !(this.m_21223_() < this.m_21233_()) && this.m_21824_() ? InteractionResult.PASS : InteractionResult.SUCCESS;
        }
        if (this.m_21824_()) {
            if (this.m_21830_((LivingEntity)player)) {
                if (stack.m_204117_(BzTags.BEE_FEEDING_ITEMS) && !player.m_6144_()) {
                    if (item == BzItems.BEE_BREAD.get()) {
                        this.m_5634_(2.0f);
                        BeeInteractivity.calmAndSpawnHearts(this.f_19853_, player, (LivingEntity)this, 0.8f, 5);
                        this.addFriendship(5);
                        return InteractionResult.PASS;
                    }
                    if (stack.m_204117_(BzTags.HONEY_BUCKETS)) {
                        this.m_5634_(this.m_21233_() - this.m_21223_());
                        BeeInteractivity.calmAndSpawnHearts(this.f_19853_, player, (LivingEntity)this, 0.8f, 5);
                        this.addFriendship(5);
                    } else if (itemRL.m_135815_().contains("honey")) {
                        this.m_5634_(2.0f);
                        BeeInteractivity.calmAndSpawnHearts(this.f_19853_, player, (LivingEntity)this, 0.3f, 3);
                        this.addFriendship(3);
                    } else {
                        this.m_5634_(1.0f);
                        BeeInteractivity.calmAndSpawnHearts(this.f_19853_, player, (LivingEntity)this, 0.1f, 3);
                        this.addFriendship(1);
                    }
                    if (!player.m_7500_()) {
                        GeneralUtils.givePlayerItem(player, hand, ItemStack.f_41583_, true, true);
                    }
                    player.m_21011_(hand, true);
                    return InteractionResult.CONSUME;
                }
                if (item == Items.f_42450_ && !this.isSaddled()) {
                    this.m_142075_(player, hand, stack);
                    this.setSaddled(true);
                    return InteractionResult.CONSUME;
                }
                if (player.m_6144_()) {
                    if (this.isSaddled() && this.m_21825_() && stack.m_41619_()) {
                        this.setSaddled(false);
                        ItemStack saddle = new ItemStack((ItemLike)Items.f_42450_);
                        if (player.m_36356_(saddle)) {
                            ItemEntity entity = new ItemEntity(player.f_19853_, player.m_20185_(), player.m_20186_(), player.m_20189_(), saddle);
                            player.f_19853_.m_7967_((Entity)entity);
                        }
                    } else {
                        this.m_21839_(!this.m_21827_());
                        this.f_21344_.m_26573_();
                        this.m_6710_(null);
                    }
                    return InteractionResult.SUCCESS;
                }
                if (!this.m_20160_() && !player.m_36341_()) {
                    if (!this.f_19853_.f_46443_) {
                        player.m_20329_((Entity)this);
                        this.m_21839_(false);
                    }
                    return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
                }
            }
        } else if (stack.m_204117_(BzTags.BEE_FEEDING_ITEMS)) {
            if (this.getFriendship() >= 0) {
                float tameChance = stack.m_204117_(BzTags.HONEY_BUCKETS) || item == BzItems.BEE_BREAD.get() ? 0.25f : (itemRL.m_135815_().contains("honey") ? 0.1f : 0.067f);
                if (this.f_19796_.nextFloat() < tameChance) {
                    this.m_21828_(player);
                    this.setFriendship(6);
                    this.m_21839_(true);
                    this.f_19853_.m_7605_((Entity)this, (byte)7);
                } else {
                    this.f_19853_.m_7605_((Entity)this, (byte)6);
                }
            } else {
                this.addFriendship(1);
                if (item == BzItems.BEE_BREAD.get()) {
                    this.addFriendship(5);
                    return InteractionResult.PASS;
                }
                if (stack.m_204117_(BzTags.HONEY_BUCKETS)) {
                    this.addFriendship(3);
                } else if (itemRL.m_135815_().contains("honey")) {
                    this.addFriendship(2);
                } else {
                    this.addFriendship(1);
                }
            }
            if (!player.m_7500_()) {
                GeneralUtils.givePlayerItem(player, hand, ItemStack.f_41583_, true, true);
            }
            this.m_21530_();
            player.m_21011_(hand, true);
            if (this.getFriendship() < 0) {
                this.spawnMadParticles();
            }
            return InteractionResult.CONSUME;
        }
        if ((actionresulttype1 = super.m_6071_(player, hand)).m_19077_()) {
            this.m_21530_();
        }
        if (this.getFriendship() < 0) {
            this.spawnMadParticles();
        }
        return actionresulttype1;
    }

    private void spawnMadParticles() {
        if (!this.f_19853_.m_5776_()) {
            ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123792_, this.m_20185_(), this.m_20186_(), this.m_20189_(), Math.min(Math.max(1, this.getFriendship() / -3), 7), (double)(this.f_19853_.m_5822_().nextFloat() - 0.5f), (double)(this.f_19853_.m_5822_().nextFloat() * 0.4f + 0.4f), (double)(this.f_19853_.m_5822_().nextFloat() - 0.5f), (double)(this.f_19853_.m_5822_().nextFloat() * 0.8f + 0.4f));
        }
    }

    public void m_7332_(Entity passenger) {
        if (this.m_20363_(passenger)) {
            float radius = -0.25f;
            float angle = (float)Math.PI / 180 * this.f_20883_;
            double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * Mth.m_14089_((float)angle);
            passenger.m_6034_(this.m_20185_() + extraX, this.m_20186_() + this.m_6048_() + passenger.m_6049_(), this.m_20189_() + extraZ);
            double currentSpeed = this.m_20184_().m_82553_();
            if (currentSpeed > 1.0E-6 && (double)this.f_19853_.f_46441_.nextFloat() < 0.0085 && passenger.m_142081_().equals(this.m_142504_())) {
                this.addFriendship(1);
            }
        }
    }

    public double m_6048_() {
        float f = Math.min(0.25f, this.f_20924_);
        float f1 = this.f_20925_;
        return (double)this.m_20206_() - 0.2 + (double)(0.12f * Mth.m_14089_((float)(f1 * 0.7f)) * 0.7f * f);
    }

    protected void m_20351_(Entity entity) {
        super.m_20351_(entity);
        if (entity == this.m_142480_()) {
            this.m_21839_(true);
        }
    }

    public boolean m_20068_() {
        return true;
    }

    protected void m_7840_(double y, boolean onGround, BlockState blockState, BlockPos blockPos) {
    }

    public boolean m_142535_(float fallDistance, float damageModifier, DamageSource damageSource) {
        return false;
    }

    protected void m_21229_() {
    }

    protected void m_7355_(BlockPos pos, BlockState blockState) {
    }

    protected SoundEvent m_7515_() {
        return null;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)BzSounds.BEEHEMOTH_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)BzSounds.BEEHEMOTH_DEATH.get();
    }

    public void m_142223_(ClientboundAddMobPacket clientboundAddMobPacket) {
        super.m_142223_(clientboundAddMobPacket);
        LivingEntityFlyingSoundInstance.playSound((LivingEntity)this, (SoundEvent)BzSounds.BEEHEMOTH_LOOP.get());
    }

    public void m_8119_() {
        super.m_8119_();
        this.stopWandering = this.m_21523_();
        if (!this.isQueen() && this.getFriendship() >= 1000) {
            this.setQueen(true);
            LivingEntity livingEntity = this.m_142480_();
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                BzCriterias.QUEEN_BEEHEMOTH_TRIGGER.trigger(serverPlayer);
            }
        } else if (this.getFriendship() < 0 && this.m_21824_()) {
            this.m_20153_();
            if (this.f_19853_.f_46441_.nextFloat() < 0.01f) {
                this.spawnMadParticles();
            }
        }
        if (this.m_20096_()) {
            this.m_20334_(this.m_20184_().m_7096_(), this.m_20184_().m_7098_() - 0.003, this.m_20184_().m_7094_());
        }
    }

    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageableEntity) {
        return null;
    }

    public void m_21463_(Entity entity, boolean sendAttachNotification) {
        super.m_21463_(entity, sendAttachNotification);
        this.stopWandering = true;
    }

    public boolean m_142592_() {
        return this.f_19797_ % TICKS_PER_FLAP == 0;
    }

    public boolean isTargetBlocked(Vec3 target) {
        Vec3 vec3 = new Vec3(this.m_20185_(), this.m_20188_(), this.m_20189_());
        return this.f_19853_.m_45547_(new ClipContext(vec3, target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).m_6662_() != HitResult.Type.MISS;
    }

    static class MoveHelperController
    extends MoveControl {
        private final BeehemothEntity beehemothEntity;

        public MoveHelperController(BeehemothEntity beehemothEntity) {
            super((Mob)beehemothEntity);
            this.beehemothEntity = beehemothEntity;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.STRAFE) {
                Vec3 vec3 = new Vec3(this.f_24975_ - this.beehemothEntity.m_20185_(), this.f_24976_ - this.beehemothEntity.m_20186_(), this.f_24977_ - this.beehemothEntity.m_20189_());
                double d0 = vec3.m_82553_();
                this.beehemothEntity.m_20256_(this.beehemothEntity.m_20184_().m_82520_(0.0, vec3.m_82490_(this.f_24978_ * 0.05 / d0).m_7098_(), 0.0));
                float f = (float)this.f_24974_.m_21133_(Attributes.f_22279_);
                float f1 = (float)this.f_24978_ * f;
                this.f_24979_ = 1.0f;
                this.f_24980_ = 0.0f;
                this.f_24974_.m_7910_(f1);
                this.f_24974_.m_21564_(this.f_24979_);
                this.f_24974_.m_21570_(this.f_24980_);
                this.f_24981_ = MoveControl.Operation.WAIT;
            } else if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                Vec3 vec3 = new Vec3(this.f_24975_ - this.beehemothEntity.m_20185_(), this.f_24976_ - this.beehemothEntity.m_20186_(), this.f_24977_ - this.beehemothEntity.m_20189_());
                double d0 = vec3.m_82553_();
                if (d0 < this.beehemothEntity.m_142469_().m_82309_()) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                    this.beehemothEntity.m_20256_(this.beehemothEntity.m_20184_().m_82490_(0.5));
                } else {
                    double localSpeed = this.f_24978_;
                    if (this.beehemothEntity.m_20160_()) {
                        localSpeed *= 1.5;
                    }
                    Vec3 newVelocity = this.beehemothEntity.m_20184_().m_82549_(vec3.m_82490_(localSpeed * 0.005 / d0));
                    double newYSpeed = this.beehemothEntity.m_20096_() && newVelocity.m_7098_() + 0.0027 > 0.0 ? newVelocity.m_7098_() + 0.009 : newVelocity.m_7098_();
                    this.beehemothEntity.m_20334_(newVelocity.m_7096_(), newYSpeed, newVelocity.m_7094_());
                    if (this.beehemothEntity.m_5448_() == null) {
                        double d2 = this.f_24975_ - this.beehemothEntity.m_20185_();
                        double d1 = this.f_24977_ - this.beehemothEntity.m_20189_();
                        float newRot = (float)(-Mth.m_14136_((double)d2, (double)d1) * 57.2957763671875);
                        this.beehemothEntity.m_146922_(this.m_24991_(this.beehemothEntity.m_146908_(), newRot, 10.0f));
                    } else {
                        double d2 = this.beehemothEntity.m_5448_().m_20185_() - this.beehemothEntity.m_20185_();
                        double d1 = this.beehemothEntity.m_5448_().m_20189_() - this.beehemothEntity.m_20189_();
                        float newRot = (float)(-Mth.m_14136_((double)d1, (double)d2) * 57.2957763671875);
                        this.beehemothEntity.m_146922_(this.m_24991_(this.beehemothEntity.m_146908_(), newRot, 10.0f));
                    }
                }
            }
        }
    }

    public static class DirectPathNavigator
    extends GroundPathNavigation {
        private final Mob mob;

        public DirectPathNavigator(Mob mob, Level world) {
            super(mob, world);
            this.mob = mob;
        }

        public void m_7638_() {
            ++this.f_26498_;
        }

        public boolean m_26519_(double x, double y, double z, double speedIn) {
            this.mob.m_21566_().m_6849_(x, y, z, speedIn);
            return true;
        }

        public boolean m_5624_(Entity entityIn, double speedIn) {
            this.mob.m_21566_().m_6849_(entityIn.m_20185_(), entityIn.m_20186_(), entityIn.m_20189_(), speedIn);
            return true;
        }
    }
}

