/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.goals;

import com.telepathicgrunt.the_bumblezone.entities.mobs.BeehemothEntity;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public class BeehemothTemptGoal
extends Goal {
    private static final TargetingConditions TEMP_TARGETING = TargetingConditions.m_148353_().m_26883_(10.0).m_148355_();
    private final TargetingConditions targetingConditions;
    protected final BeehemothEntity mob;
    private final double speedModifier;
    @Nullable
    protected Player player;
    private final Ingredient items;

    public BeehemothTemptGoal(BeehemothEntity pathfinderMob, double speedModifier, Ingredient ingredient) {
        this.mob = pathfinderMob;
        this.speedModifier = speedModifier;
        this.items = ingredient;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.targetingConditions = TEMP_TARGETING.m_148354_().m_26888_(entity -> this.mob.m_142480_() == entity).m_26888_(this::shouldFollow);
    }

    public boolean m_8036_() {
        if (this.mob.m_21824_()) {
            Player player;
            LivingEntity owner = this.mob.m_142480_();
            if (owner instanceof Player && (player = (Player)owner).m_6084_() && player.f_19853_ == this.mob.f_19853_ && this.shouldFollow((LivingEntity)player)) {
                this.player = player;
                this.mob.m_21837_(false);
                return true;
            }
            return false;
        }
        this.player = this.mob.f_19853_.m_45946_(this.targetingConditions, (LivingEntity)this.mob);
        return this.player != null;
    }

    private boolean shouldFollow(LivingEntity livingEntity) {
        return this.items.test(livingEntity.m_21205_()) || this.items.test(livingEntity.m_21206_());
    }

    public boolean m_8045_() {
        double d = this.mob.m_20280_((Entity)this.player);
        double d2 = this.mob.m_21824_() ? 200.0 : 36.0;
        if (d > d2) {
            return false;
        }
        return this.m_8036_();
    }

    public void m_8041_() {
        this.player = null;
        this.mob.m_21573_().m_26573_();
    }

    public void m_8037_() {
        this.mob.m_21563_().m_24960_((Entity)this.player, (float)(this.mob.m_8085_() + 20), (float)this.mob.m_8132_());
        if (this.mob.m_20280_((Entity)this.player) < 6.25) {
            this.mob.m_21573_().m_26573_();
        } else {
            this.mob.m_21573_().m_5624_((Entity)this.player, this.speedModifier * (double)(this.mob.m_21824_() ? 2 : 1));
        }
    }
}

