/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities;

import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.capabilities.BzCapabilities;
import com.telepathicgrunt.the_bumblezone.capabilities.EntityPositionAndDimension;
import com.telepathicgrunt.the_bumblezone.configs.BzDimensionConfigs;
import com.telepathicgrunt.the_bumblezone.entities.EntityTeleportationBackend;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.world.dimension.BzDimension;
import com.telepathicgrunt.the_bumblezone.world.dimension.BzWorldSavedData;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;

public class EntityTeleportationHookup {
    public static void entityTick(LivingEvent.LivingUpdateEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity.f_19853_.m_46472_().m_135782_().equals((Object)Bumblezone.MOD_DIMENSION_ID)) {
            if (livingEntity.m_20186_() < -2.0) {
                if (livingEntity instanceof ServerPlayer && livingEntity.f_19789_ > 100.0f && livingEntity.m_20184_().m_7098_() < -1.0) {
                    BzCriterias.TELEPORT_OUT_OF_BUMBLEZONE_FALL_TRIGGER.trigger((ServerPlayer)livingEntity);
                }
                if (((Boolean)BzDimensionConfigs.enableExitTeleportation.get()).booleanValue()) {
                    if (livingEntity.m_20186_() < -4.0) {
                        livingEntity.m_6027_(livingEntity.m_20185_(), -4.0, livingEntity.m_20189_());
                        livingEntity.m_20248_(livingEntity.m_20185_(), -4.0, livingEntity.m_20189_());
                    }
                    livingEntity.f_19789_ = 0.0f;
                    if (!livingEntity.f_19853_.m_5776_()) {
                        EntityTeleportationHookup.teleportOutOfBz(livingEntity);
                    }
                }
            } else if (livingEntity.m_20186_() > 255.0 && ((Boolean)BzDimensionConfigs.enableExitTeleportation.get()).booleanValue()) {
                if (livingEntity.m_20186_() > 257.0) {
                    livingEntity.m_6027_(livingEntity.m_20185_(), 257.0, livingEntity.m_20189_());
                    livingEntity.m_20248_(livingEntity.m_20185_(), 257.0, livingEntity.m_20189_());
                }
                if (!livingEntity.f_19853_.m_5776_()) {
                    EntityTeleportationHookup.teleportOutOfBz(livingEntity);
                }
            }
        }
    }

    public static void teleportOutOfBz(LivingEntity livingEntity) {
        if (!livingEntity.f_19853_.m_5776_()) {
            ResourceKey worldKey;
            EntityTeleportationHookup.checkAndCorrectStoredDimension(livingEntity);
            MinecraftServer minecraftServer = livingEntity.m_20194_();
            if (livingEntity.m_6688_() == null) {
                capability = (EntityPositionAndDimension)livingEntity.getCapability(BzCapabilities.ENTITY_POS_AND_DIM_CAPABILITY).orElseThrow(RuntimeException::new);
                worldKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)capability.getNonBZDim());
            } else {
                Entity entity = livingEntity.m_6688_();
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity2 = (LivingEntity)entity;
                    EntityTeleportationHookup.checkAndCorrectStoredDimension(livingEntity2);
                }
                capability = (EntityPositionAndDimension)livingEntity.m_6688_().getCapability(BzCapabilities.ENTITY_POS_AND_DIM_CAPABILITY).orElseThrow(RuntimeException::new);
                worldKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)capability.getNonBZDim());
            }
            ServerLevel serverWorld = minecraftServer.m_129880_(worldKey);
            if (serverWorld == null) {
                serverWorld = minecraftServer.m_129880_(Level.f_46428_);
            }
            BzWorldSavedData.queueEntityToTeleport((Entity)livingEntity, (ResourceKey<Level>)serverWorld.m_46472_());
        }
    }

    public static boolean runEnderpearlImpact(Vec3 hitPos, Entity thrower, Entity pearl) {
        Level world = thrower.f_19853_;
        if (((Boolean)BzDimensionConfigs.enableEntranceTeleportation.get()).booleanValue() && !world.m_5776_() && thrower instanceof ServerPlayer) {
            ServerPlayer playerEntity = (ServerPlayer)thrower;
            if (!(world.m_46472_().m_135782_().equals((Object)Bumblezone.MOD_DIMENSION_ID) || ((Boolean)BzDimensionConfigs.onlyOverworldHivesTeleports.get()).booleanValue() && !world.m_46472_().equals((Object)Level.f_46428_))) {
                BlockPos hivePos = EntityTeleportationHookup.getNearbyHivePos(hitPos, world);
                if (hivePos == null) {
                    hitPos = hitPos.m_82549_(pearl.m_20184_());
                    hivePos = EntityTeleportationHookup.getNearbyHivePos(hitPos, world);
                }
                if (hivePos == null) {
                    return false;
                }
                boolean validBelowBlock = false;
                Optional blockTag = Registry.f_122824_.m_203431_(BzTags.REQUIRED_BLOCKS_UNDER_HIVE_TO_TELEPORT);
                if (blockTag.isPresent() && ((HolderSet.Named)blockTag.get()).m_203632_() != 0) {
                    if (world.m_8055_(hivePos.m_7495_()).m_204336_(BzTags.REQUIRED_BLOCKS_UNDER_HIVE_TO_TELEPORT)) {
                        validBelowBlock = true;
                    } else if (((Boolean)BzDimensionConfigs.warnPlayersOfWrongBlockUnderHive.get()).booleanValue()) {
                        Bumblezone.LOGGER.log(org.apache.logging.log4j.Level.INFO, "Bumblezone: the_bumblezone:required_blocks_under_hive_to_teleport tag does not have the block below the hive.");
                        TextComponent message = new TextComponent("the_bumblezone:required_blocks_under_hive_to_teleport tag does not have the block below the hive.");
                        playerEntity.m_5661_((Component)message, true);
                        return false;
                    }
                } else {
                    validBelowBlock = true;
                }
                if (validBelowBlock) {
                    BzCriterias.TELEPORT_TO_BUMBLEZONE_PEARL_TRIGGER.trigger(playerEntity);
                    BzWorldSavedData.queueEntityToTeleport((Entity)playerEntity, BzDimension.BZ_WORLD_KEY);
                    return true;
                }
            }
        }
        return false;
    }

    private static BlockPos getNearbyHivePos(Vec3 hitBlockPos, Level world) {
        double checkRadius = 0.5;
        for (double offset = -checkRadius; offset <= checkRadius; offset += checkRadius) {
            for (double offset2 = -checkRadius; offset2 <= checkRadius; offset2 += checkRadius) {
                for (double offset3 = -checkRadius; offset3 <= checkRadius; offset3 += checkRadius) {
                    BlockPos offsettedHitPos = new BlockPos(hitBlockPos.m_82520_(offset, offset2, offset3));
                    BlockState block = world.m_8055_(offsettedHitPos);
                    if (!EntityTeleportationBackend.isValidBeeHive(block)) continue;
                    return offsettedHitPos;
                }
            }
        }
        return null;
    }

    public static void runPistonPushed(Direction direction, LivingEntity pushedEntity) {
        ServerLevel world = (ServerLevel)pushedEntity.f_19853_;
        if (((Boolean)BzDimensionConfigs.enableEntranceTeleportation.get()).booleanValue() && !world.m_46472_().m_135782_().equals((Object)Bumblezone.MOD_DIMENSION_ID) && (!((Boolean)BzDimensionConfigs.onlyOverworldHivesTeleports.get()).booleanValue() || world.m_46472_().equals((Object)Level.f_46428_))) {
            if (BzWorldSavedData.isEntityQueuedToTeleportAlready((Entity)pushedEntity)) {
                return;
            }
            BlockPos.MutableBlockPos entityPos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pushedEntity.m_142538_());
            BlockPos[] blockPositions = new BlockPos[]{entityPos, entityPos.m_142300_(direction), entityPos.m_142300_(Direction.UP), entityPos.m_142300_(Direction.UP).m_142300_(direction)};
            ArrayList<BlockState> belowHiveBlocks = new ArrayList<BlockState>();
            boolean isPushedIntoBeehive = false;
            for (BlockPos pos : blockPositions) {
                if (!EntityTeleportationBackend.isValidBeeHive(world.m_8055_(pos))) continue;
                isPushedIntoBeehive = true;
                belowHiveBlocks.add(world.m_8055_(pos.m_7495_()));
            }
            if (isPushedIntoBeehive) {
                boolean validBelowBlock = false;
                Optional blockTag = Registry.f_122824_.m_203431_(BzTags.REQUIRED_BLOCKS_UNDER_HIVE_TO_TELEPORT);
                if (blockTag.isPresent() && ((HolderSet.Named)blockTag.get()).m_203632_() != 0) {
                    for (BlockState belowBlock : belowHiveBlocks) {
                        if (!belowBlock.m_204336_(BzTags.REQUIRED_BLOCKS_UNDER_HIVE_TO_TELEPORT)) continue;
                        validBelowBlock = true;
                    }
                    if (!validBelowBlock && ((Boolean)BzDimensionConfigs.warnPlayersOfWrongBlockUnderHive.get()).booleanValue()) {
                        if (pushedEntity instanceof Player) {
                            Player playerEntity = (Player)pushedEntity;
                            Bumblezone.LOGGER.log(org.apache.logging.log4j.Level.INFO, "Bumblezone: the_bumblezone:required_blocks_under_hive_to_teleport tag does not have the block below the hive.");
                            TextComponent message = new TextComponent("the_bumblezone:required_blocks_under_hive_to_teleport tag does not have the block below the hive.");
                            playerEntity.m_5661_((Component)message, true);
                        }
                        return;
                    }
                } else {
                    validBelowBlock = true;
                }
                if (validBelowBlock) {
                    if (pushedEntity instanceof ServerPlayer) {
                        BzCriterias.TELEPORT_TO_BUMBLEZONE_PISTON_TRIGGER.trigger((ServerPlayer)pushedEntity);
                    }
                    BzWorldSavedData.queueEntityToTeleport((Entity)pushedEntity, BzDimension.BZ_WORLD_KEY);
                }
            }
        }
    }

    private static void checkAndCorrectStoredDimension(LivingEntity livingEntity) {
        EntityPositionAndDimension capability = (EntityPositionAndDimension)livingEntity.getCapability(BzCapabilities.ENTITY_POS_AND_DIM_CAPABILITY).orElseThrow(RuntimeException::new);
        if (capability.getNonBZDim().equals((Object)Bumblezone.MOD_DIMENSION_ID) || ((Boolean)BzDimensionConfigs.forceExitToOverworld.get()).booleanValue()) {
            capability.setNonBZDim(Level.f_46428_.m_135782_());
        }
    }
}

