/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities;

import com.google.common.primitives.Doubles;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.capabilities.BzCapabilities;
import com.telepathicgrunt.the_bumblezone.capabilities.EntityPositionAndDimension;
import com.telepathicgrunt.the_bumblezone.configs.BzDimensionConfigs;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ProductiveBeesCompat;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.BzPlacingUtils;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class EntityTeleportationBackend {
    private static final int SEARCH_RADIUS = 48;

    public static Vec3 destPostFromOutOfBoundsTeleport(Entity entity, ServerLevel destination, boolean checkingUpward) {
        BlockPos validBlockPos;
        BlockPos finalSpawnPos;
        Entity player = entity.m_20197_().stream().filter(e -> e instanceof Player).findFirst().orElse(null);
        if (player != null) {
            entity = player;
        }
        double coordinateScale = entity.f_19853_.m_6042_().m_63959_() / destination.m_6042_().m_63959_();
        boolean spawnAtFixedPosition = false;
        if ((Integer)BzDimensionConfigs.teleportationMode.get() == 1) {
            finalSpawnPos = new BlockPos(Doubles.constrainToRange((double)(entity.m_20182_().m_7096_() * coordinateScale), (double)-2.9999936E7, (double)2.9999936E7), entity.m_20182_().m_7098_(), Doubles.constrainToRange((double)(entity.m_20182_().m_7094_() * coordinateScale), (double)-2.9999936E7, (double)2.9999936E7));
            validBlockPos = EntityTeleportationBackend.validPlayerSpawnLocationByBeehive((Level)destination, finalSpawnPos, 48, checkingUpward);
        } else if ((Integer)BzDimensionConfigs.teleportationMode.get() == 2) {
            EntityPositionAndDimension capability = (EntityPositionAndDimension)entity.getCapability(BzCapabilities.ENTITY_POS_AND_DIM_CAPABILITY).orElseThrow(RuntimeException::new);
            Vec3 playerPos = capability.getNonBZPos();
            spawnAtFixedPosition = true;
            validBlockPos = playerPos != null ? new BlockPos(playerPos) : entity.m_142538_();
        } else {
            finalSpawnPos = new BlockPos(Doubles.constrainToRange((double)(entity.m_20182_().m_7096_() * coordinateScale), (double)-2.9999936E7, (double)2.9999936E7), entity.m_20182_().m_7098_(), Doubles.constrainToRange((double)(entity.m_20182_().m_7094_() * coordinateScale), (double)-2.9999936E7, (double)2.9999936E7));
            validBlockPos = EntityTeleportationBackend.validPlayerSpawnLocationByBeehive((Level)destination, finalSpawnPos, 48, checkingUpward);
            EntityPositionAndDimension capability = (EntityPositionAndDimension)entity.getCapability(BzCapabilities.ENTITY_POS_AND_DIM_CAPABILITY).orElseThrow(RuntimeException::new);
            Vec3 pastPos = capability.getNonBZPos();
            if (validBlockPos == null && pastPos != null) {
                validBlockPos = new BlockPos(pastPos);
                spawnAtFixedPosition = true;
            }
        }
        finalSpawnPos = validBlockPos;
        if (finalSpawnPos == null) {
            finalSpawnPos = new BlockPos(entity.m_20182_());
            spawnAtFixedPosition = true;
        }
        if (spawnAtFixedPosition && destination.m_8055_(finalSpawnPos.m_7494_()).m_60828_((BlockGetter)destination, finalSpawnPos.m_7494_())) {
            destination.m_7731_(finalSpawnPos, Blocks.f_50016_.m_49966_(), 3);
            destination.m_7731_(finalSpawnPos.m_7494_(), Blocks.f_50016_.m_49966_(), 3);
        }
        return new Vec3((double)finalSpawnPos.m_123341_() + 0.5, (double)(finalSpawnPos.m_123342_() + 1), (double)finalSpawnPos.m_123343_() + 0.5);
    }

    public static Vec3 getBzCoordinate(Entity entity, ServerLevel originalWorld, ServerLevel bumblezoneWorld) {
        int heightCheck;
        LivingEntity livingEntity;
        BlockPos blockpos;
        Object validBlockPos;
        double coordinateScale = 1.0;
        if ((Integer)BzDimensionConfigs.teleportationMode.get() != 2) {
            coordinateScale = originalWorld.m_6042_().m_63959_() / bumblezoneWorld.m_6042_().m_63959_();
        }
        if ((validBlockPos = EntityTeleportationBackend.validPlayerSpawnLocation((Level)bumblezoneWorld, blockpos = new BlockPos(Doubles.constrainToRange((double)(entity.m_20182_().m_7096_() * coordinateScale), (double)-2.9999936E7, (double)2.9999936E7), Doubles.constrainToRange((double)entity.m_20182_().m_7098_(), (double)45.0, (double)200.0), Doubles.constrainToRange((double)(entity.m_20182_().m_7094_() * coordinateScale), (double)-2.9999936E7, (double)2.9999936E7)), 10)) == null) {
            validBlockPos = new BlockPos(blockpos.m_123341_(), BzPlacingUtils.topOfSurfaceBelowHeightThroughWater((LevelAccessor)bumblezoneWorld, blockpos.m_123342_(), 0, blockpos) + 1, blockpos.m_123343_());
            if (validBlockPos.m_123342_() == 0) {
                validBlockPos = null;
            } else if (bumblezoneWorld.m_8055_(validBlockPos).m_60767_() == Material.f_76305_ && bumblezoneWorld.m_8055_(validBlockPos.m_7494_()).m_60767_() == Material.f_76305_) {
                BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(validBlockPos.m_123341_(), validBlockPos.m_123342_(), validBlockPos.m_123343_());
                while (mutable.m_123342_() < 255 && !bumblezoneWorld.m_46859_((BlockPos)mutable) || bumblezoneWorld.m_8055_((BlockPos)mutable).m_60767_() == Material.f_76305_) {
                    mutable.m_122173_(Direction.UP);
                }
                validBlockPos = bumblezoneWorld.m_8055_((BlockPos)mutable).m_60767_() != Material.f_76296_ ? null : mutable;
            } else if (!bumblezoneWorld.m_46859_(validBlockPos) && bumblezoneWorld.m_8055_(validBlockPos).m_60767_() != Material.f_76305_ && bumblezoneWorld.m_8055_(validBlockPos.m_7494_()).m_60767_() != Material.f_76296_) {
                validBlockPos = null;
            }
            if (validBlockPos == null) {
                bumblezoneWorld.m_46597_(blockpos, Blocks.f_50016_.m_49966_());
                bumblezoneWorld.m_46597_(blockpos.m_7494_(), Blocks.f_50016_.m_49966_());
                bumblezoneWorld.m_46597_(blockpos.m_7495_(), Blocks.f_50720_.m_49966_());
                bumblezoneWorld.m_46597_(blockpos.m_7494_().m_7494_(), Blocks.f_50720_.m_49966_());
                bumblezoneWorld.m_46597_(blockpos.m_142127_(), Blocks.f_50720_.m_49966_());
                bumblezoneWorld.m_46597_(blockpos.m_142125_(), Blocks.f_50720_.m_49966_());
                bumblezoneWorld.m_46597_(blockpos.m_142126_(), Blocks.f_50720_.m_49966_());
                bumblezoneWorld.m_46597_(blockpos.m_142128_(), Blocks.f_50720_.m_49966_());
                bumblezoneWorld.m_46597_(blockpos.m_142127_().m_7494_(), Blocks.f_50720_.m_49966_());
                bumblezoneWorld.m_46597_(blockpos.m_142125_().m_7494_(), Blocks.f_50720_.m_49966_());
                bumblezoneWorld.m_46597_(blockpos.m_142126_().m_7494_(), Blocks.f_50720_.m_49966_());
                bumblezoneWorld.m_46597_(blockpos.m_142128_().m_7494_(), Blocks.f_50720_.m_49966_());
                validBlockPos = blockpos;
            }
        }
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_5803_()) {
            livingEntity.m_5796_();
        }
        for (heightCheck = 0; heightCheck <= validBlockPos.m_123342_() && bumblezoneWorld.m_8055_(validBlockPos.m_6625_(heightCheck)).m_60795_(); ++heightCheck) {
        }
        if (heightCheck >= validBlockPos.m_123342_()) {
            bumblezoneWorld.m_46597_(validBlockPos.m_123342_() == 0 ? validBlockPos : validBlockPos.m_7495_(), Blocks.f_50720_.m_49966_());
        }
        return new Vec3((double)validBlockPos.m_123341_() + 0.5, (double)validBlockPos.m_123342_(), (double)validBlockPos.m_123343_() + 0.5);
    }

    private static BlockPos validPlayerSpawnLocationByBeehive(Level world, BlockPos position, int maximumRange, boolean checkingUpward) {
        int maxHeight = 0;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        HashSet<LevelChunk> chunksInRange = new HashSet<LevelChunk>();
        for (int x = -maximumRange; x < maximumRange; x += 16) {
            for (int z = -maximumRange; z < maximumRange; z += 16) {
                mutableBlockPos.m_122178_(position.m_123341_() + x, 0, position.m_123343_() + z);
                ChunkAccess chunk = world.m_46865_((BlockPos)mutableBlockPos);
                if (chunk instanceof LevelChunk) {
                    chunksInRange.add((LevelChunk)chunk);
                }
                maxHeight = Math.max(maxHeight, world.m_6924_(Heightmap.Types.MOTION_BLOCKING, mutableBlockPos.m_123341_(), mutableBlockPos.m_123343_()));
            }
        }
        maxHeight = Math.min(maxHeight, world.m_141928_() - 1);
        BlockPos.MutableBlockPos mutableTemp1 = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos mutableTemp2 = new BlockPos.MutableBlockPos();
        HashSet tempSet = new HashSet();
        chunksInRange.stream().map(LevelChunk::m_62954_).forEach(map -> tempSet.addAll(map.values()));
        Stream<BlockEntity> allBlockEntitiesInRange = tempSet.stream().filter(be -> {
            if (!EntityTeleportationBackend.isValidBeeHive(be.m_58900_())) {
                return false;
            }
            if (((Boolean)BzDimensionConfigs.seaLevelOrHigherExitTeleporting.get()).booleanValue() && be.m_58899_().m_123342_() < ((ServerLevel)world).m_7726_().m_8481_().m_6337_() - 1) {
                return false;
            }
            mutableTemp1.m_122190_((Vec3i)be.m_58899_()).m_122184_(-position.m_123341_(), 0, -position.m_123343_());
            return Math.abs(mutableTemp1.m_123341_()) <= maximumRange && Math.abs(mutableTemp1.m_123343_()) <= maximumRange;
        });
        List sortedBlockEntities = allBlockEntitiesInRange.sorted((be1, be2) -> {
            mutableTemp1.m_122190_((Vec3i)be1.m_58899_()).m_122184_(-position.m_123341_(), 0, -position.m_123343_());
            mutableTemp2.m_122190_((Vec3i)be2.m_58899_()).m_122184_(-position.m_123341_(), 0, -position.m_123343_());
            int heightDiff = mutableTemp1.m_123342_() - mutableTemp2.m_123342_();
            int xzDiff = Math.abs(mutableTemp1.m_123341_() - mutableTemp2.m_123341_()) + Math.abs(mutableTemp1.m_123343_() - mutableTemp2.m_123343_());
            if (checkingUpward) {
                heightDiff *= -1;
                xzDiff *= -1;
            }
            return heightDiff - xzDiff;
        }).collect(Collectors.toList());
        for (BlockEntity blockEntity : sortedBlockEntities) {
            BlockPos validSpot = EntityTeleportationBackend.validPlayerSpawnLocation(world, blockEntity.m_58899_(), 4);
            if (validSpot == null) continue;
            return validSpot;
        }
        if ((Integer)BzDimensionConfigs.teleportationMode.get() == 3) {
            return null;
        }
        if (maxHeight + 1 < world.m_141928_()) {
            ++maxHeight;
        }
        mutableBlockPos.m_122178_(position.m_123341_(), BzPlacingUtils.topOfSurfaceBelowHeight((LevelAccessor)world, maxHeight, 0, position), position.m_123343_());
        if (mutableBlockPos.m_123342_() <= 0) {
            mutableBlockPos.m_122178_(position.m_123341_(), world.m_141928_() / 2, position.m_123343_());
        }
        EntityTeleportationBackend.createSpaceForPlayer(world, mutableBlockPos);
        return mutableBlockPos;
    }

    private static void createSpaceForPlayer(Level world, BlockPos.MutableBlockPos mutableBlockPos) {
        if (((Boolean)BzDimensionConfigs.generateBeenest.get()).booleanValue()) {
            world.m_46597_((BlockPos)mutableBlockPos, Blocks.f_50717_.m_49966_());
        } else if (world.m_8055_((BlockPos)mutableBlockPos).m_60767_() == Material.f_76296_ || !world.m_8055_((BlockPos)mutableBlockPos).m_60819_().m_76178_() && !world.m_8055_((BlockPos)mutableBlockPos).m_60819_().m_205070_(FluidTags.f_13131_)) {
            world.m_46597_((BlockPos)mutableBlockPos, Blocks.f_50720_.m_49966_());
        }
        world.m_46597_(mutableBlockPos.m_7494_(), Blocks.f_50016_.m_49966_());
    }

    private static BlockPos validPlayerSpawnLocation(Level world, BlockPos position, int maximumRange) {
        BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos(position.m_123341_(), position.m_123342_(), position.m_123343_());
        for (int range = 0; range < maximumRange; ++range) {
            int radius = range * range;
            int outerRadius = (range + 1) * (range + 1);
            for (int y = 0; y <= range * 2; ++y) {
                int y2 = y > range ? -(y - range) : y;
                for (int x = 0; x <= range * 2; ++x) {
                    int x2 = x > range ? -(x - range) : x;
                    for (int z = 0; z <= range * 2; ++z) {
                        int z2 = z > range ? -(z - range) : z;
                        int distanceSq = x2 * x2 + z2 * z2 + y2 * y2;
                        if (distanceSq < radius || distanceSq >= outerRadius) continue;
                        currentPos.m_122190_((Vec3i)position.m_142082_(x2, y2, z2));
                        if (!world.m_8055_(currentPos.m_7495_()).m_60815_() || !world.m_8055_((BlockPos)currentPos).m_60795_() || !world.m_8055_(currentPos.m_7494_()).m_60795_()) continue;
                        return currentPos;
                    }
                }
            }
        }
        return null;
    }

    public static boolean isValidBeeHive(BlockState blockState) {
        if (blockState.m_204336_(BzTags.BLACKLISTED_TELEPORTATION_HIVES)) {
            return false;
        }
        if ((blockState.m_204336_(BlockTags.f_13072_) || blockState.m_60734_() instanceof BeehiveBlock) && (ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)blockState.m_60734_()).m_135827_().equals("minecraft") || ((Boolean)BzDimensionConfigs.allowTeleportationWithModdedBeehives.get()).booleanValue())) {
            return true;
        }
        return (Boolean)BzDimensionConfigs.allowTeleportationWithModdedBeehives.get() != false && ModChecker.productiveBeesPresent && ProductiveBeesCompat.PBIsExpandedBeehiveBlock(blockState);
    }

    public static void entityChangingDimension(EntityTravelToDimensionEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!livingEntity.f_19853_.m_5776_() && event.getDimension().m_135782_().equals((Object)Bumblezone.MOD_DIMENSION_ID)) {
                LazyOptional lazyOptional = livingEntity.getCapability(BzCapabilities.ENTITY_POS_AND_DIM_CAPABILITY);
                if (lazyOptional.isPresent()) {
                    EntityPositionAndDimension capability = (EntityPositionAndDimension)lazyOptional.orElseThrow(RuntimeException::new);
                    capability.setNonBZDim(event.getDimension().m_135782_());
                    capability.setNonBZPos(entity.m_20182_());
                } else {
                    String string;
                    EntityType entityType = entity.m_6095_();
                    String string2 = entity.getClass().getName();
                    Component component = entity.m_5446_();
                    if (component instanceof TextComponent) {
                        TextComponent textComponent = (TextComponent)component;
                        string = textComponent.m_131292_();
                    } else {
                        string = "N/A";
                    }
                    Bumblezone.LOGGER.error("Bumblezone entity pos/dim cap was not found for given entity: {}, {}, {}, {}, at {} which has the internal dimension of: {} and is coming from: {}", (Object)entityType, (Object)string2, (Object)string, (Object)entity.m_142081_(), (Object)entity.m_20182_(), (Object)entity.f_19853_.m_46472_(), (Object)event.getDimension());
                }
            }
        }
    }
}

