/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities;

import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;

public final class BeeDedicatedSpawning {
    private BeeDedicatedSpawning() {
    }

    public static void specialSpawnBees(ServerLevel world) {
        int despawnDistance = 80;
        int entityCountChange = 0;
        Set<Bee> allWildBees = GeneralUtils.getAllWildBees();
        List serverPlayers = world.m_6907_();
        for (Bee wildBee : allWildBees) {
            for (ServerPlayer player : serverPlayers) {
                if (!(wildBee.m_20182_().m_82546_(player.m_20182_()).m_82553_() > (double)despawnDistance)) continue;
                wildBee.m_142687_(Entity.RemovalReason.DISCARDED);
                --entityCountChange;
            }
        }
        int beesPerPlayer = (Integer)BzGeneralConfigs.nearbyBeesPerPlayerInBz.get();
        int maxWildBeeLimit = beesPerPlayer * serverPlayers.size();
        if (allWildBees.size() <= maxWildBeeLimit) {
            for (ServerPlayer serverPlayer : serverPlayers) {
                int nearbyBees = 0;
                for (Entity entity : world.m_45933_((Entity)serverPlayer, serverPlayer.m_142469_().m_82377_((double)despawnDistance, (double)despawnDistance, (double)despawnDistance))) {
                    if (!(entity instanceof Bee)) continue;
                    ++nearbyBees;
                }
                for (int i = nearbyBees; i <= beesPerPlayer; ++i) {
                    BlockPos newBeePos = GeneralUtils.getRandomBlockposWithinRange((Level)world, (Entity)serverPlayer, 50, 25);
                    if (world.m_8055_(newBeePos).m_60767_() != Material.f_76296_) continue;
                    Bee newBee = (Bee)EntityType.f_20550_.m_20615_((Level)world);
                    newBee.m_146884_(Vec3.m_82512_((Vec3i)newBeePos));
                    newBee.m_20256_(new Vec3(0.0, 1.0, 0.0));
                    newBee.m_7910_(0.0f);
                    newBee.m_6518_((ServerLevelAccessor)world, world.m_6436_(newBee.m_142538_()), MobSpawnType.NATURAL, null, null);
                    if (ForgeHooks.canEntitySpawn((Mob)newBee, (LevelAccessor)world, (double)newBee.m_20182_().m_7096_(), (double)newBee.m_20182_().m_7098_(), (double)newBee.m_20182_().m_7094_(), null, (MobSpawnType)MobSpawnType.NATURAL) == -1) continue;
                    world.m_7967_((Entity)newBee);
                    ++entityCountChange;
                }
            }
        }
        GeneralUtils.adjustEntityCountInBz(entityCountChange);
    }
}

