/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities;

import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.client.MusicHandler;
import com.telepathicgrunt.the_bumblezone.configs.BzBeeAggressionConfigs;
import com.telepathicgrunt.the_bumblezone.configs.BzClientConfigs;
import com.telepathicgrunt.the_bumblezone.effects.WrathOfTheHiveEffect;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BeeAggression {
    private static final Set<String> LIST_OF_BEE_HATING_NAMES = Set.of("bear", "panda", "wasp", "spider");
    private static final Set<EntityType<?>> SET_OF_BEE_HATED_NAMED_ENTITIES = new HashSet();
    private static final Set<EntityType<?>> SET_OF_BEE_NAMED_ENTITIES = new HashSet();

    public static void setupBeeHatingList() {
        for (EntityType entityType : ForgeRegistries.ENTITIES) {
            String mobName = ForgeRegistries.ENTITIES.getKey((IForgeRegistryEntry)entityType).m_135815_();
            if (mobName.contains("bee")) {
                SET_OF_BEE_NAMED_ENTITIES.add(entityType);
            }
            if (!LIST_OF_BEE_HATING_NAMES.stream().anyMatch(mobName::contains)) continue;
            SET_OF_BEE_HATED_NAMED_ENTITIES.add(entityType);
        }
    }

    public static void minedBlockAnger(BlockEvent.BreakEvent event) {
        if (event.isCanceled()) {
            return;
        }
        Player player = event.getPlayer();
        BlockState blockState = event.getState();
        if (blockState.m_204336_(BzTags.WRATH_ACTIVATING_BLOCKS_WHEN_MINED)) {
            BeeAggression.angerBees(player);
        }
    }

    public static void pickupItemAnger(PlayerEvent.ItemPickupEvent event) {
        Player player = event.getPlayer();
        ItemStack itemStack = event.getStack();
        if (itemStack.m_204117_(BzTags.WRATH_ACTIVATING_ITEMS_WHEN_PICKED_UP)) {
            BeeAggression.angerBees(player);
        }
    }

    private static void angerBees(Player player) {
        if ((player.f_19853_.m_46472_().m_135782_().equals((Object)Bumblezone.MOD_DIMENSION_ID) || ((Boolean)BzBeeAggressionConfigs.allowWrathOfTheHiveOutsideBumblezone.get()).booleanValue()) && ((Boolean)BzBeeAggressionConfigs.aggressiveBees.get()).booleanValue() && !player.m_7500_() && !player.m_5833_() && !player.m_21023_((MobEffect)BzEffects.PROTECTION_OF_THE_HIVE.get())) {
            player.m_7292_(new MobEffectInstance((MobEffect)BzEffects.WRATH_OF_THE_HIVE.get(), ((Integer)BzBeeAggressionConfigs.howLongWrathOfTheHiveLasts.get()).intValue(), 2, false, ((Boolean)BzBeeAggressionConfigs.showWrathOfTheHiveParticles.get()).booleanValue(), true));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void beeHitAndAngered(Entity entity, Entity attackerEntity) {
        if (entity.f_19853_.m_5776_()) return;
        if (!(entity instanceof Bee)) return;
        if (attackerEntity == null) return;
        if (attackerEntity instanceof Player) {
            Player player = (Player)attackerEntity;
            if (!((Player)attackerEntity).m_7500_() && !attackerEntity.m_5833_()) {
                if (player.m_21023_((MobEffect)BzEffects.PROTECTION_OF_THE_HIVE.get())) {
                    player.m_21195_((MobEffect)BzEffects.PROTECTION_OF_THE_HIVE.get());
                    WrathOfTheHiveEffect.calmTheBees(player.f_19853_, (LivingEntity)player);
                    return;
                }
                if (!entity.f_19853_.m_46472_().m_135782_().equals((Object)Bumblezone.MOD_DIMENSION_ID)) {
                    if ((Boolean)BzBeeAggressionConfigs.allowWrathOfTheHiveOutsideBumblezone.get() == false) return;
                }
                if ((Boolean)BzBeeAggressionConfigs.aggressiveBees.get() == false) return;
                if (player instanceof ServerPlayer && player.m_21023_((MobEffect)BzEffects.WRATH_OF_THE_HIVE.get())) {
                    BzCriterias.EXTENDED_WRATH_OF_THE_HIVE_TRIGGER.trigger((ServerPlayer)player, attackerEntity);
                }
                player.m_7292_(new MobEffectInstance((MobEffect)BzEffects.WRATH_OF_THE_HIVE.get(), ((Integer)BzBeeAggressionConfigs.howLongWrathOfTheHiveLasts.get()).intValue(), 2, false, ((Boolean)BzBeeAggressionConfigs.showWrathOfTheHiveParticles.get()).booleanValue(), true));
                return;
            }
        }
        if (!(attackerEntity instanceof Mob)) return;
        Mob mob = (Mob)attackerEntity;
        if (mob.m_21023_((MobEffect)BzEffects.PROTECTION_OF_THE_HIVE.get())) {
            mob.m_21195_((MobEffect)BzEffects.PROTECTION_OF_THE_HIVE.get());
            WrathOfTheHiveEffect.calmTheBees(mob.f_19853_, (LivingEntity)mob);
            return;
        }
        if (!entity.f_19853_.m_46472_().m_135782_().equals((Object)Bumblezone.MOD_DIMENSION_ID)) {
            if ((Boolean)BzBeeAggressionConfigs.allowWrathOfTheHiveOutsideBumblezone.get() == false) return;
        }
        if ((Boolean)BzBeeAggressionConfigs.aggressiveBees.get() == false) return;
        mob.m_7292_(new MobEffectInstance((MobEffect)BzEffects.WRATH_OF_THE_HIVE.get(), ((Integer)BzBeeAggressionConfigs.howLongWrathOfTheHiveLasts.get()).intValue(), 2, false, true));
    }

    public static void entityTypeBeeAnger(Entity entity) {
        if (BeeAggression.doesBeesHateEntity(entity)) {
            ((Mob)entity).m_7292_(new MobEffectInstance((MobEffect)BzEffects.WRATH_OF_THE_HIVE.get(), ((Integer)BzBeeAggressionConfigs.howLongWrathOfTheHiveLasts.get()).intValue(), 1, false, true));
        }
    }

    public static boolean doesBeesHateEntity(Entity entity) {
        if (entity != null && entity.f_19853_ != null && !entity.f_19853_.m_5776_() && entity.f_19853_.m_46472_().m_135782_().equals((Object)Bumblezone.MOD_DIMENSION_ID) && ((Boolean)BzBeeAggressionConfigs.aggressiveBees.get()).booleanValue() && entity instanceof Mob) {
            Mob mobEntity = (Mob)entity;
            if (SET_OF_BEE_HATED_NAMED_ENTITIES.contains(entity.m_6095_()) || !SET_OF_BEE_NAMED_ENTITIES.contains(entity.m_6095_()) && mobEntity.m_6336_() == MobType.f_21642_) {
                return !mobEntity.m_21023_((MobEffect)BzEffects.WRATH_OF_THE_HIVE.get());
            }
        }
        return false;
    }

    public static void playerTick(TickEvent.PlayerTickEvent event) {
        Player playerEntity = event.player;
        if (!playerEntity.f_19853_.m_5776_() && playerEntity.m_21023_((MobEffect)BzEffects.WRATH_OF_THE_HIVE.get()) && !((Boolean)BzBeeAggressionConfigs.allowWrathOfTheHiveOutsideBumblezone.get()).booleanValue() && !playerEntity.f_19853_.m_46472_().m_135782_().equals((Object)Bumblezone.MOD_DIMENSION_ID)) {
            playerEntity.m_21195_((MobEffect)BzEffects.WRATH_OF_THE_HIVE.get());
            WrathOfTheHiveEffect.calmTheBees(playerEntity.f_19853_, (LivingEntity)playerEntity);
        }
        if (playerEntity.f_19853_.m_5776_()) {
            boolean wrathEffect = playerEntity.m_21023_((MobEffect)BzEffects.WRATH_OF_THE_HIVE.get());
            if (wrathEffect) {
                if (((Boolean)BzClientConfigs.playWrathOfHiveEffectMusic.get()).booleanValue()) {
                    MusicHandler.playAngryBeeMusic(playerEntity);
                } else {
                    MusicHandler.stopAngryBeeMusic(playerEntity);
                }
            }
            if (!WrathOfTheHiveEffect.ACTIVE_WRATH && wrathEffect) {
                WrathOfTheHiveEffect.ACTIVE_WRATH = true;
            } else if (WrathOfTheHiveEffect.ACTIVE_WRATH && !wrathEffect) {
                MusicHandler.stopAngryBeeMusic(playerEntity);
                WrathOfTheHiveEffect.calmTheBees(playerEntity.f_19853_, (LivingEntity)playerEntity);
                WrathOfTheHiveEffect.ACTIVE_WRATH = false;
            }
        }
    }
}

