/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.enchantments;

import com.telepathicgrunt.the_bumblezone.capabilities.BzCapabilities;
import com.telepathicgrunt.the_bumblezone.capabilities.NeurotoxinsMissCounter;
import com.telepathicgrunt.the_bumblezone.entities.nonliving.ThrownStingerSpearEntity;
import com.telepathicgrunt.the_bumblezone.items.StingerSpearItem;
import com.telepathicgrunt.the_bumblezone.mixin.entities.ThrownTridentAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import com.telepathicgrunt.the_bumblezone.modinit.BzEnchantments;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.event.entity.living.LivingAttackEvent;

public class NeurotoxinsEnchantment
extends Enchantment {
    public NeurotoxinsEnchantment() {
        super(Enchantment.Rarity.RARE, EnchantmentCategory.TRIDENT, new EquipmentSlot[]{EquipmentSlot.MAINHAND});
    }

    public int m_6183_(int level) {
        return 10 * level;
    }

    public int m_6175_(int level) {
        return super.m_6183_(level) + 50;
    }

    public int m_6586_() {
        return 2;
    }

    public boolean m_6081_(ItemStack stack) {
        return stack.m_41720_() instanceof StingerSpearItem;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return this.m_6081_(stack);
    }

    public static void entityHurtEvent(LivingAttackEvent event) {
        if (event.getEntityLiving().f_19853_.m_5776_()) {
            return;
        }
        ItemStack attackingItem = null;
        LivingEntity attacker = null;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity;
            attacker = livingEntity = (LivingEntity)entity;
            attackingItem = attacker.m_21205_();
        }
        if (event.getSource().m_19360_()) {
            Entity projectile = event.getSource().m_7640_();
            if (projectile instanceof ThrownTrident) {
                ThrownTrident thrownTrident = (ThrownTrident)projectile;
                attackingItem = ((ThrownTridentAccessor)thrownTrident).getTridentItem();
            } else if (projectile instanceof ThrownStingerSpearEntity) {
                ThrownStingerSpearEntity thrownStingerSpearEntity = (ThrownStingerSpearEntity)projectile;
                attackingItem = thrownStingerSpearEntity.getSpearItemStack();
            }
        }
        if (attackingItem != null && !attackingItem.m_41619_()) {
            NeurotoxinsEnchantment.applyNeurotoxins((Entity)attacker, (Entity)event.getEntityLiving(), attackingItem);
        }
    }

    public static void applyNeurotoxins(Entity attacker, Entity victim, ItemStack itemStack) {
        LivingEntity livingEntity;
        int level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)BzEnchantments.NEUROTOXINS.get()), (ItemStack)itemStack);
        if (level > 0 && victim instanceof LivingEntity && (livingEntity = (LivingEntity)victim).m_6336_() != MobType.f_21641_) {
            float applyChance = 1.0f;
            NeurotoxinsMissCounter capability = null;
            if (attacker != null) {
                capability = (NeurotoxinsMissCounter)attacker.getCapability(BzCapabilities.NEUROTOXINS_MISS_COUNTER_CAPABILITY).orElseThrow(RuntimeException::new);
                float healthModifier = Math.max(100.0f - livingEntity.m_21223_(), 10.0f) / 100.0f;
                applyChance = healthModifier * (float)level * (float)(capability.getMissedParalysis() + 1);
            }
            if (victim.f_19853_.f_46441_.nextFloat() < applyChance) {
                livingEntity.m_7292_(new MobEffectInstance((MobEffect)BzEffects.PARALYZED.get(), 100 * level, level, false, true, true));
                if (itemStack.m_41720_() == BzItems.STINGER_SPEAR.get() && attacker instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)attacker;
                    BzCriterias.STINGER_SPEAR_PARALYZING_TRIGGER.trigger(serverPlayer);
                    if (livingEntity.m_21223_() > 70.0f) {
                        BzCriterias.STINGER_SPEAR_PARALYZE_BOSS_TRIGGER.trigger(serverPlayer);
                    }
                }
                if (capability != null) {
                    capability.setMissedParalysis(0);
                }
            } else if (capability != null) {
                capability.setMissedParalysis(capability.getMissedParalysis() + 1);
            }
        }
    }
}

