/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.enchantments;

import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzEnchantments;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class CombCutterEnchantment
extends Enchantment {
    private static final GeneralUtils.Lazy<Set<Block>> TARGET_BLOCKS = new GeneralUtils.Lazy();
    private static final GeneralUtils.Lazy<Set<Block>> LESSER_TARGET_BLOCKS = new GeneralUtils.Lazy();

    public CombCutterEnchantment() {
        super(Enchantment.Rarity.RARE, EnchantmentCategory.BREAKABLE, new EquipmentSlot[]{EquipmentSlot.MAINHAND});
    }

    public Set<Block> getTargetBlocks() {
        return TARGET_BLOCKS.getOrCompute(() -> {
            HashSet validBlocks = new HashSet();
            ForgeRegistries.BLOCKS.getEntries().forEach(entry -> {
                if (((ResourceKey)entry.getKey()).m_135782_().m_135815_().contains("comb")) {
                    validBlocks.add((Block)entry.getValue());
                }
            });
            return validBlocks;
        });
    }

    public Set<Block> getLesserTargetBlocks() {
        return LESSER_TARGET_BLOCKS.getOrCompute(() -> {
            HashSet validBlocks = new HashSet();
            ForgeRegistries.BLOCKS.getEntries().forEach(entry -> {
                String path = ((ResourceKey)entry.getKey()).m_135782_().m_135815_();
                if (entry.getValue() instanceof BeehiveBlock || path.contains("hive") || path.contains("nest") || path.contains("wax") && !path.contains("waxed")) {
                    validBlocks.add((Block)entry.getValue());
                }
            });
            return validBlocks;
        });
    }

    public static void attemptFasterMining(PlayerEvent.BreakSpeed event) {
        if (((CombCutterEnchantment)((Object)BzEnchantments.COMB_CUTTER.get())).getTargetBlocks().contains(event.getState().m_60734_())) {
            CombCutterEnchantment.mineFaster(event, false);
        } else if (((CombCutterEnchantment)((Object)BzEnchantments.COMB_CUTTER.get())).getLesserTargetBlocks().contains(event.getState().m_60734_())) {
            CombCutterEnchantment.mineFaster(event, true);
        }
    }

    private static void mineFaster(PlayerEvent.BreakSpeed event, boolean lesserTarget) {
        float breakSpeed = event.getNewSpeed();
        Player playerEntity = event.getPlayer();
        ItemStack itemStack = playerEntity.m_21205_();
        int equipmentLevel = EnchantmentHelper.m_44836_((Enchantment)((Enchantment)BzEnchantments.COMB_CUTTER.get()), (LivingEntity)playerEntity);
        if (equipmentLevel > 0 && !itemStack.m_41619_()) {
            breakSpeed += (float)(equipmentLevel * equipmentLevel + (lesserTarget ? 3 : 13));
        }
        event.setNewSpeed(breakSpeed);
    }

    public static void increasedCombDrops(Player playerEntity, Level world, BlockPos pos) {
        ItemStack itemStack = playerEntity.m_21205_();
        int equipmentLevel = EnchantmentHelper.m_44836_((Enchantment)((Enchantment)BzEnchantments.COMB_CUTTER.get()), (LivingEntity)playerEntity);
        if (equipmentLevel > 0 && !itemStack.m_41619_()) {
            Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.f_42784_, equipmentLevel * 3));
            if (playerEntity instanceof ServerPlayer) {
                BzCriterias.COMB_CUTTER_EXTRA_DROPS_TRIGGER.trigger((ServerPlayer)playerEntity);
            }
        }
    }

    public int m_6183_(int level) {
        return 10 * (level - 1);
    }

    public int m_6175_(int level) {
        return super.m_6183_(level) + 13;
    }

    public int m_6586_() {
        return 1;
    }

    public boolean m_6081_(ItemStack stack) {
        return stack.m_41720_() instanceof ShearsItem || stack.m_41720_() instanceof SwordItem || stack.m_150930_(Items.f_42517_);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return this.m_6081_(stack);
    }
}

