/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.configs;

import net.minecraftforge.common.ForgeConfigSpec;

public class BzGeneralConfigs {
    public static final ForgeConfigSpec GENERAL_SPEC;
    public static ForgeConfigSpec.DoubleValue beehemothSpeed;
    public static ForgeConfigSpec.BooleanValue specialBeeSpawning;
    public static ForgeConfigSpec.IntValue nearbyBeesPerPlayerInBz;
    public static ForgeConfigSpec.BooleanValue dispensersDropGlassBottles;
    public static ForgeConfigSpec.IntValue broodBlocksBeeSpawnCapacity;

    private static void setupConfig(ForgeConfigSpec.Builder builder) {
        builder.push("Beehemoth Options");
        beehemothSpeed = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Base speed for the Beehemoth when being rode by a player.\n"}).translation("the_bumblezone.config.beehemothSpeed").defineInRange("beehemothSpeed", 0.95, 0.0, 100.0);
        builder.pop();
        builder.push("Special Bee Spawning Options");
        specialBeeSpawning = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Whether Bumblezone will handle spawning vanilla bees near players in the Bumblezone to make it feel full of Bees.", " Bees too far will be despawned in Bumblezone unless the bee has a hive, is name tagged, or is set to persistent.", " Note: Modded bees will not be spawned through this system. Those will be spawned by normal biome spawning.\n"}).translation("the_bumblezone.config.specialbeespawning").define("specialBeeSpawning", true);
        nearbyBeesPerPlayerInBz = builder.comment(new String[]{" \n-----------------------------------------------------\n", " If specialBeeSpawning is set to true, this config controls how many vanilla bees should be", " near each player in Bumblezone dimension. Higher numbers like 100 is insane lol. 25 is nice.\n"}).translation("the_bumblezone.config.nearbybeesperplayerinbz").defineInRange("nearbyBeesPerPlayerInBz", 25, 0, 1000);
        builder.pop();
        builder.push("General Mechanics Options");
        dispensersDropGlassBottles = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Should Dispensers always drop the Glass Bottle when using specific ", " bottle items on certain The Bumblezone blocks? ", " ", " Example: Using Honey Bottle to feed Honeycomb Brood Blocks will grow the larva and", " drop the Glass Bottle instead of putting it back into Dispenser if this is set to true.\n"}).translation("the_bumblezone.config.dispensersdropglassbottles").define("dispensersDropGlassBottles", false);
        broodBlocksBeeSpawnCapacity = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Brood Blocks will automatically spawn bees until the number of active bees is the value below. ", " Set this higher to allow Brood Blocks to spawn more bees in a smaller area or set it to 0 to turn ", " off automatic Brood Block bee spawning.\n"}).translation("the_bumblezone.config.broodblocksbeespawncapacity").defineInRange("broodBlocksBeeSpawnCapacity", 60, 0, 1000);
        builder.pop();
    }

    static {
        ForgeConfigSpec.Builder configBuilder = new ForgeConfigSpec.Builder();
        BzGeneralConfigs.setupConfig(configBuilder);
        GENERAL_SPEC = configBuilder.build();
    }
}

