/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.rendering;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import net.minecraft.client.Camera;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;

public class FluidClientOverlay {
    private static final ResourceLocation TEXTURE_UNDERWATER = new ResourceLocation("the_bumblezone", "textures/misc/sugar_water_underwater.png");
    private static final ResourceLocation HONEY_TEXTURE_UNDERWATER = new ResourceLocation("the_bumblezone:textures/misc/honey_fluid_underwater.png");

    public static void sugarWaterFluidOverlay(RenderBlockOverlayEvent event) {
        Player player = event.getPlayer();
        PoseStack matrixStack = event.getPoseStack();
        if (!(player instanceof LocalPlayer)) {
            return;
        }
        LocalPlayer clientPlayerEntity = (LocalPlayer)player;
        BlockState state = player.f_19853_.m_8055_(new BlockPos(player.m_20299_(0.0f)));
        if (state.m_60713_((Block)BzFluids.SUGAR_WATER_BLOCK.get())) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_69493_();
            RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE_UNDERWATER);
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            float brightnessAtEyes = clientPlayerEntity.m_6073_();
            float textureAlpha = 0.42f;
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_157429_((float)brightnessAtEyes, (float)brightnessAtEyes, (float)brightnessAtEyes, (float)textureAlpha);
            float modifiedYaw = -clientPlayerEntity.m_146908_() / 64.0f;
            float modifiedPitch = clientPlayerEntity.m_146909_() / 64.0f;
            Matrix4f matrix4f = matrixStack.m_85850_().m_85861_();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            bufferBuilder.m_85982_(matrix4f, -1.0f, -1.0f, -0.5f).m_7421_(4.0f + modifiedYaw, 4.0f + modifiedPitch).m_5752_();
            bufferBuilder.m_85982_(matrix4f, 1.0f, -1.0f, -0.5f).m_7421_(0.0f + modifiedYaw, 4.0f + modifiedPitch).m_5752_();
            bufferBuilder.m_85982_(matrix4f, 1.0f, 1.0f, -0.5f).m_7421_(0.0f + modifiedYaw, 0.0f + modifiedPitch).m_5752_();
            bufferBuilder.m_85982_(matrix4f, -1.0f, 1.0f, -0.5f).m_7421_(4.0f + modifiedYaw, 0.0f + modifiedPitch).m_5752_();
            bufferBuilder.m_85721_();
            BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
            RenderSystem.m_69461_();
        }
    }

    public static boolean renderHoneyOverlay(LocalPlayer clientPlayerEntity, PoseStack matrixStack) {
        if (!clientPlayerEntity.m_204029_(BzTags.BZ_HONEY_FLUID)) {
            return false;
        }
        BlockState state = clientPlayerEntity.f_19853_.m_8055_(new BlockPos(clientPlayerEntity.m_20299_(1.0f)));
        if (state.m_60713_((Block)BzFluids.HONEY_FLUID_BLOCK.get())) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_69493_();
            RenderSystem.m_157456_((int)0, (ResourceLocation)HONEY_TEXTURE_UNDERWATER);
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            float brightness = (float)Math.max(Math.pow(FluidClientOverlay.getDimensionBrightnessAtEyes((Entity)clientPlayerEntity), 2.0), (double)clientPlayerEntity.f_19853_.m_6042_().m_63902_(0));
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_157429_((float)brightness, (float)brightness, (float)brightness, (float)0.95f);
            float modifiedYaw = -clientPlayerEntity.m_146908_() / 512.0f;
            float modifiedPitch = clientPlayerEntity.m_146909_() / 512.0f;
            Matrix4f matrix4f = matrixStack.m_85850_().m_85861_();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            bufferBuilder.m_85982_(matrix4f, -1.0f, -1.0f, -0.5f).m_7421_(1.0f + modifiedYaw, 1.0f + modifiedPitch).m_5752_();
            bufferBuilder.m_85982_(matrix4f, 1.0f, -1.0f, -0.5f).m_7421_(0.0f + modifiedYaw, 2.0f + modifiedPitch).m_5752_();
            bufferBuilder.m_85982_(matrix4f, 1.0f, 1.0f, -0.5f).m_7421_(1.0f + modifiedYaw, 1.0f + modifiedPitch).m_5752_();
            bufferBuilder.m_85982_(matrix4f, -1.0f, 1.0f, -0.5f).m_7421_(2.0f + modifiedYaw, 0.0f + modifiedPitch).m_5752_();
            bufferBuilder.m_85721_();
            BufferUploader.m_85761_((BufferBuilder)bufferBuilder);
            RenderSystem.m_69461_();
            return true;
        }
        return false;
    }

    public static void renderHoneyFog(EntityViewRenderEvent.RenderFogEvent event) {
        FluidState fluidstate = FluidClientOverlay.getNearbyHoneyFluid(event.getCamera());
        if (fluidstate.m_205070_(BzTags.BZ_HONEY_FLUID)) {
            RenderSystem.m_157445_((float)0.35f);
            RenderSystem.m_157443_((float)4.0f);
        }
    }

    public static float getDimensionBrightnessAtEyes(Entity entity) {
        float lightLevelAtEyes = entity.f_19853_.m_45524_(new BlockPos(entity.m_20299_(1.0f)), 0);
        return lightLevelAtEyes / 15.0f;
    }

    public static FluidState getNearbyHoneyFluid(Camera camera) {
        Entity entity = camera.m_90592_();
        Level world = entity.f_19853_;
        FluidState fluidstate = world.m_6425_(camera.m_90588_());
        Vec3 currentPos = camera.m_90583_();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        double offsetDistanceCheck = 0.075;
        for (Direction direction : Direction.values()) {
            FluidState neighboringFluidstate;
            double x = currentPos.m_7096_() + (double)direction.m_122429_() * offsetDistanceCheck;
            double y = currentPos.m_7098_() + (double)direction.m_122430_() * offsetDistanceCheck;
            double z = currentPos.m_7094_() + (double)direction.m_122431_() * offsetDistanceCheck;
            mutable.m_122169_(x, y, z);
            if (mutable.equals((Object)camera.m_90588_()) || !(neighboringFluidstate = world.m_6425_((BlockPos)mutable)).m_205070_(BzTags.BZ_HONEY_FLUID)) continue;
            fluidstate = neighboringFluidstate;
        }
        return fluidstate;
    }
}

