/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client;

import com.telepathicgrunt.the_bumblezone.client.BeehemothControls;
import com.telepathicgrunt.the_bumblezone.client.items.HoneyCompassItemProperty;
import com.telepathicgrunt.the_bumblezone.client.particles.HoneyParticle;
import com.telepathicgrunt.the_bumblezone.client.particles.PollenPuff;
import com.telepathicgrunt.the_bumblezone.client.rendering.BeeArmorModel;
import com.telepathicgrunt.the_bumblezone.client.rendering.BeeVariantRenderer;
import com.telepathicgrunt.the_bumblezone.client.rendering.BeehemothModel;
import com.telepathicgrunt.the_bumblezone.client.rendering.BeehemothRenderer;
import com.telepathicgrunt.the_bumblezone.client.rendering.FluidClientOverlay;
import com.telepathicgrunt.the_bumblezone.client.rendering.HoneySlimeRendering;
import com.telepathicgrunt.the_bumblezone.client.rendering.PileOfPollenRenderer;
import com.telepathicgrunt.the_bumblezone.client.rendering.StingerSpearModel;
import com.telepathicgrunt.the_bumblezone.client.rendering.StingerSpearRenderer;
import com.telepathicgrunt.the_bumblezone.configs.BzClientConfigs;
import com.telepathicgrunt.the_bumblezone.items.BeeCannon;
import com.telepathicgrunt.the_bumblezone.mixin.client.DimensionSpecialEffectsAccessor;
import com.telepathicgrunt.the_bumblezone.mixin.client.RenderingRegistryAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzMenuTypes;
import com.telepathicgrunt.the_bumblezone.modinit.BzParticles;
import com.telepathicgrunt.the_bumblezone.screens.StrictChestScreen;
import com.telepathicgrunt.the_bumblezone.world.dimension.BzSkyProperty;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class BumblezoneClient {
    public static void subscribeClientEvents() {
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(BumblezoneClient::onClientSetup);
        modEventBus.addListener(BumblezoneClient::onParticleSetup);
        modEventBus.addListener(BumblezoneClient::registerEntityRenderers);
        modEventBus.addListener(BumblezoneClient::registerEntityModels);
        forgeBus.addListener(FluidClientOverlay::sugarWaterFluidOverlay);
        forgeBus.addListener(FluidClientOverlay::renderHoneyFog);
        forgeBus.addListener(PileOfPollenRenderer::pileOfPollenOverlay);
        forgeBus.addListener(BeehemothControls::keyInput);
        ClientRegistry.registerKeyBinding((KeyMapping)BeehemothControls.KEY_BIND_BEEHEMOTH_UP);
        ClientRegistry.registerKeyBinding((KeyMapping)BeehemothControls.KEY_BIND_BEEHEMOTH_DOWN);
    }

    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            DimensionSpecialEffectsAccessor.thebumblezone_getBY_ResourceLocation().put((Object)new ResourceLocation("the_bumblezone", "sky_property"), (Object)new BzSkyProperty());
            BumblezoneClient.registerRenderLayers();
            if (((Boolean)BzClientConfigs.enableAltBeeSkinRenderer.get()).booleanValue()) {
                BeeVariantRenderer.OLD_BEE_RENDER_FACTORY = RenderingRegistryAccessor.getEntityRenderers().get(EntityType.f_20550_);
                EntityRenderers.m_174036_((EntityType)EntityType.f_20550_, BeeVariantRenderer::new);
            }
            ItemProperties.register((Item)((Item)BzItems.HONEY_CRYSTAL_SHIELD.get()), (ResourceLocation)new ResourceLocation("blocking"), (itemStack, world, livingEntity, integer) -> livingEntity != null && livingEntity.m_6117_() && livingEntity.m_21211_() == itemStack ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)BzItems.STINGER_SPEAR.get()), (ResourceLocation)new ResourceLocation("throwing"), (itemStack, world, livingEntity, integer) -> livingEntity != null && livingEntity.m_6117_() && livingEntity.m_21211_() == itemStack ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)BzItems.HONEY_COMPASS.get()), (ResourceLocation)new ResourceLocation("angle"), (ItemPropertyFunction)HoneyCompassItemProperty.getClampedItemPropertyFunction());
            ItemProperties.register((Item)((Item)BzItems.BEE_CANNON.get()), (ResourceLocation)new ResourceLocation("primed"), (itemStack, world, livingEntity, int1) -> livingEntity != null && livingEntity.m_6117_() && livingEntity.m_21211_() == itemStack ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)BzItems.BEE_CANNON.get()), (ResourceLocation)new ResourceLocation("bee_count"), (itemStack, world, livingEntity, int1) -> (float)BeeCannon.getNumberOfBees(itemStack) / 10.0f);
            MenuScreens.m_96206_((MenuType)((MenuType)BzMenuTypes.STRICT_9x1.get()), StrictChestScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)BzMenuTypes.STRICT_9x2.get()), StrictChestScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)BzMenuTypes.STRICT_9x3.get()), StrictChestScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)BzMenuTypes.STRICT_9x4.get()), StrictChestScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)BzMenuTypes.STRICT_9x5.get()), StrictChestScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)BzMenuTypes.STRICT_9x6.get()), StrictChestScreen::new);
        });
    }

    private static void registerRenderLayers() {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BzBlocks.STICKY_HONEY_REDSTONE.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BzBlocks.STICKY_HONEY_RESIDUE.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BzBlocks.HONEY_WEB.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BzBlocks.REDSTONE_HONEY_WEB.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BzBlocks.HONEY_CRYSTAL.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)BzFluids.SUGAR_WATER_FLUID.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)BzFluids.SUGAR_WATER_FLUID_FLOWING.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BzFluids.SUGAR_WATER_BLOCK.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)BzFluids.HONEY_FLUID.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)BzFluids.HONEY_FLUID_FLOWING.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BzFluids.HONEY_FLUID_BLOCK.get()), (RenderType)RenderType.m_110466_());
    }

    public static void registerEntityModels(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(BeehemothModel.LAYER_LOCATION, BeehemothModel::createBodyLayer);
        event.registerLayerDefinition(StingerSpearModel.LAYER_LOCATION, StingerSpearModel::createLayer);
        event.registerLayerDefinition(BeeArmorModel.VARIANT_1_LAYER_LOCATION, BeeArmorModel::createVariant1);
        event.registerLayerDefinition(BeeArmorModel.VARIANT_2_LAYER_LOCATION, BeeArmorModel::createVariant2);
    }

    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        EntityRenderers.m_174036_((EntityType)((EntityType)BzEntities.HONEY_SLIME.get()), HoneySlimeRendering::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)BzEntities.BEEHEMOTH.get()), BeehemothRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)BzEntities.POLLEN_PUFF_ENTITY.get()), ThrownItemRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)BzEntities.THROWN_STINGER_SPEAR_ENTITY.get()), StingerSpearRenderer::new);
    }

    public static void onParticleSetup(ParticleFactoryRegisterEvent event) {
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)BzParticles.POLLEN.get(), PollenPuff.Factory::new);
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)BzParticles.HONEY_PARTICLE.get(), HoneyParticle.Factory::new);
    }
}

