/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.mojang.math.Vector3f;
import com.telepathicgrunt.the_bumblezone.blocks.HoneyWeb;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import java.util.List;
import java.util.Random;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RedstoneHoneyWeb
extends HoneyWeb {
    public static final IntegerProperty POWER = BlockStateProperties.f_61426_;
    private static final Vec3[] COLORS = (Vec3[])Util.m_137469_((Object)new Vec3[16], vec3s -> {
        for (int powerLevel = 0; powerLevel <= 15; ++powerLevel) {
            float brightness;
            float red = brightness * 0.6f + ((brightness = (float)powerLevel / 15.0f) > 0.0f ? 0.4f : 0.3f);
            float green = Mth.m_14036_((float)(brightness * brightness * 0.7f - 0.5f), (float)0.0f, (float)1.0f);
            float blue = Mth.m_14036_((float)(brightness * brightness * 0.6f - 0.7f), (float)0.0f, (float)1.0f);
            vec3s[powerLevel] = new Vec3((double)red, (double)green, (double)blue);
        }
    });

    public RedstoneHoneyWeb() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76311_, (MaterialColor)MaterialColor.f_76413_).m_60910_().m_60999_().m_60978_(4.0f).m_60953_(blockState -> ((Integer)blockState.m_61143_((Property)POWER) + 9) / 10));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)NORTHSOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EASTWEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UPDOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWER, (Comparable)Integer.valueOf(0)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.m_61104_(new Property[]{NORTHSOUTH, EASTWEST, UPDOWN, POWER});
    }

    @Override
    public void m_7892_(BlockState blockState, Level level, BlockPos blockPos, Entity entity) {
        super.m_7892_(blockState, level, blockPos, entity);
        VoxelShape shape = this.shapeByIndex[this.getAABBIndex(blockState)];
        shape = shape.m_83216_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
        if (Shapes.m_83157_((VoxelShape)shape, (VoxelShape)Shapes.m_83064_((AABB)entity.m_142469_()), (BooleanOp)BooleanOp.f_82689_) && blockState.m_60713_((Block)this) && (Integer)blockState.m_61143_((Property)POWER) != 15) {
            level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)POWER, (Comparable)Integer.valueOf(15)), 3);
            level.m_186460_(new BlockPos((Vec3i)blockPos), (Block)this, 10);
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                BzCriterias.TRIGGER_REDSTONE_HONEY_WEB_TRIGGER.trigger(serverPlayer);
            }
        }
    }

    public void m_7458_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, Random random) {
        if ((Integer)serverLevel.m_8055_(blockPos).m_61143_((Property)POWER) == 15) {
            boolean noEntitiesInbounds = true;
            List list = serverLevel.m_45933_(null, blockState.m_60808_((BlockGetter)serverLevel, blockPos).m_83215_().m_82338_(blockPos));
            if (!list.isEmpty()) {
                for (Entity entity : list) {
                    if (entity.m_6090_()) continue;
                    noEntitiesInbounds = false;
                    break;
                }
            }
            if (noEntitiesInbounds) {
                serverLevel.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)POWER, (Comparable)Integer.valueOf(0)), 3);
            } else {
                serverLevel.m_186460_(new BlockPos((Vec3i)blockPos), (Block)this, 10);
            }
        }
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext placeContext) {
        return super.m_5573_(placeContext);
    }

    public void m_6807_(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState1, boolean pushed) {
        if (!blockState1.m_60713_(blockState.m_60734_()) && !level.f_46443_) {
            this.updatePowerStrength(level, blockState, blockPos);
            for (Direction direction : Direction.Plane.VERTICAL) {
                level.m_46672_(blockPos.m_142300_(direction), (Block)this);
            }
        }
    }

    public void m_6810_(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState1, boolean pushed) {
        if (!pushed && !blockState.m_60713_(blockState1.m_60734_())) {
            super.m_6810_(blockState, level, blockPos, blockState1, pushed);
            if (!level.f_46443_) {
                for (Direction direction : Direction.values()) {
                    level.m_46672_(blockPos.m_142300_(direction), (Block)this);
                }
            }
        }
    }

    public void m_6861_(BlockState blockState, Level level, BlockPos blockPos, Block block, BlockPos blockPos1, boolean b) {
        if (!level.f_46443_ && blockState.m_60713_((Block)this) && (Integer)blockState.m_61143_((Property)POWER) != 15) {
            this.updatePowerStrength(level, blockState, blockPos);
        }
    }

    private void updatePowerStrength(Level level, BlockState blockState, BlockPos blockPos) {
        int currentPower = this.calculateTargetStrength(level, blockState, blockPos);
        if ((Integer)blockState.m_61143_((Property)POWER) != currentPower) {
            if (level.m_8055_(blockPos) == blockState) {
                level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)POWER, (Comparable)Integer.valueOf(currentPower)), 3);
            }
            for (Direction direction : Direction.values()) {
                level.m_46672_(blockPos.m_142300_(direction), (Block)this);
            }
        }
    }

    private int calculateTargetStrength(Level level, BlockState centerState, BlockPos blockPos) {
        int decreasingPower = 0;
        for (Direction direction : Direction.values()) {
            BlockPos blockpos2 = blockPos.m_142300_(direction);
            BlockState neighborState = level.m_8055_(blockpos2);
            decreasingPower = Math.max(decreasingPower, this.getWireSignal(centerState, neighborState));
        }
        return Math.max(0, decreasingPower - 1);
    }

    private int getWireSignal(BlockState centerState, BlockState neighborState) {
        if (neighborState.m_60713_((Block)this)) {
            if (((Boolean)centerState.m_61143_((Property)NORTHSOUTH)).booleanValue() && ((Boolean)neighborState.m_61143_((Property)NORTHSOUTH)).booleanValue()) {
                return (Integer)neighborState.m_61143_((Property)POWER);
            }
            if (((Boolean)centerState.m_61143_((Property)EASTWEST)).booleanValue() && ((Boolean)neighborState.m_61143_((Property)EASTWEST)).booleanValue()) {
                return (Integer)neighborState.m_61143_((Property)POWER);
            }
            if (((Boolean)centerState.m_61143_((Property)UPDOWN)).booleanValue() && ((Boolean)neighborState.m_61143_((Property)UPDOWN)).booleanValue()) {
                return (Integer)neighborState.m_61143_((Property)POWER);
            }
        }
        return 0;
    }

    public boolean m_7899_(BlockState state) {
        return true;
    }

    public int m_6378_(BlockState thisState, BlockGetter blockAccess, BlockPos pos, Direction direction) {
        int power = (Integer)thisState.m_61143_((Property)POWER);
        BlockState parentState = blockAccess.m_8055_(pos.m_142300_(direction.m_122424_()));
        if (power > 0 && !parentState.m_60713_((Block)this)) {
            if (direction.m_122434_() != Direction.Axis.X && ((Boolean)thisState.m_61143_((Property)NORTHSOUTH)).booleanValue()) {
                return power;
            }
            if (direction.m_122434_() != Direction.Axis.Z && ((Boolean)thisState.m_61143_((Property)EASTWEST)).booleanValue()) {
                return power;
            }
            if (direction.m_122434_() != Direction.Axis.Y && ((Boolean)thisState.m_61143_((Property)UPDOWN)).booleanValue()) {
                return power;
            }
        }
        return 0;
    }

    public int m_6376_(BlockState blockstate, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return 0;
    }

    @Override
    public void m_7100_(BlockState blockState, Level world, BlockPos position, Random random) {
        super.m_7100_(blockState, world, position, random);
        int power = (Integer)blockState.m_61143_((Property)POWER);
        if (power != 0) {
            for (int i = 0; i == random.nextInt(35); ++i) {
                this.addRedstoneParticle(world, position, blockState.m_60808_((BlockGetter)world, position), power);
            }
        }
    }

    private void addRedstoneParticle(Level world, BlockPos blockPos, VoxelShape blockShape, int power) {
        this.addRedstoneParticle(world, (double)blockPos.m_123341_() + blockShape.m_83288_(Direction.Axis.X), (double)blockPos.m_123341_() + blockShape.m_83297_(Direction.Axis.X), (double)blockPos.m_123342_() + blockShape.m_83288_(Direction.Axis.Y), (double)blockPos.m_123342_() + blockShape.m_83297_(Direction.Axis.Y), (double)blockPos.m_123343_() + blockShape.m_83288_(Direction.Axis.Z), (double)blockPos.m_123343_() + blockShape.m_83297_(Direction.Axis.Z), power);
    }

    private void addRedstoneParticle(Level world, double xMin, double xMax, double yMin, double yMax, double zMax, double zMin, int power) {
        world.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(COLORS[power]), 1.0f), Mth.m_14139_((double)world.f_46441_.nextDouble(), (double)xMin, (double)xMax), Mth.m_14139_((double)world.f_46441_.nextDouble(), (double)yMin, (double)yMax), Mth.m_14139_((double)world.f_46441_.nextDouble(), (double)zMax, (double)zMin), 0.0, 0.0, 0.0);
    }
}

