/*
 * Decompiled with CFR 0.152.
 */
package com.catastrophe573.dimdungeons.utils;

import com.catastrophe573.dimdungeons.dimension.DungeonData;
import com.catastrophe573.dimdungeons.dimension.PersonalBuildData;
import com.catastrophe573.dimdungeons.item.ItemBlankBuildKey;
import com.catastrophe573.dimdungeons.item.ItemPortalKey;
import com.catastrophe573.dimdungeons.item.ItemRegistrar;
import com.catastrophe573.dimdungeons.structure.DungeonRoom;
import com.catastrophe573.dimdungeons.utils.DungeonUtils;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class CommandDimDungeons {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder argumentBuilder = (LiteralArgumentBuilder)Commands.m_82127_((String)"dimdungeons").requires(cmd -> cmd.m_6761_(2));
        String[] keytypes = new String[]{"blank", "basic", "advanced"};
        for (int i = 0; i < keytypes.length; ++i) {
            String type = keytypes[i];
            argumentBuilder.then(Commands.m_82127_((String)"givekey").then(((LiteralArgumentBuilder)Commands.m_82127_((String)type).executes(cmd -> CommandDimDungeons.giveKey((CommandContext<CommandSourceStack>)cmd, Collections.singleton(((CommandSourceStack)cmd.getSource()).m_81375_()), type, 0))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"recipient", (ArgumentType)EntityArgument.m_91470_()).executes(cmd -> CommandDimDungeons.giveKey((CommandContext<CommandSourceStack>)cmd, EntityArgument.m_91477_((CommandContext)cmd, (String)"recipient"), type, 0))).then(Commands.m_82129_((String)"theme", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(cmd -> CommandDimDungeons.giveKey((CommandContext<CommandSourceStack>)cmd, EntityArgument.m_91477_((CommandContext)cmd, (String)"recipient"), type, IntegerArgumentType.getInteger((CommandContext)cmd, (String)"theme")))))));
        }
        argumentBuilder.then(Commands.m_82127_((String)"givepersonal").then(Commands.m_82129_((String)"recipient", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"target_player", (ArgumentType)EntityArgument.m_91466_()).executes(cmd -> CommandDimDungeons.givePersonalKey((CommandContext<CommandSourceStack>)cmd, EntityArgument.m_91477_((CommandContext)cmd, (String)"recipient"), EntityArgument.m_91474_((CommandContext)cmd, (String)"target_player"))))));
        argumentBuilder.then(Commands.m_82127_((String)"getroom").then(Commands.m_82129_((String)"target_player", (ArgumentType)EntityArgument.m_91466_()).executes(cmd -> CommandDimDungeons.printRoomName((CommandContext<CommandSourceStack>)cmd, (Entity)EntityArgument.m_91474_((CommandContext)cmd, (String)"target_player")))));
        dispatcher.register(argumentBuilder);
    }

    private static int giveKey(CommandContext<CommandSourceStack> cmd, Collection<ServerPlayer> recipients, String type, int theme) throws CommandSyntaxException {
        TranslatableComponent keyName = new TranslatableComponent("item.dimdungeons.item_portal_key");
        for (ServerPlayer serverplayerentity : recipients) {
            ItemEntity itementity;
            ItemStack stack = new ItemStack((ItemLike)ItemRegistrar.item_portal_key);
            if ("blank".equals(type)) {
                keyName = new TranslatableComponent("item.dimdungeons.item_portal_key");
            } else if ("basic".equals(type)) {
                ((ItemPortalKey)ItemRegistrar.item_portal_key.m_5456_()).activateKeyLevel1(((CommandSourceStack)cmd.getSource()).m_81377_(), stack, theme);
                keyName = new TranslatableComponent("item.dimdungeons.item_portal_key_basic");
            } else if ("advanced".equals(type)) {
                ((ItemPortalKey)ItemRegistrar.item_portal_key.m_5456_()).activateKeyLevel2(((CommandSourceStack)cmd.getSource()).m_81377_(), stack);
                keyName = new TranslatableComponent("item.dimdungeons.item_portal_key_advanced");
            }
            boolean flag = serverplayerentity.m_150109_().m_36054_(stack);
            if (flag && stack.m_41619_()) {
                stack.m_41764_(1);
                itementity = serverplayerentity.m_36176_(stack, false);
                if (itementity != null) {
                    itementity.m_32065_();
                }
                serverplayerentity.f_19853_.m_6263_((Player)null, serverplayerentity.m_20185_(), serverplayerentity.m_20186_(), serverplayerentity.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((serverplayerentity.m_21187_().nextFloat() - serverplayerentity.m_21187_().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                serverplayerentity.f_36095_.m_38946_();
                continue;
            }
            itementity = serverplayerentity.m_36176_(stack, false);
            if (itementity == null) continue;
            itementity.m_32061_();
            itementity.m_32047_(serverplayerentity.m_142081_());
        }
        if (recipients.size() == 1) {
            ((CommandSourceStack)cmd.getSource()).m_81354_((Component)new TranslatableComponent("commands.give.success.single", new Object[]{1, keyName, recipients.iterator().next().m_5446_()}), true);
        } else {
            ((CommandSourceStack)cmd.getSource()).m_81354_((Component)new TranslatableComponent("commands.give.success.single", new Object[]{1, keyName, recipients.size()}), true);
        }
        return recipients.size();
    }

    private static int givePersonalKey(CommandContext<CommandSourceStack> cmd, Collection<ServerPlayer> recipients, ServerPlayer targetPlayer) throws CommandSyntaxException {
        TranslatableComponent keyName = new TranslatableComponent("item.dimdungeons.item_build_key");
        for (ServerPlayer serverplayerentity : recipients) {
            ItemEntity itementity;
            ItemStack newkey = new ItemStack((ItemLike)ItemRegistrar.ITEM_BUILD_KEY.get());
            ((ItemBlankBuildKey)((Object)ItemRegistrar.ITEM_BLANK_BUILD_KEY.get())).activateBuildKey(((CommandSourceStack)cmd.getSource()).m_81377_(), newkey, (LivingEntity)targetPlayer);
            boolean flag = serverplayerentity.m_150109_().m_36054_(newkey);
            if (flag && newkey.m_41619_()) {
                newkey.m_41764_(1);
                itementity = serverplayerentity.m_36176_(newkey, false);
                if (itementity != null) {
                    itementity.m_32065_();
                }
                serverplayerentity.f_19853_.m_6263_((Player)null, serverplayerentity.m_20185_(), serverplayerentity.m_20186_(), serverplayerentity.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((serverplayerentity.m_21187_().nextFloat() - serverplayerentity.m_21187_().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                serverplayerentity.f_36095_.m_38946_();
                continue;
            }
            itementity = serverplayerentity.m_36176_(newkey, false);
            if (itementity == null) continue;
            itementity.m_32061_();
            itementity.m_32047_(serverplayerentity.m_142081_());
        }
        if (recipients.size() == 1) {
            ((CommandSourceStack)cmd.getSource()).m_81354_((Component)new TranslatableComponent("commands.give.success.single", new Object[]{1, keyName, recipients.iterator().next().m_5446_()}), true);
        } else {
            ((CommandSourceStack)cmd.getSource()).m_81354_((Component)new TranslatableComponent("commands.give.success.single", new Object[]{1, keyName, recipients.size()}), true);
        }
        return recipients.size();
    }

    private static int givePersonalKeyForAnyEntity(CommandContext<CommandSourceStack> cmd, Collection<ServerPlayer> recipients, Entity targetPlayer) throws CommandSyntaxException {
        Object keyName = "Personal Dimension Key";
        if (!(targetPlayer instanceof LivingEntity)) {
            ((CommandSourceStack)cmd.getSource()).m_81352_((Component)new TextComponent("Target entity is not a LivingEntity."));
            return 0;
        }
        for (ServerPlayer serverplayerentity : recipients) {
            ItemStack newkey = new ItemStack((ItemLike)ItemRegistrar.ITEM_BUILD_KEY.get());
            ((ItemBlankBuildKey)((Object)ItemRegistrar.ITEM_BLANK_BUILD_KEY.get())).activateBuildKey(((CommandSourceStack)cmd.getSource()).m_81377_(), newkey, (LivingEntity)targetPlayer);
            int dest_x = newkey.m_41783_().m_128451_("dest_x");
            int dest_z = newkey.m_41783_().m_128451_("dest_z");
            keyName = "Personal Key: (" + dest_x + ", " + dest_z + ")";
            newkey.m_41714_((Component)new TextComponent((String)keyName));
            serverplayerentity.m_150109_().m_36054_(newkey);
        }
        if (recipients.size() == 1) {
            ((CommandSourceStack)cmd.getSource()).m_81354_((Component)new TranslatableComponent("commands.give.success.single", new Object[]{1, keyName, recipients.iterator().next().m_5446_()}), true);
        } else {
            ((CommandSourceStack)cmd.getSource()).m_81354_((Component)new TranslatableComponent("commands.give.success.single", new Object[]{1, keyName, recipients.size()}), true);
        }
        return recipients.size();
    }

    private static int printRoomName(CommandContext<CommandSourceStack> cmd, Entity targetPlayer) throws CommandSyntaxException {
        if (!(targetPlayer instanceof LivingEntity)) {
            ((CommandSourceStack)cmd.getSource()).m_81352_((Component)new TextComponent("Target entity is not a LivingEntity."));
            return 0;
        }
        Level dungeonWorld = targetPlayer.m_183503_();
        if (!DungeonUtils.isDimensionDungeon(dungeonWorld)) {
            ((CommandSourceStack)cmd.getSource()).m_81352_((Component)new TextComponent("This command only works in the dungeon dimension."));
            return 0;
        }
        DungeonRoom room = DungeonData.get(dungeonWorld).getRoomAtPos(targetPlayer.m_146902_());
        if (room == null) {
            ((CommandSourceStack)cmd.getSource()).m_81352_((Component)new TextComponent("No room found at current position."));
            return 0;
        }
        TextComponent text = new TextComponent("room: " + room.structure + " rot: " + room.rotation);
        text.m_130948_(text.m_7383_().m_131155_(Boolean.valueOf(true)));
        text.m_130948_(text.m_7383_().m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.BLUE)));
        ((CommandSourceStack)cmd.getSource()).m_81354_((Component)text, true);
        return 1;
    }

    private static int erasePersonalMap(CommandContext<CommandSourceStack> cmd) throws CommandSyntaxException {
        PersonalBuildData.get((Level)DungeonUtils.getPersonalBuildWorld(((CommandSourceStack)cmd.getSource()).m_81377_())).debugClearKnownOwners();
        ((CommandSourceStack)cmd.getSource()).m_81354_((Component)new TextComponent("Deleted all known personal key associations."), true);
        return 0;
    }
}

